/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IProblemType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCastExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalTypeId;

public class CPPASTCastExpression
extends ASTNode
implements ICPPASTCastExpression,
IASTAmbiguityParent {
    private int op;
    private ICPPASTExpression operand;
    private IASTTypeId typeId;
    private ICPPEvaluation fEvaluation;

    public CPPASTCastExpression() {
    }

    public CPPASTCastExpression(int operator, IASTTypeId typeId, IASTExpression operand) {
        this.op = operator;
        this.setOperand(operand);
        this.setTypeId(typeId);
    }

    @Override
    public CPPASTCastExpression copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTCastExpression copy(IASTNode.CopyStyle style) {
        CPPASTCastExpression copy = new CPPASTCastExpression();
        copy.setOperator(this.getOperator());
        copy.setTypeId(this.typeId == null ? null : this.typeId.copy(style));
        IASTExpression operand = this.getOperand();
        copy.setOperand(operand == null ? null : operand.copy(style));
        copy.setOffsetAndLength(this);
        if (style == IASTNode.CopyStyle.withLocations) {
            copy.setCopyLocation(this);
        }
        return copy;
    }

    @Override
    public void setTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.typeId = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TYPE_ID);
        }
    }

    @Override
    public IASTTypeId getTypeId() {
        return this.typeId;
    }

    @Override
    public int getOperator() {
        return this.op;
    }

    @Override
    public void setOperator(int operator) {
        this.assertNotFrozen();
        this.op = operator;
    }

    @Override
    public IASTExpression getOperand() {
        return this.operand;
    }

    @Override
    public void setOperand(IASTExpression expression) {
        this.assertNotFrozen();
        this.operand = (ICPPASTExpression)expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(OPERAND);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.typeId != null && !this.typeId.accept(action)) {
            return false;
        }
        IASTExpression op = this.getOperand();
        if (op != null && !op.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.operand) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.operand = (ICPPASTExpression)other;
        }
    }

    @Override
    public ICPPEvaluation getEvaluation() {
        if (this.fEvaluation == null) {
            this.fEvaluation = this.computeEvaluation();
        }
        return this.fEvaluation;
    }

    private ICPPEvaluation computeEvaluation() {
        if (this.operand == null) {
            return EvalFixed.INCOMPLETE;
        }
        IType type = CPPVisitor.createType(this.getTypeId());
        if (type == null || type instanceof IProblemType) {
            return EvalFixed.INCOMPLETE;
        }
        return new EvalTypeId(type, this.operand.getEvaluation());
    }

    @Override
    public IType getExpressionType() {
        return this.getEvaluation().getTypeOrFunctionSet(this);
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return this.getEvaluation().getValueCategory(this);
    }

    @Override
    public boolean isLValue() {
        return this.getValueCategory() == IASTExpression.ValueCategory.LVALUE;
    }
}

