/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICBasicType;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.core.runtime.CoreException;

public class CBasicType
implements ICBasicType,
ISerializableType {
    private final IBasicType.Kind fKind;
    private int fModifiers;
    private IASTExpression value;

    public CBasicType(IBasicType.Kind kind, int modifiers, IASTExpression value) {
        this.fKind = kind == IBasicType.Kind.eUnspecified ? ((modifiers & 0x30) != 0 ? IBasicType.Kind.eFloat : IBasicType.Kind.eInt) : kind;
        this.fModifiers = modifiers;
        this.value = value;
    }

    public CBasicType(IBasicType.Kind kind, int modifiers) {
        this(kind, modifiers, null);
    }

    public CBasicType(ICASTSimpleDeclSpecifier sds) {
        this(CBasicType.getKind(sds), CBasicType.getQualifiers(sds), null);
    }

    private static int getQualifiers(ICASTSimpleDeclSpecifier sds) {
        return (sds.isLong() ? 1 : 0) | (sds.isShort() ? 2 : 0) | (sds.isSigned() ? 4 : 0) | (sds.isUnsigned() ? 8 : 0) | (sds.isLongLong() ? 64 : 0) | (sds.isComplex() ? 16 : 0) | (sds.isImaginary() ? 32 : 0);
    }

    private static IBasicType.Kind getKind(ICASTSimpleDeclSpecifier sds) {
        switch (sds.getType()) {
            case 6: {
                return IBasicType.Kind.eBoolean;
            }
            case 2: {
                return IBasicType.Kind.eChar;
            }
            case 5: {
                return IBasicType.Kind.eDouble;
            }
            case 4: {
                return IBasicType.Kind.eFloat;
            }
            case 14: {
                return IBasicType.Kind.eFloat128;
            }
            case 3: {
                return IBasicType.Kind.eInt;
            }
            case 13: {
                return IBasicType.Kind.eInt128;
            }
            case 1: {
                return IBasicType.Kind.eVoid;
            }
        }
        return IBasicType.Kind.eUnspecified;
    }

    @Override
    public IBasicType.Kind getKind() {
        return this.fKind;
    }

    @Override
    public int getModifiers() {
        return this.fModifiers;
    }

    @Override
    public boolean isSigned() {
        return (this.fModifiers & 4) != 0;
    }

    @Override
    public boolean isUnsigned() {
        return (this.fModifiers & 8) != 0;
    }

    @Override
    public boolean isShort() {
        return (this.fModifiers & 2) != 0;
    }

    @Override
    public boolean isLong() {
        return (this.fModifiers & 1) != 0;
    }

    @Override
    public boolean isLongLong() {
        return (this.fModifiers & 0x40) != 0;
    }

    @Override
    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (!(obj instanceof ICBasicType)) {
            return false;
        }
        ICBasicType cObj = (ICBasicType)obj;
        if (this.fKind != cObj.getKind()) {
            return false;
        }
        if (this.fKind == IBasicType.Kind.eInt) {
            return (this.fModifiers & 0xFFFFFFFB) == (cObj.getModifiers() & 0xFFFFFFFB);
        }
        return this.fModifiers == cObj.getModifiers();
    }

    @Override
    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }

    @Override
    @Deprecated
    public IASTExpression getValue() {
        return this.value;
    }

    @Override
    public boolean isComplex() {
        return (this.fModifiers & 0x10) != 0;
    }

    @Override
    public boolean isImaginary() {
        return (this.fModifiers & 0x20) != 0;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer) throws CoreException {
        int kind = this.getKind().ordinal();
        int shiftedKind = kind * 16;
        int modifiers = this.getModifiers();
        if (shiftedKind < 128 && modifiers == 0) {
            buffer.putByte((byte)(1 | shiftedKind));
        } else {
            buffer.putByte((byte)-127);
            buffer.putByte((byte)kind);
            buffer.putByte((byte)modifiers);
        }
    }

    public static IType unmarshal(int firstByte, ITypeMarshalBuffer buffer) throws CoreException {
        int kind;
        boolean dense = (firstByte & 0x80) == 0;
        int modifiers = 0;
        if (dense) {
            kind = (firstByte & 0x7F) / 16;
        } else {
            kind = buffer.getByte();
            modifiers = buffer.getByte();
        }
        return new CBasicType(IBasicType.Kind.values()[kind], modifiers);
    }

    @Override
    @Deprecated
    public int getType() {
        switch (this.fKind) {
            case eBoolean: {
                return 6;
            }
            case eChar: 
            case eWChar: 
            case eChar16: 
            case eChar32: {
                return 2;
            }
            case eDouble: {
                return 5;
            }
            case eFloat: {
                return 4;
            }
            case eInt: {
                return 3;
            }
            case eVoid: {
                return 1;
            }
            case eUnspecified: {
                return 0;
            }
        }
        return 0;
    }

    public String toString() {
        return ASTTypeUtil.getType(this);
    }
}

