/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.impl.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.olap.OLAPException;
import javax.olap.cursor.Blob;
import javax.olap.cursor.Clob;
import javax.olap.cursor.CubeCursor;
import javax.olap.cursor.Date;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.RowDataMetaData;
import javax.olap.cursor.Time;
import javax.olap.cursor.Timestamp;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.api.ICubeCursor;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IDimensionDefinition;
import org.eclipse.birt.data.engine.olap.api.query.IHierarchyDefinition;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.query.view.BirtCubeView;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.script.JSCubeBindingObject;
import org.eclipse.birt.data.engine.olap.script.OLAPExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionUtil;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeCursorImpl
implements ICubeCursor {
    private CubeCursor cursor;
    private Scriptable scope;
    private ICubeQueryDefinition queryDefn;
    private HashMap bindingMap;
    private HashMap dataTypeMap;
    private Map<String, DimLevel> dimLevelMap;
    private Set validBindingSet;
    private Scriptable outerResults;
    private BirtCubeView cubeView;
    private ScriptContext cx;
    private Map<DimLevel, DimensionCursor> dimensionCursorMap;

    public CubeCursorImpl(IBaseQueryResults outerResults, CubeCursor cursor, Scriptable scope, ScriptContext cx, ICubeQueryDefinition queryDefn, BirtCubeView view) throws DataException {
        this.cursor = cursor;
        this.scope = scope;
        this.queryDefn = queryDefn;
        this.cubeView = view;
        this.cx = cx;
        this.dimensionCursorMap = new HashMap<DimLevel, DimensionCursor>();
        this.populateDimensionCursor();
        this.outerResults = OlapExpressionUtil.createQueryResultsScriptable(outerResults);
        this.bindingMap = new HashMap();
        this.dimLevelMap = new HashMap<String, DimLevel>();
        this.validBindingSet = new HashSet();
        this.dataTypeMap = new HashMap();
        List<IBinding> allBindings = CubeQueryDefinitionUtil.getAllBindings(queryDefn);
        int i = 0;
        while (i < allBindings.size()) {
            IBinding binding = allBindings.get(i);
            String bindingName = binding.getBindingName();
            this.validBindingSet.add(bindingName);
            IBaseExpression expr = binding.getExpression();
            if (binding.getAggrFunction() == null) {
                this.bindingMap.put(bindingName, expr);
                if (expr instanceof IScriptExpression) {
                    if (!CubeCursorImpl.isSimpleDimensionExpression(((IScriptExpression)expr).getText())) {
                        OLAPExpressionCompiler.compile(cx.newContext((Object)this.scope), expr);
                    }
                } else {
                    OLAPExpressionCompiler.compile(cx.newContext((Object)this.scope), expr);
                }
            }
            this.dataTypeMap.put(bindingName, binding.getDataType());
            ++i;
        }
        this.scope.put("data", this.scope, (Object)new JSCubeBindingObject(this));
        this.scope.put("row", this.scope, (Object)new JSCubeBindingObject(this));
    }

    private static boolean isSimpleDimensionExpression(String expr) throws DataException {
        if (expr != null && expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            Set s = OlapExpressionCompiler.getReferencedDimLevel(new org.eclipse.birt.data.engine.api.querydefn.ScriptExpression(expr), Collections.EMPTY_LIST);
            return s.size() <= 1;
        }
        return false;
    }

    public boolean nextMeasure() throws OLAPException, IOException {
        if (this.cursor instanceof org.eclipse.birt.data.engine.olap.cursor.CubeCursorImpl) {
            return ((org.eclipse.birt.data.engine.olap.cursor.CubeCursorImpl)this.cursor).nextMeasure();
        }
        return false;
    }

    @Override
    public List getOrdinateEdge() throws OLAPException {
        return this.cursor.getOrdinateEdge();
    }

    @Override
    public Collection getPageEdge() throws OLAPException {
        return this.cursor.getPageEdge();
    }

    @Override
    public void synchronizePages() throws OLAPException {
        this.cursor.synchronizePages();
    }

    @Override
    public void close() throws OLAPException {
        this.cursor.close();
    }

    @Override
    public InputStream getAsciiStream(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public InputStream getAsciiStream(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public InputStream getBinaryStream(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public Blob getBlob(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public Blob getBlob(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public boolean getBoolean(int arg0) throws OLAPException {
        return false;
    }

    @Override
    public boolean getBoolean(String arg0) throws OLAPException {
        return false;
    }

    @Override
    public byte getByte(int arg0) throws OLAPException {
        return 0;
    }

    @Override
    public byte getByte(String arg0) throws OLAPException {
        return 0;
    }

    @Override
    public byte[] getBytes(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public byte[] getBytes(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public Reader getCharacterStream(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public Reader getCharacterStream(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public Clob getClob(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public Clob getClob(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public Date getDate(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public Date getDate(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    @Override
    public double getDouble(int arg0) throws OLAPException {
        return 0.0;
    }

    @Override
    public double getDouble(String arg0) throws OLAPException {
        return 0.0;
    }

    @Override
    public float getFloat(int arg0) throws OLAPException {
        return 0.0f;
    }

    @Override
    public float getFloat(String arg0) throws OLAPException {
        return 0.0f;
    }

    @Override
    public int getInt(int arg0) throws OLAPException {
        return 0;
    }

    @Override
    public int getInt(String arg0) throws OLAPException {
        return 0;
    }

    @Override
    public long getLong(int arg0) throws OLAPException {
        return 0L;
    }

    @Override
    public long getLong(String arg0) throws OLAPException {
        return 0L;
    }

    @Override
    public RowDataMetaData getMetaData() throws OLAPException {
        return this.cursor.getMetaData();
    }

    @Override
    public Object getObject(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public Object getObject(String arg0) throws OLAPException {
        Object result;
        block20: {
            result = null;
            if (!this.validBindingSet.contains(arg0)) {
                if (arg0.equals("_outer")) {
                    if (this.outerResults != null) {
                        return this.outerResults;
                    }
                    throw new OLAPException("data.engine.NoOuterResultsExist");
                }
                throw new OLAPException(DataResourceHandle.getInstance().getMessage("data.engine.ColumnBindingNotExist", new String[]{arg0}));
            }
            if (this.bindingMap.get(arg0) == null) {
                result = this.cursor.getObject(arg0);
            } else {
                try {
                    DimLevel dimLevel;
                    IBaseExpression expr = (IBaseExpression)this.bindingMap.get(arg0);
                    try {
                        if (this.dimLevelMap.containsKey(arg0)) {
                            dimLevel = this.dimLevelMap.get(arg0);
                        } else {
                            dimLevel = OlapExpressionUtil.getTargetDimLevel(((org.eclipse.birt.data.engine.api.querydefn.ScriptExpression)expr).getText());
                            this.dimLevelMap.put(arg0, dimLevel);
                        }
                    }
                    catch (Exception exception) {
                        dimLevel = null;
                        this.dimLevelMap.put(arg0, null);
                    }
                    if (dimLevel != null) {
                        DimensionCursor dimCursor = this.dimensionCursorMap.get(dimLevel);
                        if (dimCursor != null) {
                            try {
                                if (dimLevel.getAttrName() != null) {
                                    result = dimCursor.getObject(OlapExpressionUtil.getAttributeColumnName(dimLevel.getLevelName(), dimLevel.getAttrName()));
                                    break block20;
                                }
                                result = dimCursor.getObject(dimLevel.getLevelName());
                            }
                            catch (Exception exception) {
                                result = null;
                            }
                            break block20;
                        }
                        result = ScriptEvalUtil.evalExpr(expr, this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
                        break block20;
                    }
                    result = ScriptEvalUtil.evalExpr(expr, this.cx.newContext((Object)this.scope), ScriptExpression.defaultID, 0);
                }
                catch (Exception e) {
                    throw new OLAPException(e.getLocalizedMessage());
                }
            }
        }
        if (result instanceof DataException) {
            throw new OLAPException(((DataException)((Object)result)).getLocalizedMessage());
        }
        if (this.dataTypeMap.containsKey(arg0)) {
            try {
                result = DataTypeUtil.convert((Object)JavascriptEvalUtil.convertJavascriptValue((Object)result), (int)((Integer)this.dataTypeMap.get(arg0)));
            }
            catch (BirtException e) {
                throw new OLAPException(e.getLocalizedMessage());
            }
        }
        return result;
    }

    private void populateDimensionCursor() throws OLAPException {
        if (this.cubeView.getPageEdgeView() != null && this.queryDefn.getEdge(3) != null) {
            this.populateDimensionObjects(this.queryDefn.getEdge(3).getDimensions(), this.cubeView.getPageEdgeView().getEdgeCursor().getDimensionCursor().iterator());
        }
        if (this.cubeView.getRowEdgeView() != null && this.queryDefn.getEdge(1) != null) {
            this.populateDimensionObjects(this.queryDefn.getEdge(1).getDimensions(), this.cubeView.getRowEdgeView().getEdgeCursor().getDimensionCursor().iterator());
        }
        if (this.cubeView.getColumnEdgeView() != null && this.queryDefn.getEdge(2) != null) {
            this.populateDimensionObjects(this.queryDefn.getEdge(2).getDimensions(), this.cubeView.getColumnEdgeView().getEdgeCursor().getDimensionCursor().iterator());
        }
    }

    private void populateDimensionObjects(List<IDimensionDefinition> dimensions, Iterator iterator) {
        int i = 0;
        while (i < dimensions.size()) {
            IDimensionDefinition dimDefn = dimensions.get(i);
            IHierarchyDefinition hier = dimDefn.getHierarchy().get(0);
            int j = 0;
            while (j < hier.getLevels().size()) {
                this.dimensionCursorMap.put(new DimLevel(dimDefn.getName(), hier.getLevels().get(j).getName()), (DimensionCursor)iterator.next());
                ++j;
            }
            ++i;
        }
    }

    @Override
    public Object getObject(int arg0, Map arg1) throws OLAPException {
        return null;
    }

    @Override
    public Object getObject(String arg0, Map arg1) throws OLAPException {
        return null;
    }

    @Override
    public short getShort(int arg0) throws OLAPException {
        return 0;
    }

    @Override
    public short getShort(String arg0) throws OLAPException {
        return 0;
    }

    @Override
    public String getString(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public String getString(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public Time getTime(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public Time getTime(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int arg0) throws OLAPException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String arg0) throws OLAPException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws OLAPException {
        return null;
    }

    @Override
    public String getId() throws OLAPException {
        return null;
    }

    @Override
    public String getName() throws OLAPException {
        return null;
    }

    @Override
    public void setId(String value) throws OLAPException {
    }

    @Override
    public void setName(String value) throws OLAPException {
    }

    @Override
    public Scriptable getScope() {
        return this.scope;
    }

    @Override
    public Object clone() {
        return null;
    }

    public BirtCubeView getCubeView() {
        return this.cubeView;
    }
}

