/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.application;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.OpenSessionAction;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public final class OpenFilesFromCommandLineJob
extends Job {
    private final IWorkbenchWindow window;

    private static String fileNames(Collection<String> fileNames) {
        StringBuilder builder = new StringBuilder();
        for (String fileName : fileNames) {
            builder.append(fileName);
        }
        return builder.toString();
    }

    protected static String getMissingFileMessage(List<String> missingFiles) {
        if (missingFiles.size() == 1) {
            return MessageFormat.format(ViperMessages.Open_Fail_Single_File, missingFiles.get(0));
        }
        return MessageFormat.format(ViperMessages.Open_Fail_Multiple_Files, OpenFilesFromCommandLineJob.fileNames(missingFiles));
    }

    public OpenFilesFromCommandLineJob(IWorkbenchWindow window) {
        super(ViperMessages.Open_Job_Title);
        this.window = window;
        this.setSystem(true);
        this.setUser(false);
    }

    protected IStatus run(IProgressMonitor monitor) {
        String[] args = Platform.getApplicationArgs();
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)(args.length * 10));
        final Shell shell = this.window.getShell();
        final LinkedList<String> missingFiles = new LinkedList<String>();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            final String fName = stringArray[n2];
            if (m.isCanceled()) {
                return new Status(8, "com.nvidia.viper.application", ViperMessages.Open_Job_Canceled);
            }
            File f = new File(fName);
            if (f.isFile()) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        OpenSessionAction.handleOpenFile((IWorkbenchWindow)OpenFilesFromCommandLineJob.this.window, (String)fName);
                    }
                });
            } else if (!fName.startsWith("-")) {
                missingFiles.add(fName);
            }
            m.worked(10);
            ++n2;
        }
        if (!missingFiles.isEmpty()) {
            boolean dialogDisabled = Boolean.parseBoolean(System.getProperty("viper.test.noMissingFileDialog"));
            if (!dialogDisabled) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ViperMessageDialog.openError((Shell)shell, (String)ViperMessages.Open_Fail_Title, (String)OpenFilesFromCommandLineJob.getMissingFileMessage(missingFiles));
                    }
                });
            } else {
                System.err.println(OpenFilesFromCommandLineJob.getMissingFileMessage(missingFiles));
            }
        }
        m.done();
        return Status.OK_STATUS;
    }
}

