/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.application;

import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.CloneSessionAction;
import com.nvidia.viper.actions.ForceAllAnalysisResultsAction;
import com.nvidia.viper.actions.NewSessionAction;
import com.nvidia.viper.actions.OpenSessionAction;
import com.nvidia.viper.actions.ShowAboutAction;
import com.nvidia.viper.actions.ShowViewAction;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.register((IAction)new NewSessionAction(window));
        this.register((IAction)new OpenSessionAction(window));
        this.register((IAction)new CloneSessionAction(window));
        ActionFactory.IWorkbenchAction action = ActionFactory.SAVE.create(window);
        action.setImageDescriptor(ViperImages.DESC_SAVE);
        this.register((IAction)action);
        action = ActionFactory.SAVE_AS.create(window);
        action.setImageDescriptor(ViperImages.DESC_SAVE_AS);
        this.register((IAction)action);
        action = ActionFactory.SAVE_ALL.create(window);
        action.setImageDescriptor(ViperImages.DESC_SAVE_ALL);
        this.register((IAction)action);
        action = ActionFactory.IMPORT.create(window);
        action.setImageDescriptor(ViperImages.DESC_IMPORT);
        this.register((IAction)action);
        if (!"macosx".equals(Platform.getOS())) {
            this.register((IAction)ActionFactory.QUIT.create(window));
        }
        this.register((IAction)new ShowViewAction(window, "com.nvidia.viper.showconsole"));
        this.register((IAction)new ShowViewAction(window, "com.nvidia.viper.showanalysis"));
        this.register((IAction)new ShowViewAction(window, "com.nvidia.viper.showexpert"));
        this.register((IAction)new ShowViewAction(window, "com.nvidia.viper.showproperties"));
        this.register((IAction)new ShowViewAction(window, "com.nvidia.viper.showsettings"));
        action = ActionFactory.HELP_CONTENTS.create(window);
        action.setImageDescriptor(ViperImages.DESC_HELP_CONTENT);
        this.register((IAction)action);
        this.register((IAction)ActionFactory.HELP_SEARCH.create(window));
        this.register((IAction)ActionFactory.DYNAMIC_HELP.create(window));
        if ("win32".equals(Platform.getOS())) {
            this.register((IAction)ActionFactory.INTRO.create(window));
        }
        this.register((IAction)new ShowAboutAction(window));
        if (System.getenv("VIPER_DEBUG") != null) {
            this.register((IAction)new ForceAllAnalysisResultsAction());
        }
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager(ViperMessages.FileMenu_Label, "com.nvidia.viper.filemenu");
        MenuManager viewMenu = new MenuManager(ViperMessages.ViewMenu_Label, "com.nvidia.viper.viewmenu");
        MenuManager runMenu = new MenuManager(ViperMessages.RunMenu_Label, "com.nvidia.viper.runmenu");
        MenuManager helpMenu = new MenuManager(ViperMessages.HelpMenu_Label, "com.nvidia.viper.helpmenu");
        menuBar.add((IContributionItem)fileMenu);
        menuBar.add((IContributionItem)viewMenu);
        menuBar.add((IContributionItem)runMenu);
        menuBar.add((IContributionItem)helpMenu);
        fileMenu.add(this.getAction("com.nvidia.viper.sessionnew"));
        fileMenu.add(this.getAction("com.nvidia.viper.sessionopen"));
        fileMenu.add(this.getAction("com.nvidia.viper.sessionclone"));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add(this.getAction(ActionFactory.SAVE.getId()));
        fileMenu.add(this.getAction(ActionFactory.SAVE_AS.getId()));
        fileMenu.add(this.getAction(ActionFactory.SAVE_ALL.getId()));
        fileMenu.add((IContributionItem)new Separator());
        fileMenu.add(this.getAction(ActionFactory.IMPORT.getId()));
        if (!"macosx".equals(Platform.getOS())) {
            fileMenu.add((IContributionItem)new Separator());
            fileMenu.add(this.getAction(ActionFactory.QUIT.getId()));
        }
        viewMenu.add(this.getAction("com.nvidia.viper.showanalysis"));
        viewMenu.add(this.getAction("com.nvidia.viper.showconsole"));
        viewMenu.add(this.getAction("com.nvidia.viper.showexpert"));
        viewMenu.add(this.getAction("com.nvidia.viper.showsettings"));
        viewMenu.add(this.getAction("com.nvidia.viper.showproperties"));
        viewMenu.add((IContributionItem)new Separator());
        if ("win32".equals(Platform.getOS())) {
            helpMenu.add(this.getAction(ActionFactory.INTRO.getId()));
            helpMenu.add((IContributionItem)new Separator());
        }
        helpMenu.add(this.getAction(ActionFactory.HELP_CONTENTS.getId()));
        helpMenu.add(this.getAction(ActionFactory.HELP_SEARCH.getId()));
        helpMenu.add(this.getAction(ActionFactory.DYNAMIC_HELP.getId()));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add(this.getAction("com.nvidia.viper.about"));
        if (System.getenv("VIPER_DEBUG") != null) {
            MenuManager debugMenu = new MenuManager(ViperMessages.DebugMenu_Label, "com.nvidia.viper.debugmenu");
            menuBar.add((IContributionItem)debugMenu);
            debugMenu.add(this.getAction("com.nvidia.viper.forceallanalysisresults"));
        }
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        ToolBarManager toolbar = new ToolBarManager(0x800100);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, "file"));
        toolbar.add(this.getAction("com.nvidia.viper.sessionnew"));
        toolbar.add(this.getAction(ActionFactory.SAVE.getId()));
        toolbar.add(this.getAction(ActionFactory.SAVE_AS.getId()));
    }
}

