/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.application;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.application.ApplicationWorkbenchAdvisor;
import com.nvidia.viper.ui.ViperMessageDialog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class Application
implements IApplication {
    public Object start(IApplicationContext context) {
        Display display = PlatformUI.createDisplay();
        Location instanceLoc = Platform.getInstanceLocation();
        try {
            if (!this.lockWorkspace(display, instanceLoc)) {
                ViperExceptionHandler.logError((String)"Failed to lock Visual Profiler Workspace");
                Integer n = IApplication.EXIT_OK;
                return n;
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ApplicationWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
            if (instanceLoc != null) {
                instanceLoc.release();
            }
        }
    }

    private boolean lockWorkspace(Display display, Location instanceLoc) {
        block5: {
            if (instanceLoc == null) {
                ViperExceptionHandler.logError((String)"Visual Profiler in Invalid State: Workspace directory not defined");
                return false;
            }
            try {
                if (!instanceLoc.lock()) break block5;
                return true;
            }
            catch (Exception exception) {
                ViperExceptionHandler.logError((String)"Error Occurred while locking workspace");
                return false;
            }
        }
        Shell shell = WorkbenchPlugin.getSplashShell((Display)display);
        if (shell != null) {
            shell.setText("Workspace in use");
            shell.setImages(Dialog.getDefaultImages());
        }
        ViperMessageDialog.openError((Shell)shell, (String)"Workspace already in use", (String)("The workspace at " + instanceLoc.getURL().getFile() + " cannot be created or is already in use by another instance of Visual Profiler."));
        return false;
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

