/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.editor;

import com.nvidia.cuda.ide.language.ast.CudaCASTUtil;
import com.nvidia.cuda.ide.language.ast.CudaTarget;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.internal.ui.editor.SemanticToken;
import org.eclipse.cdt.ui.text.AbstractConfigurableHighlighting;
import org.eclipse.swt.graphics.RGB;

public class DeviceFunctionInvocationHighlight
extends AbstractConfigurableHighlighting {
    public boolean consumes(SemanticToken token) {
        IASTNode node = token.getNode();
        if (node instanceof IASTName) {
            IASTName name = (IASTName)node;
            if (name instanceof ICPPASTQualifiedName) {
                return false;
            }
            if (!name.isReference()) {
                return false;
            }
            IBinding binding = token.getBinding();
            if (binding instanceof IFunction) {
                return CudaCASTUtil.getTarget(binding) == CudaTarget.cudaDevice;
            }
        }
        return false;
    }

    protected RGB getDefaultTextColor() {
        return new RGB(0, 64, 0);
    }

    public String getDisplayName() {
        return "Device Function Call";
    }

    public String getCategory() {
        return "CUDA C";
    }

    protected String getPreferenceKey() {
        return "cudaDeviceInvocation";
    }

    public boolean isBoldByDefault() {
        return true;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public boolean isItalicByDefault() {
        return false;
    }
}

