/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.chart;

import com.nvidia.viper.analysis.AnalysisResultKernelFlops;
import com.nvidia.viper.chart.ui.AxesConfiguration;
import com.nvidia.viper.chart.ui.IViperChart;
import com.nvidia.viper.chart.ui.ViperChartSeries;
import java.util.LinkedList;
import java.util.List;

public final class KernelFlopsChart
implements IViperChart {
    private final AnalysisResultKernelFlops result;

    public KernelFlopsChart(AnalysisResultKernelFlops result) {
        this.result = result;
    }

    public ViperChartSeries[] getSeries() {
        long maxThreadExecCount = this.result.getTotalExecCount() * 32L;
        List<AnalysisResultKernelFlops.FlopsKind> kinds = this.result.getFlopsKinds();
        LinkedList<Double> values = new LinkedList<Double>();
        for (AnalysisResultKernelFlops.FlopsKind kind : kinds) {
            long flopsThreadExecCount = this.result.getExecCount(kind);
            values.add(100.0 * (double)flopsThreadExecCount / (double)maxThreadExecCount);
        }
        return new ViperChartSeries[]{new ViperChartSeries(values.toArray(new Double[0]), ViperChartSeries.Type.STACKED_BAR, "Execution Count")};
    }

    public String getTitle() {
        return null;
    }

    public boolean isHighlighted() {
        return false;
    }

    public boolean showLegend() {
        return false;
    }

    public int getHeight() {
        return 300;
    }

    public int getWidth() {
        return 900;
    }

    public AxesConfiguration getAxesConfiguration() {
        return new AxesConfiguration(null, "Execution Count (% of total)", true, Integer.valueOf(100), Integer.valueOf(10), null, Integer.valueOf(10), true, new String[]{"10%", "20%", "30%", "40%", "50%", "60%", "70%", "80%", "90%", "100%"}, false);
    }

    public String[] getLabels() {
        List<AnalysisResultKernelFlops.FlopsKind> kinds = this.result.getFlopsKinds();
        LinkedList<String> labels = new LinkedList<String>();
        for (AnalysisResultKernelFlops.FlopsKind kind : kinds) {
            labels.add(kind.toString());
        }
        return labels.toArray(new String[0]);
    }

    public boolean colorBySeries() {
        return true;
    }
}

