/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.BandwidthFormatter;
import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.analysis.AnalysisResultKernelMemory;
import com.nvidia.viper.jni.CuptiMetricValueUtilizationLevel;
import com.nvidia.viper.ui.analysis.DataGrid;
import com.nvidia.viper.ui.analysis.MemoryDataTablePainter;

public class KernelMemoryDataGrid {
    public static void fillL1SharedMemoryTable(DataGrid table, AnalysisResultKernelMemory result) {
        KernelMemoryDataGrid.row(table, "Local Loads", result.getLocalMemoryReadTransactions(), result.getLocalMemoryReadThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Local Stores", result.getLocalMemoryWriteTransactions(), result.getLocalMemoryWriteThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Shared Loads", result.getSharedMemoryReadTransactions(), result.getSharedMemoryReadThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Shared Stores", result.getSharedMemoryWriteTransactions(), result.getSharedMemoryWriteThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Global Loads", result.getGlobalMemoryReadTransactions(), result.getGlobalMemoryReadThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Global Stores", result.getGlobalMemoryWriteTransactions(), result.getGlobalMemoryWriteThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Atomic", result.getAtomicTransactions(), result.getAtomicThroughput(), null, false);
        Number totalTransactions = KernelMemoryDataGrid.addNumbers(result.getLocalMemoryReadTransactions(), result.getLocalMemoryWriteTransactions(), result.getSharedMemoryReadTransactions(), result.getSharedMemoryWriteTransactions(), result.getGlobalMemoryReadTransactions(), result.getGlobalMemoryWriteTransactions(), result.getAtomicTransactions());
        Number totalThroughput = KernelMemoryDataGrid.addNumbers(result.getLocalMemoryReadThroughput(), result.getLocalMemoryWriteThroughput(), result.getSharedMemoryReadThroughput(), result.getSharedMemoryWriteThroughput(), result.getGlobalMemoryReadThroughput(), result.getGlobalMemoryWriteThroughput(), result.getAtomicThroughput());
        KernelMemoryDataGrid.row(table, "L1/Shared Total", totalTransactions, totalThroughput, result.getMemoryUnitUtilization(AnalysisResultKernelMemory.MemoryUnit.L1SHARED), result.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.L1SHARED));
    }

    public static void fillSharedMemoryTable(DataGrid table, AnalysisResultKernelMemory result) {
        KernelMemoryDataGrid.row(table, "Shared Loads", result.getSharedMemoryReadTransactions(), result.getSharedMemoryReadThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Shared Stores", result.getSharedMemoryWriteTransactions(), result.getSharedMemoryWriteThroughput(), null, false);
        Number totalTransactions = KernelMemoryDataGrid.addNumbers(result.getSharedMemoryReadTransactions(), result.getSharedMemoryWriteTransactions());
        Number totalThroughput = KernelMemoryDataGrid.addNumbers(result.getSharedMemoryReadThroughput(), result.getSharedMemoryWriteThroughput());
        KernelMemoryDataGrid.row(table, "Shared Total", totalTransactions, totalThroughput, result.getMemoryUnitUtilization(AnalysisResultKernelMemory.MemoryUnit.SHARED), result.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.SHARED));
    }

    public static void fillTexCacheTable(DataGrid table, AnalysisResultKernelMemory result) {
        KernelMemoryDataGrid.row(table, "Reads", result.getTexureCacheReadTransactions(), result.getTexureCacheReadThroughput(), result.getMemoryUnitUtilization(AnalysisResultKernelMemory.MemoryUnit.TEX), result.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.TEX));
    }

    public static void fillUnifiedCacheTable(DataGrid table, AnalysisResultKernelMemory result) {
        KernelMemoryDataGrid.row(table, "Local Loads", result.getLocalMemoryReadTransactions(), result.getLocalMemoryReadThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Local Stores", result.getLocalMemoryWriteTransactions(), result.getLocalMemoryWriteThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Global Loads", result.getGlobalMemoryReadTransactions(), result.getGlobalMemoryReadThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Global Stores", result.getGlobalMemoryWriteTransactions(), result.getGlobalMemoryWriteThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Texture Reads", result.getTexureCacheReadTransactions(), result.getTexureCacheReadThroughput(), null, false);
        Number totalTransactions = KernelMemoryDataGrid.addNumbers(result.getLocalMemoryReadTransactions(), result.getLocalMemoryWriteTransactions(), result.getGlobalMemoryReadTransactions(), result.getGlobalMemoryWriteTransactions(), result.getTexureCacheReadTransactions());
        Number totalThroughput = KernelMemoryDataGrid.addNumbers(result.getLocalMemoryReadThroughput(), result.getLocalMemoryWriteThroughput(), result.getGlobalMemoryReadThroughput(), result.getGlobalMemoryWriteThroughput(), result.getTexureCacheReadThroughput());
        KernelMemoryDataGrid.row(table, "Unified Total", totalTransactions, totalThroughput, result.getMemoryUnitUtilization(AnalysisResultKernelMemory.MemoryUnit.UNIFIED), result.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.UNIFIED));
    }

    public static void fillL2CacheTable(DataGrid table, AnalysisResultKernelMemory result) {
        if (!(result.getL2L1ReadTransactions() != null && result.getL2L1ReadThroughput() != null || result.getL2L1WriteTransactions() != null && result.getL2L1WriteThroughput() != null)) {
            KernelMemoryDataGrid.fillOldL2CacheTable(table, result);
        } else {
            KernelMemoryDataGrid.row(table, "L1 Reads", result.getL2L1ReadTransactions(), result.getL2L1ReadThroughput(), null, false);
            KernelMemoryDataGrid.row(table, "L1 Writes", result.getL2L1WriteTransactions(), result.getL2L1WriteThroughput(), null, false);
            KernelMemoryDataGrid.row(table, "Texture Reads", result.getL2TexReadTransactions(), result.getL2TexReadThroughput(), null, false);
            KernelMemoryDataGrid.row(table, "Texture Writes", result.getL2TexWriteTransactions(), result.getL2TexWriteThroughput(), null, false);
            KernelMemoryDataGrid.row(table, "Atomic", result.getL2AtomicTransactions(), result.getL2AtomicThroughput(), null, false);
            KernelMemoryDataGrid.row(table, "Noncoherent Reads", result.getNcL2ReadTransactions(), result.getNcL2ReadThroughput(), null, false);
            Number totalTransactions = KernelMemoryDataGrid.addNumbers(result.getL2L1ReadTransactions(), result.getL2L1WriteTransactions(), result.getL2TexReadTransactions(), result.getL2TexWriteTransactions(), result.getL2AtomicTransactions(), result.getNcL2ReadTransactions());
            Number totalThroughput = KernelMemoryDataGrid.addNumbers(result.getL2L1ReadThroughput(), result.getL2L1WriteThroughput(), result.getL2TexReadThroughput(), result.getL2TexWriteThroughput(), result.getL2AtomicThroughput(), result.getNcL2ReadThroughput());
            KernelMemoryDataGrid.row(table, "Total", totalTransactions, totalThroughput, result.getMemoryUnitUtilization(AnalysisResultKernelMemory.MemoryUnit.L2), result.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.L2));
        }
    }

    private static void fillOldL2CacheTable(DataGrid table, AnalysisResultKernelMemory result) {
        KernelMemoryDataGrid.row(table, "Reads", result.getL2ReadTransactions(), result.getL2ReadThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Writes", result.getL2WriteTransactions(), result.getL2WriteThroughput(), null, false);
        Number totalTransactions = KernelMemoryDataGrid.addNumbers(result.getL2ReadTransactions(), result.getL2WriteTransactions());
        Number totalThroughput = KernelMemoryDataGrid.addNumbers(result.getL2ReadThroughput(), result.getL2WriteThroughput());
        KernelMemoryDataGrid.row(table, "Total", totalTransactions, totalThroughput, result.getMemoryUnitUtilization(AnalysisResultKernelMemory.MemoryUnit.L2), result.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.L2));
    }

    public static void fillDramTable(DataGrid table, AnalysisResultKernelMemory result) {
        KernelMemoryDataGrid.row(table, "Reads", result.getDramReadTransactions(), result.getDramReadThroughput(), null, false);
        KernelMemoryDataGrid.row(table, "Writes", result.getDramWriteTransactions(), result.getDramWriteThroughput(), null, false);
        Number totalTransactions = KernelMemoryDataGrid.addNumbers(result.getDramReadTransactions(), result.getDramWriteTransactions());
        Number totalThroughput = KernelMemoryDataGrid.addNumbers(result.getDramReadThroughput(), result.getDramWriteThroughput());
        KernelMemoryDataGrid.row(table, "Total", totalTransactions, totalThroughput, result.getMemoryUnitUtilization(AnalysisResultKernelMemory.MemoryUnit.DRAM), result.isMemoryUnitLimited(AnalysisResultKernelMemory.MemoryUnit.DRAM));
        if (result.isEccOverhead()) {
            KernelMemoryDataGrid.row(table, "ECC Overhead", result.getEccTransactions(), result.getEccThroughput(), null, result.isECCLimited());
        }
    }

    public static void fillSystemMemoryTable(DataGrid table, AnalysisResultKernelMemory result) {
        CuptiMetricValueUtilizationLevel readUtilization = result.getSysMemReadUtilization();
        CuptiMetricValueUtilizationLevel writeUtilization = result.getSysMemWriteUtilization();
        KernelMemoryDataGrid.row(table, "Reads", result.getSystemMemoryReadTransactions(), result.getSystemMemoryReadThroughput(), readUtilization, readUtilization.getCode() > CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_MID.getCode());
        KernelMemoryDataGrid.row(table, "Writes", result.getSystemMemoryWriteTransactions(), result.getSystemMemoryWriteThroughput(), writeUtilization, writeUtilization.getCode() > CuptiMetricValueUtilizationLevel.CUPTI_METRIC_VALUE_UTILIZATION_MID.getCode());
    }

    static void row(DataGrid table, String name, Number transactions, Number throughput, CuptiMetricValueUtilizationLevel utilLevel, boolean isLimiter) {
        MemoryDataTablePainter.MemoryData data = utilLevel != null ? new MemoryDataTablePainter.MemoryData(utilLevel, isLimiter) : (isLimiter ? new MemoryDataTablePainter.MemoryData(utilLevel, isLimiter) : null);
        if (transactions != null && throughput != null) {
            table.addRow(name, Long.toString(transactions.longValue()), new BandwidthFormatter(ByteSizeFormatter.Base.KILOBYTE).format(throughput.longValue()), data);
        }
    }

    static Number addNumbers(Number ... numbers) {
        long sum = 0L;
        boolean nonNull = false;
        Number[] numberArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            Number number = numberArray[n2];
            if (number != null) {
                sum += number.longValue();
                nonNull = true;
            }
            ++n2;
        }
        if (nonNull) {
            return sum;
        }
        return null;
    }
}

