/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.report.util.IWTGraphicsObject;
import com.nvidia.viper.ui.analysis.IDataGridPainter;
import com.nvidia.viper.ui.analysis.MemoryDataTablePainter;
import com.nvidia.viper.ui.analysis.OccupancyDataTablePainter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;

public final class DataGrid {
    static final int INSET = 2;
    final List<Integer> columnWidths = new LinkedList<Integer>();
    final List<Integer> columnStyles = new LinkedList<Integer>();
    final IDataGridPainter painter;
    final List<Object[]> rows = new LinkedList<Object[]>();
    private boolean isHeader = false;

    public String toString() {
        return "DataGrid [rows=" + this.rows + ", isHeader=" + this.isHeader + "]";
    }

    private static boolean isHightlighted(Object[] row) {
        Object[] objectArray = row;
        int n = row.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof OccupancyDataTablePainter.BarData) {
                return ((OccupancyDataTablePainter.BarData)object).isLimiter;
            }
            if (object instanceof MemoryDataTablePainter.MemoryData) {
                return ((MemoryDataTablePainter.MemoryData)object).isLimiter();
            }
            ++n2;
        }
        return false;
    }

    public DataGrid(IDataGridPainter painter) {
        this.painter = painter;
    }

    public int computeHeight(IWTGraphicsObject wtgo) {
        int height = 0;
        if (!this.rows.isEmpty()) {
            for (Object[] row : this.rows) {
                height += this.painter.getRowHeight(wtgo, this, row);
            }
        }
        return height;
    }

    public void addColumn(int width, int style) {
        this.columnWidths.add(width);
        this.columnStyles.add(style);
    }

    public void addRow(Object ... row) {
        this.rows.add(row);
    }

    public void clear() {
        this.rows.clear();
    }

    public boolean isHeader() {
        return this.isHeader;
    }

    private void paintBackground(IWTGraphicsObject wtgo, Rectangle bounds) {
        if (!this.isHeader() && this.rows.size() > 1) {
            int y = bounds.y;
            Color color = wtgo.getColor(19);
            int i = 0;
            while (i < this.rows.size()) {
                Object[] row = this.rows.get(i);
                int rowHeight = this.painter.getRowHeight(wtgo, this, row);
                if ((i & 1) == 1) {
                    wtgo.fillRectangle(bounds.x - 2, y, bounds.width, rowHeight + 2, color);
                }
                y += rowHeight;
                ++i;
            }
            wtgo.setBackground(wtgo.getBackground());
        }
    }

    private int paintCells(IWTGraphicsObject wtgo, Rectangle bounds, int x, int y) {
        int initY = y;
        if (!this.rows.isEmpty()) {
            for (Object[] row : this.rows) {
                int rowHeight = this.painter.getRowHeight(wtgo, this, row);
                boolean highlight = DataGrid.isHightlighted(row);
                Iterator<Integer> widths = this.columnWidths.iterator();
                Iterator<Integer> styles = this.columnStyles.iterator();
                int i = 0;
                while (i < row.length) {
                    Object object = row[i];
                    int width = widths.hasNext() ? widths.next() : bounds.width - x;
                    Color c = wtgo.getForeground();
                    this.painter.paintCell(wtgo, this, object, new Rectangle(x, y, width - 4, rowHeight), styles.hasNext() ? styles.next() : 0, highlight);
                    wtgo.setForeground(c);
                    x += width;
                    ++i;
                }
                y += rowHeight;
                x = bounds.x;
            }
        }
        return y - initY;
    }

    private void paintColumnLines(IWTGraphicsObject wtgo, Rectangle bounds) {
        int x = bounds.x;
        int y = bounds.y;
        if (!this.columnWidths.isEmpty()) {
            wtgo.setForeground(wtgo.getColor(18));
            wtgo.setLineWidth(1);
            for (int column : this.columnWidths) {
                wtgo.drawLine(x += column, y - 2, x, y + bounds.height + 2);
            }
        }
    }

    public int paintDataGrid(IWTGraphicsObject wtgo, Rectangle bounds) {
        bounds.x += 2;
        bounds.y += 2;
        int x = bounds.x;
        int y = bounds.y;
        this.paintBackground(wtgo, bounds);
        int totHeight = this.paintCells(wtgo, bounds, x, y);
        this.paintColumnLines(wtgo, bounds);
        return totHeight;
    }

    public void setHeader(boolean isHeader) {
        this.isHeader = isHeader;
    }
}

