/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.actions.RunAnalysisStageAction;
import com.nvidia.viper.analysis.AnalysisScope;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.Runner;
import com.nvidia.viper.ui.UIUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class AnalysisStageControl
extends Composite
implements ISessionPropertyChangeListener {
    private static final Color HILIGHT_COLOR = Display.getDefault().getSystemColor(18);
    private static final Color SELECTION_COLOR = Display.getDefault().getSystemColor(26);
    private static final Color SELECTION_TEXT_COLOR = Display.getDefault().getSystemColor(27);
    private static final Color BG_COLOR = ColorConstants.white;
    private static final Color FG_COLOR = ColorConstants.black;
    private AnalysisStage stage;
    private Session activeSession;
    private Button analyzeButton;
    private Label visitedMark;

    public AnalysisStageControl(Composite parent, AnalysisStage stage, Session session) {
        super(parent, 2048);
        this.stage = stage;
        this.activeSession = session;
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 1;
        gl.marginHeight = 1;
        this.setLayout((Layout)gl);
        this.setBackground(BG_COLOR);
        Composite top = new Composite((Composite)this, 0);
        top.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gl = new GridLayout(3, false);
        gl.marginHeight = 3;
        top.setLayout((Layout)gl);
        top.setBackground(BG_COLOR);
        this.addControlListeners((Control)top, false);
        CLabel label = new CLabel(top, 0);
        GridData labelData = new GridData(4, 0x1000000, true, false);
        labelData.widthHint = 20;
        label.setLayoutData((Object)labelData);
        label.setText(stage.getLabel());
        label.setBackground(BG_COLOR);
        UIUtils.boldFont((Control)label);
        this.addControlListeners((Control)label, false);
        this.analyzeButton = new Button(top, 0);
        this.analyzeButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.analyzeButton.setImage(ViperImages.get("icons/en/run_analysis.png"));
        this.analyzeButton.setToolTipText("Run analysis");
        this.analyzeButton.setBackground(BG_COLOR);
        this.addControlListeners((Control)this.analyzeButton, true);
        this.visitedMark = new Label(top, 0);
        this.visitedMark.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.visitedMark.setImage(ViperImages.get("icons/en/analysis_visited.png"));
        this.visitedMark.setBackground(BG_COLOR);
        this.addControlListeners((Control)this.visitedMark, false);
        this.refresh();
        if (this.activeSession != null && this.activeSession.getAnalysis() != null) {
            final Analysis analysis = this.activeSession.getAnalysis();
            this.handleSelection(analysis.getSelectedStage());
            analysis.addPropertyChangeListener(this);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    analysis.removePropertyChangeListener(AnalysisStageControl.this);
                }
            });
        }
    }

    protected void addControlListeners(Control control, final boolean force) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Analysis analysis;
                Analysis analysis2 = analysis = AnalysisStageControl.this.activeSession == null ? null : AnalysisStageControl.this.activeSession.getAnalysis();
                if (force || analysis != null && analysis.getVisitedStages().contains((Object)AnalysisStageControl.this.stage)) {
                    AnalysisStageControl.this.select(force);
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                Analysis analysis;
                Analysis analysis2 = analysis = AnalysisStageControl.this.activeSession == null ? null : AnalysisStageControl.this.activeSession.getAnalysis();
                if (analysis != null && analysis.getVisitedStages().contains((Object)AnalysisStageControl.this.stage)) {
                    AnalysisStageControl.this.setBackground(HILIGHT_COLOR);
                }
            }

            public void mouseExit(MouseEvent e) {
                AnalysisStageControl.this.setBackground(BG_COLOR);
            }
        });
    }

    protected void select(boolean refresh) {
        final Analysis analysis = this.activeSession.getAnalysis();
        if (analysis != null && (refresh || !this.stage.equals((Object)analysis.getSelectedStage()))) {
            if (refresh || analysis.getAnalysisResults(this.stage).isEmpty()) {
                RunAnalysisStageAction analysisAction = new RunAnalysisStageAction(this.activeSession, new AnalysisStage[]{this.stage}, this.activeSession.getExecutable() == null ? RunAnalysisStageAction.DataCollection.NONE : (refresh ? RunAnalysisStageAction.DataCollection.FORCE : RunAnalysisStageAction.DataCollection.IFNEEDED)){

                    @Override
                    public void analysisCompleted(IStatus status) {
                        if (analysis.isActive(AnalysisScope.APPLICATION)) {
                            analysis.setVisitedStage(AnalysisStage.TIMELINE, true);
                        }
                        analysis.setVisitedStage(AnalysisStageControl.this.stage, true);
                        analysis.setSelectedStage(AnalysisStageControl.this.stage);
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("com.nvidia.viper.analysisview");
                        }
                        catch (PartInitException partInitException) {
                            ViperExceptionHandler.logError("unable to show analysis view");
                        }
                    }
                };
                analysisAction.run();
            } else {
                if (AnalysisScope.APPLICATION.isEnabled(analysis.getActiveScopeInterval())) {
                    analysis.setVisitedStage(AnalysisStage.TIMELINE, true);
                }
                analysis.setVisitedStage(this.stage, true);
                analysis.setSelectedStage(this.stage);
            }
        }
    }

    public void refresh() {
        Analysis analysis = this.activeSession == null ? null : this.activeSession.getAnalysis();
        boolean enabled = analysis != null;
        UIUtils.setEnabled(this, enabled);
        if (enabled) {
            if (analysis != null && analysis.getVisitedStages().contains((Object)this.stage)) {
                this.visitedMark.setEnabled(true);
                this.visitedMark.setToolTipText("Analysis completed");
                this.analyzeButton.setVisible(false);
            } else {
                this.visitedMark.setEnabled(false);
                this.visitedMark.setToolTipText("Analysis pending");
                this.analyzeButton.setVisible(true);
                this.analyzeButton.setEnabled(Runner.getLockedSessions().isEmpty());
            }
        }
    }

    protected void handleSelection(AnalysisStage selected) {
        if (this.stage.equals((Object)selected)) {
            UIUtils.setBackground(this, SELECTION_COLOR);
            UIUtils.setForeground(this, SELECTION_TEXT_COLOR);
        } else {
            UIUtils.setBackground(this, BG_COLOR);
            UIUtils.setForeground(this, FG_COLOR);
        }
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("analysis:sstage".equals(propertyName)) {
            AnalysisStage selected = ((Analysis)model).getSelectedStage();
            this.handleSelection(selected);
        }
    }
}

