/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperImages;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionPropertyChangeListener;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.UIUtils;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class AnalysisResultControl
extends Composite
implements ISessionPropertyChangeListener {
    private static final Color HILIGHT_COLOR = Display.getDefault().getSystemColor(18);
    private static final Color SELECTION_COLOR = Display.getDefault().getSystemColor(26);
    private static final Color SELECTION_TEXT_COLOR = Display.getDefault().getSystemColor(27);
    private static final Color BG_COLOR = ColorConstants.white;
    private static final Color FG_COLOR = ColorConstants.black;
    private static final Color DETAILS_COLOR = Display.getDefault().getSystemColor(16);
    private static final Color DETAILS_SELECTED_COLOR = Display.getDefault().getSystemColor(27);
    protected AnalysisResult result;
    protected Session activeSession;
    private Label details;

    public AnalysisResultControl(Composite parent, AnalysisResult result, Session session) {
        this(parent, result, session, true);
    }

    protected AnalysisResultControl(Composite parent, AnalysisResult result, Session session, boolean showLabels) {
        super(parent, 2048);
        this.result = result;
        this.activeSession = session;
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 1;
        gl.marginHeight = 1;
        this.setLayout((Layout)gl);
        Composite top = new Composite((Composite)this, 0);
        top.setLayoutData((Object)new GridData(4, 4, true, false));
        gl = new GridLayout(3, false);
        gl.marginHeight = 3;
        top.setLayout((Layout)gl);
        this.addSelectListener((Control)top);
        if (showLabels) {
            Label image = new Label(top, 0);
            GridData igd = new GridData(16384, 0x1000000, false, false);
            image.setLayoutData((Object)igd);
            image.setImage(ViperImages.getAnalysisImageForSeverity(result.getSeverity()));
            this.addSelectListener((Control)image);
            Composite labelPanel = new Composite(top, 0);
            GridData lgd = new GridData(4, 128, true, false);
            lgd.horizontalSpan = 2;
            labelPanel.setLayoutData((Object)lgd);
            RowLayout rowLayout = new RowLayout();
            rowLayout.wrap = true;
            rowLayout.marginHeight = 0;
            rowLayout.marginWidth = 0;
            rowLayout.marginTop = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginLeft = 0;
            rowLayout.marginRight = 0;
            rowLayout.pack = true;
            labelPanel.setLayout((Layout)rowLayout);
            this.addSelectListener((Control)labelPanel);
            Label label = new Label(labelPanel, 0);
            label.setText(result.getLabel(ResultOutput.UI));
            UIUtils.boldFont((Control)label);
            this.addSelectListener((Control)label);
            if (result.getDetails(ResultOutput.UI) != null) {
                this.details = new Label(labelPanel, 0);
                this.details.setText(String.format("[ %s ]", result.getDetails(ResultOutput.UI)));
                this.details.setForeground(this.details.getDisplay().getSystemColor(33));
                this.addSelectListener((Control)this.details);
            }
            final Action moreAction = result.getMoreAction();
            String actionDesc = result.getActionDescription(ResultOutput.UI);
            Label desc = new Label(top, 64);
            GridData dgd = new GridData(4, 128, true, false);
            dgd.horizontalSpan = actionDesc != null || moreAction == null ? 3 : 2;
            dgd.widthHint = 400;
            desc.setLayoutData((Object)dgd);
            desc.setText(result.getDescription(ResultOutput.UI));
            this.addSelectListener((Control)desc);
            if (actionDesc != null) {
                Label action = new Label(top, 64);
                GridData agd = new GridData(4, 128, true, false);
                agd.horizontalSpan = moreAction == null ? 3 : 2;
                agd.widthHint = 400;
                action.setLayoutData((Object)agd);
                action.setText(actionDesc);
                UIUtils.italicFont((Control)action);
                this.addSelectListener((Control)action);
            }
            if (moreAction != null) {
                Link more = new Link(top, 0);
                more.setLayoutData((Object)new GridData(16384, 1024, false, true));
                more.setText("<a>More...</a>");
                more.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        moreAction.run();
                    }
                });
            }
        }
        if (this.hasExtension()) {
            Composite extend = new Composite(top, 0);
            GridLayout egl = new GridLayout(1, false);
            egl.marginWidth = 0;
            egl.marginHeight = 0;
            extend.setLayout((Layout)egl);
            GridData gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 3;
            extend.setLayoutData((Object)gd);
            this.createExtension(extend);
        }
        this.setColors(false);
        if (this.activeSession != null) {
            this.activeSession.addPropertyChangeListener(this);
            final Analysis analysis = this.activeSession.getAnalysis();
            if (analysis != null) {
                analysis.addPropertyChangeListener(this);
            }
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (analysis != null) {
                        analysis.removePropertyChangeListener(AnalysisResultControl.this);
                    }
                    AnalysisResultControl.this.activeSession.removePropertyChangeListener(AnalysisResultControl.this);
                }
            });
        }
    }

    protected boolean allowsSelection() {
        return this.result != null && this.result.getAssociatedIntervals() != null && !this.result.getAssociatedIntervals().isEmpty();
    }

    protected boolean hasExtension() {
        return false;
    }

    protected void createExtension(Composite parent) {
    }

    protected void addSelectListener(Control control) {
        if (!this.allowsSelection()) {
            return;
        }
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Analysis analysis = AnalysisResultControl.this.activeSession.getAnalysis();
                if (analysis != null) {
                    if (analysis.getSelectedResult() == AnalysisResultControl.this.result) {
                        analysis.setSelectedResult(null);
                        AnalysisResultControl.this.activeSession.setPrimarySelected(null, true);
                    } else {
                        analysis.setSelectedResult(AnalysisResultControl.this.result);
                        List<TimelineIntervalPair> pairs = AnalysisResultControl.this.result.getAssociatedIntervals();
                        if (pairs != null && !pairs.isEmpty()) {
                            TimelineIntervalPair primary = pairs.get(0);
                            List<TimelineIntervalPair> secondary = pairs.subList(1, pairs.size());
                            AnalysisResultControl.this.activeSession.setPrimaryAndSecondarySelected(primary, secondary, false, false);
                        } else {
                            AnalysisResultControl.this.activeSession.setPrimarySelected(null, true);
                        }
                    }
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                AnalysisResultControl.this.setBackground(HILIGHT_COLOR);
            }

            public void mouseExit(MouseEvent e) {
                AnalysisResultControl.this.setBackground(BG_COLOR);
            }
        });
    }

    @Override
    public void propertyChange(IModel model, String propertyName) {
        if ("analysis:sresult".equals(propertyName)) {
            AnalysisResult selected = ((Analysis)model).getSelectedResult();
            this.setColors(this.result.equals(selected));
        }
    }

    private void setColors(boolean isSelected) {
        Color label;
        Color foreground;
        Color background;
        if (isSelected) {
            background = SELECTION_COLOR;
            foreground = SELECTION_TEXT_COLOR;
            label = DETAILS_SELECTED_COLOR;
        } else {
            background = BG_COLOR;
            foreground = FG_COLOR;
            label = DETAILS_COLOR;
        }
        UIUtils.setBackground(this, background);
        UIUtils.setForeground(this, foreground);
        if (this.details != null) {
            this.details.setForeground(label);
        }
    }

    public boolean grabsVerticalSpace() {
        return false;
    }
}

