/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.editor.ViperAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.widgets.Composite;

public abstract class ViperViewerBase
extends SourceViewer {
    protected SourceSassEditor editor;
    private ViewerCaretListener caretListener;

    public ViperViewerBase(SourceSassEditor editor, Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.editor = editor;
        this.setEditable(false);
    }

    protected void createControl(Composite parent, int styles) {
        super.createControl(parent, styles);
        this.addCaretListener();
    }

    public void addCaretListener() {
        if (this.caretListener == null) {
            this.caretListener = new ViewerCaretListener();
        }
        this.getTextWidget().addCaretListener((CaretListener)this.caretListener);
    }

    public void removeCaretListener() {
        if (this.caretListener != null) {
            this.getTextWidget().removeCaretListener((CaretListener)this.caretListener);
        }
    }

    public abstract long getMaxInstructionExecuted();

    public abstract long getAverageNonZeroInstructionExecuted();

    public abstract long getInstructionExecuted(int var1);

    public abstract long getThreadInstructionExecuted(int var1);

    public abstract long getNoPredicateOff(int var1);

    public abstract void highlightLine(int var1);

    public abstract void highlightCorrespondingLines(int var1);

    public void createAnnotations(IAnnotationModel annotationModel) {
        long avgExecCnt = this.getAverageNonZeroInstructionExecuted();
        long sumSquares = 0L;
        int cnt = 0;
        int lineNum = 0;
        while (lineNum < this.getDocument().getNumberOfLines()) {
            long execCnt = this.getInstructionExecuted(lineNum);
            if (execCnt > 0L) {
                long diff = execCnt - avgExecCnt;
                sumSquares += diff * diff;
                ++cnt;
            }
            ++lineNum;
        }
        if (cnt > 0) {
            double variance = sumSquares / (long)cnt;
            double stddev = Math.sqrt(variance);
            int lineNum2 = 0;
            while (lineNum2 < this.getDocument().getNumberOfLines()) {
                long execCnt = this.getInstructionExecuted(lineNum2);
                if (execCnt > 0L) {
                    long diff = execCnt - avgExecCnt;
                    if ((double)diff > 2.0 * stddev) {
                        this.createAnnotation(annotationModel, lineNum2, SourceSassEditor.AnnotationType.HOTSPOT_HIGH);
                    } else if ((double)diff > stddev) {
                        this.createAnnotation(annotationModel, lineNum2, SourceSassEditor.AnnotationType.HOTSPOT_MED);
                    }
                }
                ++lineNum2;
            }
        }
    }

    private void createAnnotation(IAnnotationModel annotationModel, int lineNum, SourceSassEditor.AnnotationType type) {
        ViperAnnotation annotation = new ViperAnnotation(lineNum, type);
        annotation.setText(String.format(ViperMessages.ExecCountAnnotation_tooltip, this.getInstExecutedPercent(lineNum), type.getDescription(), this.getTextWidget().getLine(lineNum).trim()));
        try {
            int offset = this.getDocument().getLineOffset(lineNum);
            int length = this.getDocument().getLineLength(lineNum) - 1;
            annotationModel.addAnnotation((Annotation)annotation, new Position(offset, length));
        }
        catch (BadLocationException e) {
            ViperExceptionHandler.logError(e.getMessage());
        }
    }

    public long getInstExecutedPercent(int lineNumber) {
        int percent = -1;
        long count = this.getInstructionExecuted(lineNumber);
        if (count > 0L) {
            long maxCount = this.getMaxInstructionExecuted();
            if (maxCount == 0L) {
                percent = 0;
            } else if (maxCount > 0L) {
                percent = (int)((double)count / (double)maxCount * 100.0);
            }
        }
        return percent;
    }

    class ViewerCaretListener
    implements CaretListener {
        ViewerCaretListener() {
        }

        public void caretMoved(CaretEvent event) {
            IDocument doc = ViperViewerBase.this.getDocument();
            int line = -1;
            if (doc != null) {
                try {
                    line = doc.getLineOfOffset(event.caretOffset);
                }
                catch (BadLocationException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
                ViperViewerBase.this.highlightCorrespondingLines(line);
                ViperViewerBase.this.highlightLine(line);
            }
        }
    }
}

