/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.editor.SourceSassEditor;
import com.nvidia.viper.model.SassInstruction;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.ui.ViperViewerBase;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class SassViewer
extends ViperViewerBase {
    private int maxInstExecuted = -1;
    private int avgInstExecuted = -1;
    private List<Integer> lastHighlightedLines = new ArrayList<Integer>();
    int currentBlockStart = -1;
    int currentBlockEnd = -1;

    public SassViewer(SourceSassEditor editor, Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles) {
        super(editor, parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
    }

    @Override
    protected void createControl(Composite parent, int styles) {
        super.createControl(parent, styles);
        StyledText textWidget = this.getTextWidget();
        textWidget.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                GC gc;
                GC gC = gc = event != null ? event.gc : null;
                if (gc != null) {
                    Rectangle rect;
                    gc.setForeground(ColorConstants.gray);
                    if (SassViewer.this.currentBlockStart > -1 && SassViewer.this.currentBlockEnd > -1 && (rect = SassViewer.this.getBoundingBox(SassViewer.this.currentBlockStart, SassViewer.this.currentBlockEnd)) != null) {
                        gc.drawLine(rect.x, rect.y, rect.x + SassViewer.this.getTextWidget().getClientArea().width, rect.y);
                        gc.drawLine(rect.x, rect.y + rect.height, rect.x + SassViewer.this.getTextWidget().getClientArea().width, rect.y + rect.height);
                    }
                }
            }
        });
    }

    @Override
    public void highlightLine(int line) {
        StyledText textWidget = this.getTextWidget();
        if (line != -1) {
            for (Integer highLightedLine : this.lastHighlightedLines) {
                textWidget.setLineBackground(highLightedLine.intValue(), 1, textWidget.getBackground());
            }
            this.lastHighlightedLines.clear();
            List<Integer> sassLines = this.editor.getSourceSassModel().getSassLinesGroup(line);
            if (sassLines != null) {
                for (Integer hline : sassLines) {
                    textWidget.setLineBackground(hline.intValue(), 1, new Color(null, 224, 255, 255));
                    this.lastHighlightedLines.add(hline);
                }
            } else {
                this.lastHighlightedLines.add(line);
            }
            textWidget.setLineBackground(line, 1, Display.getDefault().getSystemColor(32));
            this.setCurrentBlockToLine(line);
        }
    }

    public void highlightLines(List<Integer> lines) {
        StyledText textWidget = this.getTextWidget();
        for (Integer highLightedLine : this.lastHighlightedLines) {
            textWidget.setLineBackground(highLightedLine.intValue(), 1, textWidget.getBackground());
        }
        this.lastHighlightedLines.clear();
        int first = -1;
        int last = -1;
        if (lines != null) {
            for (Integer line : lines) {
                textWidget.setLineBackground(line.intValue(), 1, Display.getDefault().getSystemColor(32));
                this.lastHighlightedLines.add(line);
            }
            first = Collections.min(lines);
            last = Collections.max(lines);
            if (first < this.getTopIndex() || first > this.getBottomIndex() || last > this.getBottomIndex()) {
                this.setTopIndex(first);
            }
        }
        this.setCurrentBlockToLine(first);
    }

    private void setCurrentBlockToLine(int line) {
        if (line > -1) {
            BitSet bitSet = this.getHighlightedLineBitset();
            int start = -1;
            int end = -1;
            int from = 0;
            while ((start = bitSet.nextSetBit(from)) >= 0) {
                from = bitSet.nextClearBit(start);
                end = from - 1;
                if (line < start || line > end) continue;
                if (this.currentBlockStart != start || this.currentBlockEnd != end) {
                    this.currentBlockStart = start;
                    this.currentBlockEnd = end;
                }
                break;
            }
        } else {
            this.currentBlockStart = -1;
            this.currentBlockEnd = -1;
        }
        this.currentBlockChanged();
    }

    private void currentBlockChanged() {
        this.getTextWidget().redraw();
        int startOff = -1;
        try {
            startOff = this.getDocument().getLineOffset(this.currentBlockStart);
        }
        catch (BadLocationException e) {
            ViperExceptionHandler.logError(e.getMessage());
        }
        if (startOff > -1) {
            this.revealRange(startOff, 1);
        }
        boolean enablePrev = false;
        boolean enableNext = false;
        if (this.lastHighlightedLines != null && this.lastHighlightedLines.size() > 0) {
            enablePrev = this.currentBlockStart != Collections.min(this.lastHighlightedLines);
            enableNext = this.currentBlockEnd != Collections.max(this.lastHighlightedLines);
        }
        this.editor.getSelectPreviousButton().setEnabled(enablePrev);
        this.editor.getSelectNextButton().setEnabled(enableNext);
    }

    private BitSet getHighlightedLineBitset() {
        BitSet bitSet = new BitSet();
        for (Integer hLine : this.lastHighlightedLines) {
            bitSet.set(hLine);
        }
        return bitSet;
    }

    private void initInstructionExecuted() {
        this.maxInstExecuted = -1;
        this.avgInstExecuted = -1;
        SourceSassModel sourceSassModel = this.editor.getSourceSassModel();
        List<SassInstruction> sassInstructions = sourceSassModel.getSassInstructions();
        if (sassInstructions != null) {
            int avgInstCnt = 0;
            long totalInstExec = 0L;
            int lineNum = 0;
            while (lineNum < sassInstructions.size()) {
                CuptiActivityInstructionExecution activity = this.getInstructionExecutionActivity(lineNum);
                if (activity != null) {
                    if (activity.executed > this.maxInstExecuted) {
                        this.maxInstExecuted = activity.executed;
                    }
                    if (activity.executed > 0) {
                        totalInstExec += (long)activity.executed;
                        ++avgInstCnt;
                    }
                }
                ++lineNum;
            }
            this.avgInstExecuted = avgInstCnt == 0 ? 0 : (int)(totalInstExec / (long)avgInstCnt);
        }
    }

    @Override
    public long getMaxInstructionExecuted() {
        if (this.maxInstExecuted == -1) {
            this.initInstructionExecuted();
        }
        return this.maxInstExecuted;
    }

    @Override
    public long getAverageNonZeroInstructionExecuted() {
        if (this.avgInstExecuted == -1) {
            this.initInstructionExecuted();
        }
        return this.avgInstExecuted;
    }

    @Override
    public long getInstructionExecuted(int lineNum) {
        CuptiActivityInstructionExecution activity = this.getInstructionExecutionActivity(lineNum);
        if (activity != null && !CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID.isSet(activity.flags)) {
            return activity.executed;
        }
        return -1L;
    }

    @Override
    public long getThreadInstructionExecuted(int lineNum) {
        CuptiActivityInstructionExecution activity = this.getInstructionExecutionActivity(lineNum);
        if (activity != null && !CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID.isSet(activity.flags)) {
            return activity.threadsExecuted;
        }
        return -1L;
    }

    @Override
    public long getNoPredicateOff(int lineNum) {
        CuptiActivityInstructionExecution activity = this.getInstructionExecutionActivity(lineNum);
        if (activity != null && !CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID.isSet(activity.flags)) {
            return activity.notPredOffThreadsExecuted;
        }
        return -1L;
    }

    private CuptiActivityInstructionExecution getInstructionExecutionActivity(int lineNum) {
        SourceSassModel sourceSassModel = this.editor.getSourceSassModel();
        List<SassInstruction> sassInstructions = sourceSassModel.getSassInstructions();
        AnalysisResultInstructionExecution result = sourceSassModel.getAnalysisResultInstructionExecution();
        if (sassInstructions != null) {
            if (lineNum < 0 || lineNum >= sassInstructions.size()) {
                return null;
            }
            if (sassInstructions.get(lineNum).getPcOffset() == -1) {
                return null;
            }
            for (ICuptiActivitySourceLevelResult slresult : result.getSourceLevelResults()) {
                if (!(slresult instanceof CuptiActivityInstructionExecution)) continue;
                CuptiActivityInstructionExecution activity = (CuptiActivityInstructionExecution)slresult;
                if (activity.pcOffset != sassInstructions.get(lineNum).getPcOffset() || activity.getSourceLocatorId() != sassInstructions.get(lineNum).getSourcelocatorid()) continue;
                return activity;
            }
        }
        return null;
    }

    @Override
    public void highlightCorrespondingLines(int line) {
        this.editor.highlightCudaLines(line);
    }

    public void selectNext() {
        BitSet bitSet = this.getHighlightedLineBitset();
        int start = -1;
        int end = -1;
        int from = 0;
        while ((start = bitSet.nextSetBit(from)) >= 0) {
            from = bitSet.nextClearBit(start);
            end = from - 1;
            if (start <= this.currentBlockEnd) continue;
            if (this.currentBlockStart == start && this.currentBlockEnd == end) break;
            this.currentBlockStart = start;
            this.currentBlockEnd = end;
            this.currentBlockChanged();
            break;
        }
    }

    public void selectPrevious() {
        int start;
        BitSet bitSet = this.getHighlightedLineBitset();
        int lastStart = -1;
        int lastEnd = -1;
        int from = 0;
        while ((start = bitSet.nextSetBit(from)) >= 0) {
            from = bitSet.nextClearBit(start);
            int end = from - 1;
            if (start == this.currentBlockStart) {
                this.currentBlockStart = lastStart;
                this.currentBlockEnd = lastEnd;
                this.currentBlockChanged();
                break;
            }
            lastStart = start;
            lastEnd = end;
        }
    }

    private Rectangle getBoundingBox(int startLine, int endLine) {
        Rectangle rect = null;
        try {
            int startOffset = this.getDocument().getLineOffset(startLine);
            int endOffset = this.getDocument().getLineOffset(endLine) + this.getDocument().getLineLength(endLine);
            if (endOffset > startOffset) {
                rect = this.getTextWidget().getTextBounds(startOffset, endOffset - 1);
            }
        }
        catch (BadLocationException e) {
            ViperExceptionHandler.logError(e.getMessage());
        }
        return rect;
    }
}

