/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.run;

import com.nvidia.viper.Activator;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperJob;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.Runner;
import com.nvidia.viper.ui.CollectNewTimelineMessageDialog;
import com.nvidia.viper.ui.LargeDataMessageDialog;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class TimelineRunner
extends Runner {
    public static final int PROGRESS_TOTAL_WORK = 4;
    protected final Session session;

    public TimelineRunner(Session session) {
        this.session = session;
    }

    @Override
    public boolean runWithJob() {
        if (!TimelineRunner.checkRunnable(this.session, true)) {
            return false;
        }
        if (!this.checkExisting(this.session)) {
            return false;
        }
        if (!this.lockSession(this.session, true)) {
            return false;
        }
        this.showConsole();
        if (!Activator.getDefault().getViperWorkbench().readyToRun(this.session)) {
            this.unlockSession(this.session);
            return false;
        }
        try {
            this.job = new TimelineJob();
            this.job.schedule();
        }
        catch (Exception e) {
            ViperException ex = !(e instanceof ViperException) ? new ViperException(e) : (ViperException)e;
            if (!ex.getMessage().endsWith("LoadPdmCancel")) {
                ViperExceptionHandler.handle(ViperMessages.Launch_Fail_Title, ViperMessages.Launch_Fail_Message, ex);
            }
            this.unlockSession(this.session);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IStatus runWithMonitor(IProgressMonitor monitor) {
        this.showConsole();
        try {
            File apiFile;
            Executable exec = this.session.getExecutable();
            String nvprofArgs = this.getNvprofBaseArgs(exec);
            SubProgressMonitor launchProgress = new SubProgressMonitor(monitor, 4){

                public void beginTask(String name, int totalWork) {
                }

                public void setTaskName(String name) {
                }

                public void subTask(String name) {
                    super.subTask(ViperMessages.Timeline_Progress_SubMessage);
                }
            };
            if (System.getenv("VIPER_DEBUG") != null) {
                System.out.println("nvprof: " + nvprofArgs);
            }
            if ((apiFile = FileSystem.getFilesystem(exec.getConnectionName()).runNvprof(exec, nvprofArgs, "api.log", (IProgressMonitor)launchProgress)) == null) return Status.CANCEL_STATUS;
            if (launchProgress.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.worked(1);
            monitor.subTask("Collecting results...");
            final ProfileDataModel pdm = new ProfileDataModel();
            try {
                if (apiFile != null && apiFile.exists() && apiFile.isFile()) {
                    try {
                        if (System.getenv("__LARGE_PDM") != null) {
                            pdm.readUsingSizeTime(apiFile, this.session);
                        } else {
                            pdm.read(apiFile);
                        }
                    }
                    catch (ViperException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof CuptiException && CUptiResult.CUPTI_ERROR_NOT_COMPATIBLE.equals((Object)((CuptiException)cause).getCuptiResult())) {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ViperMessages.ReadPdm_Incomplete_Title, ViperMessages.ReadPdm_Incomplete_Message);
                                }
                            });
                        }
                        if (!e.getMessage().endsWith("LoadPdmCancel")) throw e;
                        monitor.done();
                    }
                }
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.worked(1);
                monitor.subTask("Normalizing...");
                pdm.normalizeTimestamps(NativeCupti.cuptiPDMGetNormalizeTime(pdm.getNativeHandle()));
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.worked(1);
                monitor.subTask("Updating...");
                Thread thread = new Thread("LoadPdm"){

                    @Override
                    public void run() {
                        try {
                            TimelineRunner.this.session.setTimelines(pdm);
                        }
                        catch (Exception e) {
                            ViperException ex;
                            if (e instanceof ViperException && !(ex = (ViperException)e).getMessage().endsWith("LoadPdmCancel")) {
                                ViperExceptionHandler.handle(ViperMessages.LoadPdm_Fail_Title, ViperMessages.LoadPdm_Fail_Message, ex);
                            }
                        }
                        catch (OutOfMemoryError e) {
                            ViperExceptionHandler.logError("Out of memory error", e);
                            LargeDataMessageDialog.show();
                        }
                    }
                };
                thread.start();
                while (true) {
                    if (thread == null || !thread.isAlive()) {
                        File exe;
                        Executable executable = this.session.getExecutable();
                        if (executable != null && (exe = new File(executable.getFilename())).exists()) {
                            executable.setLastModifiedTimestamp(exe.lastModified());
                        }
                        monitor.worked(1);
                        return Status.OK_STATUS;
                    }
                    if (!monitor.isCanceled()) continue;
                    thread.interrupt();
                }
            }
            finally {
                pdm.dispose();
            }
        }
        catch (Exception e) {
            return new Status(4, "com.nvidia.viper", ViperMessages.Launch_Fail_Message, (Throwable)e);
        }
    }

    protected boolean checkExisting(Session session) {
        boolean haveTimeline;
        boolean bl = haveTimeline = !session.getTimelines().isEmpty();
        if (haveTimeline) {
            return CollectNewTimelineMessageDialog.show() == 0;
        }
        return true;
    }

    private class TimelineJob
    extends ViperJob {
        public TimelineJob() {
            super("Generate Timeline");
        }

        @Override
        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(ViperMessages.Timeline_Progress_Message, -1);
            try {
                IStatus iStatus = TimelineRunner.this.runWithMonitor(monitor);
                return iStatus;
            }
            finally {
                monitor.done();
                TimelineRunner.this.unlockSession(TimelineRunner.this.session);
            }
        }
    }
}

