/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.report.util;

import com.nvidia.viper.report.util.IWTGraphicsObject;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class SWTGraphicsObject
implements IWTGraphicsObject {
    protected final GC gc;

    public SWTGraphicsObject(GC gc) {
        this.gc = gc;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawRectangle(int x, int y, int width, int height) {
        this.gc.drawRectangle(x, y, width, height);
    }

    @Override
    public void drawString(String text, int x, int y, boolean b) {
        this.gc.drawString(text, x, y, b);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height, Color color) {
        Color prevColor = this.gc.getBackground();
        this.gc.setBackground(color);
        this.gc.fillRectangle(x, y, width, height);
        this.gc.setBackground(prevColor);
    }

    @Override
    public void fillRectangle(Rectangle clipping, Color color) {
        Color prevColor = this.gc.getBackground();
        this.gc.setBackground(color);
        this.gc.fillRectangle(clipping);
        this.gc.setBackground(prevColor);
    }

    @Override
    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, Color color) {
        Color prevColor = this.gc.getBackground();
        this.gc.setBackground(color);
        this.gc.fillRoundRectangle(x, y, width, height, arcWidth, arcHeight);
        this.gc.setBackground(prevColor);
    }

    @Override
    public Color getBackground() {
        return this.gc.getBackground();
    }

    @Override
    public Color getColor(int SWTColorNum) {
        return this.gc.getDevice().getSystemColor(SWTColorNum);
    }

    @Override
    public int getFontHeight() {
        return this.gc.getFontMetrics().getHeight();
    }

    @Override
    public Color getForeground() {
        return this.gc.getForeground();
    }

    @Override
    public void setBackground(Color color) {
        this.gc.setBackground(color);
    }

    @Override
    public void setForeground(Color c) {
        this.gc.setForeground(c);
    }

    @Override
    public void setLineWidth(int i) {
        this.gc.setLineWidth(i);
    }

    @Override
    public Point stringExtent(String text) {
        return this.gc.stringExtent(text);
    }
}

