/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.properties;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnvDialog
extends Dialog {
    private String title;
    private String name;
    private String value;
    private Text nameText;
    private Text valueText;
    private String errorMessage;
    private Label errorMessageImage;
    private Text errorMessageText;

    public EnvDialog(Shell parentShell, String dialogTitle, String initialName, String initialValue) {
        super(parentShell);
        this.title = dialogTitle;
        this.name = initialName;
        this.value = initialValue;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Point getInitialSize() {
        return new Point(500, 250);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = this.nameText.getText();
            if (this.name.trim().isEmpty()) {
                this.name = null;
            }
            this.value = this.valueText.getText();
            if (this.value.trim().isEmpty()) {
                this.value = null;
            }
        } else {
            this.name = null;
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        if (this.name != null) {
            this.nameText.setText(this.name);
        }
        if (this.value != null) {
            this.valueText.setText(this.value);
            this.valueText.selectAll();
            this.valueText.setFocus();
        }
        this.validateInput();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        nameLabel.setText("Name:");
        this.nameText = new Text(composite, 2052);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvDialog.this.validateInput();
            }
        });
        Label valueLabel = new Label(composite, 0);
        valueLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        valueLabel.setText("Value:");
        this.valueText = new Text(composite, 2052);
        this.valueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EnvDialog.this.validateInput();
            }
        });
        this.errorMessageImage = new Label(composite, 0);
        this.errorMessageImage.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.errorMessageImage.setImage(Display.getDefault().getSystemImage(1));
        this.errorMessageText = new Text(composite, 72);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 1;
        this.errorMessageText.setLayoutData((Object)gd);
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        EnvDialog.applyDialogFont((Control)composite);
        return composite;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        String vname = this.nameText.getText();
        if (vname == null || vname.trim().isEmpty()) {
            errorMessage = "Name is required";
        } else if (!vname.matches("[a-zA-Z_][0-9a-zA-Z_]*")) {
            errorMessage = "Name must start with letter or underscore and contain only letters, numbers, and underscores";
        } else if ("CUDA_VISIBLE_DEVICES".equals(vname)) {
            errorMessage = "CUDA_VISIBLE_DEVICES cannot be set for an application. The Visual Profiler must have access to the same set of devices as the application. If you must set CUDA_VISIBLE_DEVICES, set it in the environment before launching the Visual Profiler.";
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? " \n " : errorMessage);
            boolean hasError = errorMessage != null && StringConverter.removeWhiteSpaces((String)errorMessage).length() > 0;
            this.errorMessageText.setEnabled(hasError);
            this.errorMessageText.setVisible(hasError);
            this.errorMessageImage.setVisible(hasError);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }
}

