/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

public enum TimelineKind {
    PROCESS,
    THREAD,
    RUNTIME,
    DRIVER,
    OVERHEADS,
    MARKER,
    DEVICE,
    UVM,
    UVM_MEMCPY_HTOD,
    UVM_MEMCPY_DTOH,
    UVM_PAGE_FAULT,
    CONTEXT,
    MEMCPY_HTOD,
    MEMCPY_DTOH,
    MEMCPY_DTOD,
    MEMCPY_PTOP,
    KERNELS,
    KERNEL,
    STREAMS,
    STREAM;


    public boolean isFilterable() {
        return this.equals((Object)UVM_MEMCPY_HTOD) || this.equals((Object)UVM_MEMCPY_DTOH) || this.equals((Object)UVM_PAGE_FAULT) || this.equals((Object)MEMCPY_DTOH) || this.equals((Object)MEMCPY_HTOD) || this.equals((Object)MEMCPY_DTOD) || this.equals((Object)MEMCPY_PTOP) || this.equals((Object)KERNEL);
    }

    public boolean isGhostWhenFiltered() {
        return !this.equals((Object)KERNELS);
    }

    public boolean isCPU() {
        return this.equals((Object)PROCESS) || this.equals((Object)THREAD) || this.equals((Object)RUNTIME) || this.equals((Object)DRIVER) || this.equals((Object)OVERHEADS) || this.equals((Object)MARKER);
    }

    public boolean isGPU() {
        return !this.isCPU();
    }

    public boolean isAPI() {
        return this.equals((Object)RUNTIME) || this.equals((Object)DRIVER);
    }

    public boolean appendsToPDM() {
        return !this.equals((Object)KERNELS) && !this.equals((Object)STREAMS);
    }

    public boolean canReorder() {
        return !this.equals((Object)PROCESS) && !this.equals((Object)DEVICE);
    }

    public boolean supportsMultipleIntervalRows() {
        return this.equals((Object)KERNEL) || this.equals((Object)KERNELS) || this.equals((Object)OVERHEADS) || this.equals((Object)MARKER) || this.equals((Object)MEMCPY_PTOP) || this.equals((Object)MEMCPY_DTOD) || this.equals((Object)UVM_MEMCPY_DTOH) || this.equals((Object)UVM_MEMCPY_HTOD) || this.equals((Object)UVM_PAGE_FAULT);
    }

    public boolean usesExtendedEnd() {
        return this.equals((Object)KERNEL);
    }
}

