/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.jni.NativeDemangler;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineDevice;
import com.nvidia.viper.model.TimelineKind;
import java.text.NumberFormat;
import java.util.Comparator;

public class TimelineKernel
extends Timeline
implements IModel {
    private static final NumberFormat formatter = NumberFormat.getPercentInstance();
    private long selfExecutionTime = 0L;
    private long totalExecutionTime = -1L;
    private int totalInvocations = -1;

    static {
        formatter.setMaximumFractionDigits(1);
        formatter.setMinimumFractionDigits(1);
    }

    public TimelineKernel(String name) {
        super(name, TimelineKind.KERNEL);
        String demangled = NativeDemangler.demangle(name);
        if (demangled != null) {
            this.setCustomName(demangled);
        }
    }

    @Override
    public String getDisplayName(boolean verbose) {
        String dname = super.getDisplayName(verbose);
        if (verbose) {
            return String.valueOf(formatter.format(this.getTotalExecutionRatio())) + " " + dname;
        }
        return dname;
    }

    public int getSelfInvocationCount() {
        return this.intervals.size();
    }

    public int getTotalInvocationCount() {
        if (this.totalInvocations < 0) {
            this.totalInvocations = this.getSelfInvocationCount();
            for (Timeline child : this.getChildren()) {
                if (!(child instanceof TimelineKernel)) continue;
                this.totalInvocations += ((TimelineKernel)child).getTotalInvocationCount();
            }
        }
        return this.totalInvocations;
    }

    public long getSelfExecutionTime() {
        return this.selfExecutionTime;
    }

    public long getTotalExecutionTime() {
        if (this.totalExecutionTime < 0L) {
            this.totalExecutionTime = this.selfExecutionTime;
            for (Timeline child : this.getChildren()) {
                if (!(child instanceof TimelineKernel)) continue;
                this.totalExecutionTime += ((TimelineKernel)child).getTotalExecutionTime();
            }
        }
        return this.totalExecutionTime;
    }

    public double getSelfExecutionRatio() {
        double selfExecutionRatio = 0.0;
        Timeline ancestor = this.getAncestor(TimelineKind.DEVICE);
        if (ancestor != null && ancestor instanceof TimelineDevice) {
            selfExecutionRatio = (double)this.selfExecutionTime / (double)((TimelineDevice)ancestor).getTotalKernelExecutionTime();
        }
        return selfExecutionRatio;
    }

    public double getTotalExecutionRatio() {
        double selfExecutionRatio = 0.0;
        Timeline ancestor = this.getAncestor(TimelineKind.DEVICE);
        if (ancestor != null && ancestor instanceof TimelineDevice) {
            selfExecutionRatio = (double)this.getTotalExecutionTime() / (double)((TimelineDevice)ancestor).getTotalKernelExecutionTime();
        }
        return selfExecutionRatio;
    }

    @Override
    public void addInterval(ITimelineInterval interval) {
        super.addInterval(interval);
        this.selfExecutionTime += interval.getDuration();
    }

    public static class TotalExecutionTimeComparator
    implements Comparator<TimelineKernel> {
        @Override
        public int compare(TimelineKernel k1, TimelineKernel k2) {
            long diff = k1.getTotalExecutionTime() - k2.getTotalExecutionTime();
            return diff == 0L ? 0 : (diff < 0L ? 1 : -1);
        }
    }
}

