/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.activity.CuptiActivityUvmCounterKind;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalBase;
import com.nvidia.viper.model.TimelineIntervalKind;

public class TimelineIntervalUVM
extends TimelineIntervalBase {
    private final TimelineIntervalKind kind;
    private final long startTimestamp;
    private final long endTimestamp;
    private final long value;
    private final int processId;
    private Timeline primaryTimeline;

    public TimelineIntervalUVM(TimelineIntervalKind kind, long start, long end, long value, int processId) {
        this.kind = kind;
        this.startTimestamp = start;
        this.endTimestamp = end;
        this.value = value;
        this.processId = processId;
    }

    @Override
    public TimelineIntervalKind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        switch (this.kind) {
            case UVM_PAGE_FAULT: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_CPU_PAGE_FAULT_COUNT.getName();
            }
            case UVM_MEMCPY_HTOD: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_HTOD.getName();
            }
            case UVM_MEMCPY_DTOH: {
                return CuptiActivityUvmCounterKind.CUPTI_ACTIVITY_UVM_COUNTER_KIND_BYTES_TRANSFER_DTOH.getName();
            }
        }
        return "";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public long getStart() {
        return this.startTimestamp;
    }

    @Override
    public long getEnd() {
        return this.endTimestamp;
    }

    @Override
    public Timeline getPrimaryTimeline() {
        return this.primaryTimeline;
    }

    @Override
    public void setPrimaryTimeline(Timeline timeline) {
        this.primaryTimeline = timeline;
    }

    public Long getCounterValue() {
        return this.value;
    }

    public int getProcessId() {
        return this.processId;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        return colors;
    }
}

