/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ByteSizeFormatter;
import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.activity.CuptiActivityFlag;
import com.nvidia.viper.activity.CuptiActivityMemcpy;
import com.nvidia.viper.activity.CuptiActivityMemcpyKind;
import com.nvidia.viper.activity.CuptiActivityMemcpyP2p;
import com.nvidia.viper.activity.CuptiActivityMemoryKind;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalHierarchy;
import com.nvidia.viper.model.TimelineIntervalKind;
import com.nvidia.viper.value.ValueBandwidth;

public class TimelineIntervalMemcpy
extends TimelineIntervalHierarchy
implements IModel,
ITimelineInterval {
    protected TimelineIntervalKind kind;
    protected CuptiActivityMemcpy activity;
    private Timeline primaryTimeline;

    public TimelineIntervalMemcpy(TimelineIntervalKind kind, CuptiActivityMemcpy activity) {
        this.kind = kind;
        this.activity = activity;
        this.primaryTimeline = null;
    }

    @Override
    public TimelineIntervalKind getKind() {
        return this.kind;
    }

    @Override
    public String getName() {
        return "Memcpy " + this.activity.getCopyKind().getShortName() + " [" + (this.isAsync() ? "async" : "sync") + "]";
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public int getCorrelationId() {
        return this.activity.correlationId;
    }

    public int getRuntimeCorrelationId() {
        return this.activity.runtimeCorrelationId;
    }

    @Override
    public ViperColors.GradientColors getColor(ViperColors.GradientColors colors) {
        return colors;
    }

    @Override
    public long getStart() {
        return this.activity.start;
    }

    @Override
    public long getEnd() {
        return this.activity.end;
    }

    @Override
    public long getDuration() {
        return this.activity.end - this.activity.start;
    }

    @Override
    public long getExtendedEnd() {
        return this.activity.end;
    }

    @Override
    public long getExtendedDuration() {
        return this.getDuration();
    }

    public long getBytes() {
        return this.activity.bytes;
    }

    public long getThroughput() {
        return new ValueBandwidth(ByteSizeFormatter.Base.KILOBYTE, this.activity.bytes, this.getDuration()).getBandwidth();
    }

    public CuptiActivityMemcpyKind getCopyKind() {
        return this.activity.getCopyKind();
    }

    public CuptiActivityMemoryKind getSrcMemoryKind() {
        return this.activity.getSrcKind();
    }

    public CuptiActivityMemoryKind getDstMemoryKind() {
        return this.activity.getDstKind();
    }

    public boolean isAsync() {
        return CuptiActivityFlag.CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC.isSet(this.activity.flags);
    }

    public int getSourceDeviceId() {
        if (this.activity instanceof CuptiActivityMemcpyP2p) {
            CuptiActivityMemcpyP2p p2p = (CuptiActivityMemcpyP2p)this.activity;
            return p2p.srcDeviceId;
        }
        return -1;
    }

    public int getDestinationDeviceId() {
        if (this.activity instanceof CuptiActivityMemcpyP2p) {
            CuptiActivityMemcpyP2p p2p = (CuptiActivityMemcpyP2p)this.activity;
            return p2p.dstDeviceId;
        }
        return -1;
    }

    boolean isP2PMemcopy() {
        return this.activity instanceof CuptiActivityMemcpyP2p;
    }

    @Override
    public Timeline getPrimaryTimeline() {
        return this.primaryTimeline;
    }

    @Override
    public void setPrimaryTimeline(Timeline timeline) {
        this.primaryTimeline = timeline;
    }

    @Override
    public void appendToPDM(ProfileDataModel pdm) throws ViperException {
        try {
            this.activity.appendToPDM(pdm.getNativeHandle());
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw (ViperException)e;
            }
            throw new ViperException(e);
        }
    }
}

