/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.model.IProfilingData;
import com.nvidia.viper.model.Metric;

public class MetricPerInstance
implements IProfilingData,
Comparable<MetricPerInstance> {
    private final Metric metric;

    public MetricPerInstance(Metric metric) {
        this.metric = metric;
        if (!metric.getEvaluationMode().isPerInstanceMode()) {
            ViperExceptionHandler.logError("expected per-instance evaluation mode for metric " + metric.getName());
        }
    }

    public Metric getMetric() {
        return this.metric;
    }

    @Override
    public IProfilingData.Kind getProfileDataKind() {
        return IProfilingData.Kind.instance_metric;
    }

    @Override
    public String getName() {
        return this.metric.getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MetricPerInstance) || this.metric == null) {
            return false;
        }
        return this.metric.equals(((MetricPerInstance)obj).metric);
    }

    @Override
    public int compareTo(MetricPerInstance other) {
        return this.metric.compareTo(other.metric);
    }

    public int hashCode() {
        return this.metric.hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

