/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.model;

import com.nvidia.common.util.XmlUtil;
import com.nvidia.viper.Activator;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.fs.ConnectionNotFoundException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.model.IModel;
import com.nvidia.viper.model.ISessionSerializable;
import com.nvidia.viper.model.ModelWithProperties;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.Disposable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Executable
extends ModelWithProperties
implements IModel,
ISessionSerializable,
Disposable {
    public static final String PROPERTY_FILENAME = "exec:filename";
    public static final String PROPERTY_WORKINGDIR = "exec:cwd";
    public static final String PROPERTY_ARGS = "exec:args";
    public static final String PROPERTY_ENV = "exec:env";
    public static final String PROPERTY_TIMEOUT = "exec:timeout";
    public static final String PROPERTY_PROFILEONSTART = "exec:profileonstart";
    public static final String PROPERTY_CONCURRENTKERNEL = "exec:concurrentkernel";
    public static final String PROPERTY_APITRACE = "exec:apitrace";
    public static final String PROPERTY_ENVIRONMENTPROFILING = "exec:environmentprofiling";
    public static final String PROPERTY_UVMPROFILING = "exec:uvmprofiling";
    public static final String PROPERTY_LAUNCHCONFIGURATIONNAME = "exec:launchconfiguration";
    public static final String PROPERTY_CONNECTIONNAME = "exec:connectionname";
    private String filename;
    private long lastModifiedTimestamp = 0L;
    private String workingDir;
    private String args;
    private Map<String, String> envMap = new HashMap<String, String>();
    private int timeOut = -1;
    private boolean profileOnStart = true;
    private boolean concurrentKernels = true;
    private boolean apiTrace = true;
    private boolean environmentProfiling = false;
    private boolean uvmProfiling = true;
    private boolean applicationReplay = false;
    private String launchConfigurationName = null;
    private String connectionName = null;

    public Executable() {
    }

    public void dispose() {
    }

    public Executable(Element el) throws ViperException {
        this();
        this.read(el);
    }

    public boolean isTimestampChanged() throws ConnectionNotFoundException {
        return FileSystem.getFilesystem(this.getConnectionName()).isTimestampChanged(this.getFilename(), this.lastModifiedTimestamp);
    }

    public String getFilename() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getFilename();
        }
        return this.filename;
    }

    private Executable resolveSettings() {
        return Activator.getDefault().getViperWorkbench().resolveExecutableSettings(this);
    }

    public void setFilename(String filename) {
        if (!StringUtils.equals(filename, this.filename)) {
            this.filename = filename;
            this.firePropertyChange(PROPERTY_FILENAME);
        }
    }

    public long getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public void setLastModifiedTimestamp(long lastModifiedTime) {
        this.lastModifiedTimestamp = lastModifiedTime;
    }

    public String getWorkingDir() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getWorkingDir();
        }
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        if (!StringUtils.equals(workingDir, this.workingDir)) {
            this.workingDir = workingDir;
            this.firePropertyChange(PROPERTY_WORKINGDIR);
        }
    }

    public String getArgs() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getArgs();
        }
        return this.args;
    }

    public void setArgs(String args) {
        if (!StringUtils.equals(args, this.args)) {
            this.args = args;
            this.firePropertyChange(PROPERTY_ARGS);
        }
    }

    public Map<String, String> getEnv() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getEnv();
        }
        return Collections.unmodifiableMap(this.envMap);
    }

    public void addEnvVar(String name, String value) {
        String currentValue;
        if (!(name == null || StringUtils.equals(currentValue = this.envMap.get(name), value) && this.envMap.containsKey(name))) {
            this.envMap.put(name, value);
            this.firePropertyChange(PROPERTY_ENV);
        }
    }

    public void removeEnvVar(String name) {
        if (this.envMap.containsKey(name)) {
            this.envMap.remove(name);
            this.firePropertyChange(PROPERTY_ENV);
        }
    }

    public boolean isRunnable() throws ConnectionNotFoundException {
        return FileSystem.getFilesystem(this.getConnectionName()).isRunnable(this.getFilename());
    }

    public void setTimeOut(int timeOut) {
        if (this.timeOut != timeOut) {
            this.timeOut = timeOut;
            this.firePropertyChange(PROPERTY_TIMEOUT);
        }
    }

    public int getTimeOut() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.getTimeOut();
        }
        return this.timeOut;
    }

    public void setProfileOnStart(boolean profileOnStart) {
        if (this.profileOnStart != profileOnStart) {
            this.profileOnStart = profileOnStart;
            this.firePropertyChange(PROPERTY_PROFILEONSTART);
        }
    }

    public boolean isProfileOnStart() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isProfileOnStart();
        }
        return this.profileOnStart;
    }

    public void setConcurrentKernel(boolean concurrent) {
        if (this.concurrentKernels != concurrent) {
            this.concurrentKernels = concurrent;
            this.firePropertyChange(PROPERTY_CONCURRENTKERNEL);
        }
    }

    public boolean isConcurrentKernel() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isConcurrentKernel();
        }
        return this.concurrentKernels;
    }

    public void setApiTrace(boolean api) {
        if (this.apiTrace != api) {
            this.apiTrace = api;
            this.firePropertyChange(PROPERTY_APITRACE);
        }
    }

    public boolean isApiTrace() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isApiTrace();
        }
        return this.apiTrace;
    }

    public boolean isEnvironmentProfiling() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isEnvironmentProfiling();
        }
        return this.environmentProfiling;
    }

    public boolean isUvmProfiling() {
        Executable resolved = this.resolveSettings();
        if (resolved != null) {
            return resolved.isUvmProfiling();
        }
        return this.uvmProfiling;
    }

    public void setEnvironmentProfiling(boolean environmentProfiling) {
        if (this.environmentProfiling != environmentProfiling) {
            this.environmentProfiling = environmentProfiling;
            this.firePropertyChange(PROPERTY_ENVIRONMENTPROFILING);
        }
    }

    public void setUvmProfiling(boolean uvmProfiling) {
        if (this.uvmProfiling != uvmProfiling) {
            this.uvmProfiling = uvmProfiling;
            this.firePropertyChange(PROPERTY_UVMPROFILING);
        }
    }

    public void setApplicationReplay(boolean replay) {
        if (this.applicationReplay != replay) {
            this.applicationReplay = replay;
        }
    }

    public boolean isApplicationReplay() {
        return this.applicationReplay;
    }

    public void setLaunchConfigurationName(String launchConfigurationName) {
        if (launchConfigurationName != this.launchConfigurationName && launchConfigurationName != null && !launchConfigurationName.trim().equals(this.launchConfigurationName)) {
            this.launchConfigurationName = launchConfigurationName;
            this.firePropertyChange(PROPERTY_LAUNCHCONFIGURATIONNAME);
        }
    }

    public String getLaunchConfigurationName() {
        return this.launchConfigurationName;
    }

    public void setConnectionName(String connectionName) {
        if (this.connectionName != connectionName && connectionName != null && !connectionName.trim().equals(this.connectionName)) {
            this.connectionName = connectionName;
            this.firePropertyChange(PROPERTY_CONNECTIONNAME);
        }
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    @Override
    public void write(Writer w) throws ViperException {
        try {
            w.write("<executable");
            if (this.filename != null) {
                w.write(" file=\"" + XmlUtil.escapeString((String)this.filename) + "\"");
            }
            if (this.lastModifiedTimestamp > 0L) {
                w.write(" timestamp=\"" + this.lastModifiedTimestamp + "\"");
            }
            if (this.workingDir != null) {
                w.write(" cwd=\"" + XmlUtil.escapeString((String)this.workingDir) + "\"");
            }
            if (this.args != null) {
                w.write(" args=\"" + XmlUtil.escapeString((String)this.args) + "\"");
            }
            if (this.launchConfigurationName != null) {
                w.write(" launchConfiguration=\"" + XmlUtil.escapeString((String)this.launchConfigurationName) + "\"");
            }
            if (this.connectionName != null) {
                w.write(" remoteConnectionName=\"" + XmlUtil.escapeString((String)this.connectionName) + "\"");
            }
            if (this.timeOut >= 0) {
                w.write(" timeout=\"" + this.timeOut + "\"");
            }
            w.write(" profileonstart=\"" + this.profileOnStart + "\"");
            w.write(" concurrentkernels=\"" + this.concurrentKernels + "\"");
            w.write(" apitrace=\"" + this.apiTrace + "\"");
            w.write(" environmentprofiling=\"" + this.environmentProfiling + "\"");
            w.write(" uvmprofiling=\"" + this.uvmProfiling + "\"");
            w.write(">");
            if (this.envMap != null) {
                w.write("<envs>");
                for (String name : this.envMap.keySet()) {
                    String value = this.envMap.get(name);
                    w.write("<env");
                    w.write(" name=\"" + XmlUtil.escapeString((String)name) + "\"");
                    if (value != null) {
                        w.write(" value=\"" + XmlUtil.escapeString((String)value) + "\"");
                    }
                    w.write("/>");
                }
                w.write("</envs>");
            }
            w.write("</executable>\n");
        }
        catch (Exception e) {
            throw new ViperException(e);
        }
    }

    protected void read(Element el) throws ViperException {
        String uvmProfilingStr;
        String environmentProfilingStr;
        String apiTraceStr;
        String concurrentKernelsStr;
        String profileOnStartStr;
        if (!"executable".equals(el.getTagName())) {
            throw new ViperException("expected \"executable\" tag, got " + el.getTagName());
        }
        this.filename = StringUtils.emptyToNull(el.getAttribute("file"));
        String timesStr = StringUtils.emptyToNull(el.getAttribute("timestamp"));
        if (timesStr != null) {
            this.lastModifiedTimestamp = Long.parseLong(timesStr);
        }
        this.workingDir = StringUtils.emptyToNull(el.getAttribute("cwd"));
        this.args = StringUtils.emptyToNull(el.getAttribute("args"));
        this.launchConfigurationName = StringUtils.emptyToNull(el.getAttribute("launchConfiguration"));
        this.connectionName = StringUtils.emptyToNull(el.getAttribute("remoteConnectionName"));
        String timeoutStr = StringUtils.emptyToNull(el.getAttribute("timeout"));
        if (timeoutStr != null) {
            this.timeOut = Integer.parseInt(timeoutStr);
        }
        if ((profileOnStartStr = StringUtils.emptyToNull(el.getAttribute("profileonstart"))) != null) {
            this.profileOnStart = Boolean.parseBoolean(profileOnStartStr);
        }
        if ((concurrentKernelsStr = StringUtils.emptyToNull(el.getAttribute("concurrentkernels"))) != null) {
            this.concurrentKernels = Boolean.parseBoolean(concurrentKernelsStr);
        }
        if ((apiTraceStr = StringUtils.emptyToNull(el.getAttribute("apitrace"))) != null) {
            this.apiTrace = Boolean.parseBoolean(apiTraceStr);
        }
        if ((environmentProfilingStr = StringUtils.emptyToNull(el.getAttribute("environmentprofiling"))) != null) {
            this.environmentProfiling = Boolean.parseBoolean(environmentProfilingStr);
        }
        if ((uvmProfilingStr = StringUtils.emptyToNull(el.getAttribute("uvmprofiling"))) != null) {
            this.uvmProfiling = Boolean.parseBoolean(uvmProfilingStr);
        }
        NodeList envList = el.getElementsByTagName("env");
        int e = 0;
        while (e < envList.getLength()) {
            Element envElement = (Element)envList.item(e);
            if (!"env".equals(envElement.getTagName())) {
                throw new ViperException("expected \"env\" tag, got " + envElement.getTagName());
            }
            String nameStr = StringUtils.emptyToNull(envElement.getAttribute("name"));
            String valueStr = StringUtils.emptyToNull(envElement.getAttribute("value"));
            if (nameStr != null) {
                this.addEnvVar(nameStr, valueStr);
            }
            ++e;
        }
    }
}

