/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class NativeUtils {
    public static String getSharedLibraryPrefix() {
        if ("win32".equals(Platform.getOS())) {
            return "";
        }
        return "lib";
    }

    public static String getSharedLibraryExtension() {
        if ("win32".equals(Platform.getOS())) {
            return ".dll";
        }
        if ("macosx".equals(Platform.getOS())) {
            return ".dylib";
        }
        return ".so";
    }

    public static String getBundledSharedLibraryExtension() {
        if ("win32".equals(Platform.getOS())) {
            return ".dll";
        }
        if ("macosx".equals(Platform.getOS())) {
            return ".jnilib";
        }
        return ".so";
    }

    public static String getInjection32EnvVar() {
        return "CUDA_INJECTION32_PATH";
    }

    public static String getInjection64EnvVar() {
        return "CUDA_INJECTION64_PATH";
    }

    public static String getNvtxInjection32EnvVar() {
        return "NVTX_INJECTION32_PATH";
    }

    public static String getNvtxInjection64EnvVar() {
        return "NVTX_INJECTION64_PATH";
    }

    public static File getTool(final ICudaToolkit.Tool tool) throws CoreException {
        return (File)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, File>(){

            public File runWithService(IToolkitManager service) throws CoreException {
                ICudaToolkit toolkit = service.getDefaultToolkit();
                if (toolkit != null) {
                    return new File(toolkit.getToolPath(tool));
                }
                throw new CoreException(CoreUtil.errorStatus((String)"No CUDA toolkit found", (Object[])new Object[0]));
            }
        });
    }
}

