/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.jni;

import com.nvidia.viper.Activator;
import com.nvidia.viper.jni.CUresult;
import com.nvidia.viper.jni.CuException;
import com.nvidia.viper.jni.CudaOccupancyDeviceProp;
import com.nvidia.viper.jni.CudaOccupancyDeviceState;
import com.nvidia.viper.jni.CudaOccupancyFuncAttribute;
import com.nvidia.viper.jni.CudaOccupancyResult;
import com.nvidia.viper.jni.LibVp;

public class NativeCuda {
    private static boolean initialized = LibVp.initialize();
    private static boolean cudaCapableDevices = true;

    static {
        try {
            if (initialized) {
                NativeCuda.cuInit(System.getProperty("testNoLibcuda") != null);
            }
        }
        catch (CuException e) {
            if (CUresult.CUDA_ERROR_NO_DEVICE.equals((Object)e.getCUresult()) || CUresult.CUDA_ERROR_NOT_SUPPORTED.equals((Object)e.getCUresult())) {
                cudaCapableDevices = false;
            }
            Activator.getDefault().getViperWorkbench().informUnableToLoadLibraries(e);
        }
    }

    public static boolean initialize() {
        return initialized;
    }

    public static boolean hasCudaCapableDevices() {
        return cudaCapableDevices;
    }

    public static native void cuInit(boolean var0) throws CuException;

    public static native int cuDeviceGetCount() throws CuException;

    public static native int cuDeviceGet(int var0) throws CuException;

    public static native String cuDeviceGetName(int var0) throws CuException;

    public static native int cuDeviceComputeCapabilityMajor(int var0) throws CuException;

    public static native int cuDeviceComputeCapabilityMinor(int var0) throws CuException;

    public static native CudaOccupancyResult cudaOccupancyMaxActiveBlocksPerMultiprocessor(CudaOccupancyDeviceProp var0, CudaOccupancyFuncAttribute var1, int var2, int var3, CudaOccupancyDeviceState var4) throws CuException;
}

