/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.fs;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.common.toolkit.IToolkitManager;
import com.nvidia.common.util.CallableWithProgress;
import com.nvidia.common.util.CoreUtil;
import com.nvidia.common.util.IOSGIServiceAccess;
import com.nvidia.cuda.ide.remote.RemoteUtil;
import com.nvidia.cuda.ide.remote.connection.IRemoteConnection;
import com.nvidia.cuda.ide.remote.connection.IRemoteShell;
import com.nvidia.cuda.ide.remote.connection.UserTerminatedException;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.fs.DeviceListNotReadyException;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.FileSystemException;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.fs.NvprofDeviceData;
import com.nvidia.viper.fs.ToolkitNotConfiguredException;
import com.nvidia.viper.model.Executable;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class RemoteFileSystem
extends FileSystem {
    private static final String LAUNCH_STATE_DIRNAME = "launch";
    private static int launchCount = 0;
    private final IRemoteConnection connection;
    private AtomicReference<IDevicesData> deviceData = new AtomicReference<Object>(null);
    private ViperException deviceInformationFetchingFailure = null;
    private AtomicBoolean fetching = new AtomicBoolean(false);

    public RemoteFileSystem(IRemoteConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDevicesData accessDeviceData() throws ViperException, DeviceListNotReadyException {
        if (this.fetching.compareAndSet(false, true)) {
            try {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RemoteFileSystem.this.readDeviceData();
                        }
                        catch (ViperException e) {
                            RemoteFileSystem.this.deviceInformationFetchingFailure = e;
                        }
                    }
                });
            }
            catch (Throwable throwable) {
                AtomicBoolean atomicBoolean = this.fetching;
                synchronized (atomicBoolean) {
                    this.fetching.set(false);
                    this.fetching.notify();
                }
                throw throwable;
            }
            AtomicBoolean atomicBoolean = this.fetching;
            synchronized (atomicBoolean) {
                this.fetching.set(false);
                this.fetching.notify();
            }
        }
        System.out.printf("[RemoteFileSystem::accessDeviceData] Waiting for other thread\n", new Object[0]);
        try {
            AtomicBoolean atomicBoolean = this.fetching;
            synchronized (atomicBoolean) {
                while (this.fetching.get()) {
                    this.fetching.wait();
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.deviceInformationFetchingFailure != null) {
            throw this.deviceInformationFetchingFailure;
        }
        IDevicesData newData = this.deviceData.get();
        if (newData == null) {
            throw new DeviceListNotReadyException(this);
        }
        return newData;
    }

    @Override
    public String browseForDirectory(Shell shell, String title, String prompt, String value) throws CoreException {
        return this.connection.browse(shell, prompt, value);
    }

    @Override
    public String browseForFile(Shell shell, String title, String prompt, String value) throws CoreException {
        return this.connection.browse(shell, prompt, value);
    }

    public String buildProfilerCommandLine(Executable executable, String profilerArguments, IPath profileFile) throws ViperException {
        ICudaToolkit toolkit = this.getToolkit();
        String strCWD = executable.getWorkingDir();
        if (strCWD == null) {
            Path filePath = new Path(executable.getFilename());
            filePath = filePath.removeLastSegments(1);
            strCWD = filePath.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(RemoteUtil.cd((IRemoteConnection)this.connection, (String)strCWD));
        builder.append(RemoteUtil.setEnvironment((IRemoteConnection)this.connection, (ICudaToolkit)toolkit, executable.getEnv()));
        builder.append(toolkit.getToolPath(ICudaToolkit.Tool.Nvprof)).append(" ");
        builder.append(" --quiet ");
        builder.append(profilerArguments);
        builder.append(" -o ").append(RemoteUtil.quote((String)profileFile.toString())).append(" ");
        builder.append(RemoteUtil.quote((String)executable.getFilename()));
        String applicationArguments = executable.getArgs();
        if (!CoreUtil.isNullOrEmpty((String)applicationArguments)) {
            builder.append(" ").append(executable.getArgs());
        }
        return builder.toString();
    }

    @Override
    public void connect(IProgressMonitor monitor) throws CoreException {
        this.connection.connect(IRemoteConnection.Service.Files, monitor);
    }

    private File dowloadProfilingResultFile(IPath profilePath, SubMonitor m) throws ViperException, CoreException {
        IPath localPath = TemporaryDirs.launches.newSubfolder().append(profilePath.lastSegment());
        this.connection.download(profilePath, localPath, false, (IProgressMonitor)m.newChild(300));
        this.connection.deleteFile(profilePath.toString(), (IProgressMonitor)m.newChild(100));
        this.connection.deleteEmptyFolder(profilePath.removeLastSegments(1), (IProgressMonitor)m.newChild(100));
        return localPath.toFile();
    }

    @Override
    public IDevicesData getDeviceData(boolean longRunning) throws DeviceListNotReadyException, ViperException {
        IDevicesData data = this.deviceData.get();
        if (!this.connection.isConnected(IRemoteConnection.Service.Shell)) {
            this.deviceData.compareAndSet(data, null);
        }
        if (this.deviceData.get() != null) {
            return this.deviceData.get();
        }
        if (!longRunning) {
            throw new DeviceListNotReadyException(this);
        }
        return this.accessDeviceData();
    }

    @Override
    public String getName() {
        return this.connection.getName();
    }

    private IPath getProfileFolder(IProgressMonitor monitor) throws ViperException {
        IPath loc;
        IPath launchState = new Path("/tmp/nvvp_" + this.connection.getUserName()).append(LAUNCH_STATE_DIRNAME);
        while (this.connection.isDirectory((loc = launchState.append(String.valueOf(launchCount++))).toString(), (IProgressMonitor)new NullProgressMonitor())) {
        }
        try {
            this.connection.mkdir(loc.toString(), monitor);
        }
        catch (CoreException e) {
            throw new ViperException(String.format("Unable to create directory %s on a remote system", loc.toString()), e);
        }
        return loc;
    }

    private ICudaToolkit getToolkit() throws ViperException, ToolkitNotConfiguredException {
        ICudaToolkit toolkit;
        try {
            toolkit = (ICudaToolkit)CoreUtil.accessService(IToolkitManager.class, (IOSGIServiceAccess)new IOSGIServiceAccess<IToolkitManager, ICudaToolkit>(){

                public ICudaToolkit runWithService(IToolkitManager service) throws CoreException {
                    return service.getToolkit(RemoteFileSystem.this.getName());
                }
            });
        }
        catch (CoreException e) {
            throw new ViperException(e);
        }
        if (toolkit == null) {
            throw new ToolkitNotConfiguredException(this);
        }
        return toolkit;
    }

    @Override
    public boolean isConnected() {
        return this.connection.isConnected(IRemoteConnection.Service.Files);
    }

    @Override
    public boolean isExistingDirectory(String path) throws FileSystemException {
        return this.connection.isDirectory(path, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean isExistingFile(String path) throws FileSystemException {
        return this.connection.isFile(path, false, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean isLocal() {
        return this.connection.isLocalSystem();
    }

    @Override
    public boolean isRunnable(String path) {
        return !this.connection.isConnected(IRemoteConnection.Service.Files) || this.connection.isFile(path, true, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public boolean isTimestampChanged(String path, long lastModifiedTime) {
        return false;
    }

    protected IDevicesData obtainDevicesData(IProgressMonitor monitor) throws ViperException {
        SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (String)"Obtaining list of devices", (int)200);
        ICudaToolkit toolkit = this.getToolkit();
        try {
            String environment = RemoteUtil.setEnvironment((IRemoteConnection)this.connection, (ICudaToolkit)toolkit, Collections.emptyMap());
            String profilerPath = RemoteUtil.quote((String)toolkit.getToolPath(ICudaToolkit.Tool.Nvprof));
            String[] output = this.runCommand(String.format("%s%s %s", environment, profilerPath, "--query-cuda-info"), convert);
            return new NvprofDeviceData(output);
        }
        catch (CoreException e) {
            throw new ViperException(e);
        }
    }

    protected void readDeviceData() throws ViperException {
        if (this.deviceData.get() == null) {
            try {
                this.deviceData.compareAndSet(null, (IDevicesData)new CallableWithProgress<IDevicesData>(){

                    public IDevicesData call(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            return RemoteFileSystem.this.obtainDevicesData(monitor);
                        }
                        catch (ViperException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }.callInDialog());
            }
            catch (InvocationTargetException e) {
                throw (ViperException)CoreUtil.exceptionCast((Throwable)e.getCause());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String[] runCommand(String command, SubMonitor monitor) throws CoreException {
        IRemoteShell shell = this.connection.openShell((IProgressMonitor)monitor.newChild(100));
        if (monitor.isCanceled()) {
            return null;
        }
        String remoteShell = String.format("/bin/sh -c %s", RemoteUtil.quote((String)command));
        String[] output = shell.run(remoteShell, 300000, (IProgressMonitor)monitor.newChild(100));
        if (!CoreUtil.isNullOrEmpty((String)System.getenv("VIPER_DEBUG"))) {
            if (output != null) {
                String[] stringArray = output;
                int n = output.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    System.out.println(string);
                    ++n2;
                }
            } else {
                System.err.println("No output!!!");
            }
        }
        return output;
    }

    private boolean runConsoleCommand(String consoleName, String command, SubMonitor monitor) throws CoreException, ViperException {
        IRemoteShell shell = this.connection.openShell((IProgressMonitor)monitor.newChild(100));
        if (monitor.isCanceled()) {
            return false;
        }
        String remoteShell = String.format("/bin/sh -c %s", RemoteUtil.quote((String)command));
        try {
            this.checkNvprofErrorCode(shell.runInteractive(consoleName, remoteShell, (IProgressMonitor)monitor.newChild(100)));
            return true;
        }
        catch (UserTerminatedException userTerminatedException) {
            return false;
        }
    }

    @Override
    public File runNvprof(Executable executable, String profilerArguments, String outputFile, IProgressMonitor monitor) throws CoreException, ViperException {
        File result;
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)600);
        IPath profileFolder = this.getProfileFolder((IProgressMonitor)m.newChild(100));
        IPath profilePath = profileFolder.append(outputFile);
        String commandLine = this.buildProfilerCommandLine(executable, profilerArguments, profilePath);
        String consoleTitle = String.format("%s on %s", new Path(executable.getFilename()).lastSegment(), this.getName());
        if (this.runConsoleCommand(consoleTitle, commandLine, m)) {
            result = this.dowloadProfilingResultFile(profilePath, m);
        } else {
            m.setWorkRemaining(0);
            result = null;
        }
        m.done();
        return result;
    }
}

