/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.fs;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.viper.Activator;
import com.nvidia.viper.StringUtils;
import com.nvidia.viper.TemporaryDirs;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.fs.FileSystem;
import com.nvidia.viper.fs.IDevicesData;
import com.nvidia.viper.fs.LocalSystemDevicesData;
import com.nvidia.viper.jni.NativeUtils;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.run.NvprofResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.console.ConsoleView;

public final class LocalFileSystem
extends FileSystem {
    private IDevicesData deviceData = new LocalSystemDevicesData();

    @Override
    public String browseForDirectory(Shell shell, String title, String prompt, String value) {
        DirectoryDialog fd = new DirectoryDialog(shell, 69632);
        fd.setText(title);
        fd.setMessage(prompt);
        if (value != null) {
            fd.setFilterPath(value);
        }
        return fd.open();
    }

    public static String browseForFileOpen(Shell shell, String title, String setFileName, String prefKey) {
        FileDialog fd = new FileDialog(shell, 69632);
        return LocalFileSystem.getFilePath(title, setFileName, prefKey, fd);
    }

    private static String getFilePath(String title, String setFileName, String prefKey, FileDialog fd) {
        Path path;
        String filename;
        String preferencePath;
        fd.setText(title);
        fd.setFileName(setFileName);
        if (StringUtils.emptyToNull(prefKey) != null && StringUtils.emptyToNull(preferencePath = Activator.getDefault().getPreferenceStore().getString(prefKey)) != null) {
            fd.setFilterPath(preferencePath);
        }
        if (StringUtils.emptyToNull(filename = fd.open()) != null && (path = new Path(filename)).toFile().exists()) {
            Activator.getDefault().getPreferenceStore().setValue(prefKey, path.removeLastSegments(1).toOSString());
        }
        return filename;
    }

    public static String browseForFileSave(Shell shell, String title, String setFileName, String prefKey) {
        FileDialog fd = new FileDialog(shell, 73728);
        fd.setOverwrite(true);
        return LocalFileSystem.getFilePath(title, setFileName, prefKey, fd);
    }

    @Override
    public String browseForFile(Shell shell, String title, String prompt, String value) {
        FileDialog fd = new FileDialog(shell, 69632);
        fd.setText(title);
        if (value != null) {
            fd.setFilterPath(value);
        }
        return fd.open();
    }

    @Override
    public void connect(IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.beginTask("Connecting...", 1);
            monitor.worked(1);
            monitor.done();
        }
    }

    @Override
    public IDevicesData getDeviceData(boolean longRunning) {
        return this.deviceData;
    }

    private Map<String, String> getLaunchEnv(Executable exec) {
        HashMap<String, String> map;
        Map<String, String> env = exec.getEnv();
        if (env != null) {
            String[] rmenvvars;
            map = new HashMap<String, String>(System.getenv());
            map.putAll(env);
            String[] stringArray = rmenvvars = new String[]{"COMPUTE_PROFILE", "CUDA_PROFILE", "OPENCL_PROFILE", NativeUtils.getInjection32EnvVar(), NativeUtils.getInjection64EnvVar(), NativeUtils.getNvtxInjection32EnvVar(), NativeUtils.getNvtxInjection64EnvVar(), "MAKEOVERRIDES"};
            int n = rmenvvars.length;
            int n2 = 0;
            while (n2 < n) {
                String rmenvvar = stringArray[n2];
                map.remove(rmenvvar);
                ++n2;
            }
        } else {
            map = new HashMap();
        }
        return map;
    }

    @Override
    public String getName() {
        return "Local";
    }

    public ILaunchConfiguration getNvprofLaunchConfiguration(Executable executable, String profilerArguments, IPath profileFile) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
        File nvprofFile = NativeUtils.getTool(ICudaToolkit.Tool.Nvprof);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(null, ICudaToolkit.Tool.Nvprof.name());
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", nvprofFile.getAbsolutePath());
        String strCWD = executable.getWorkingDir();
        if (strCWD == null) {
            Path filePath = new Path(executable.getFilename());
            filePath = filePath.removeLastSegments(1);
            strCWD = filePath.toOSString();
        }
        workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", strCWD);
        workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
        workingCopy.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
        IPath logFile = profileFile.removeLastSegments(1);
        logFile = logFile.append(NVPROF_LOG_FILE_NAME);
        String args = String.valueOf(profilerArguments) + " -o " + "\"" + profileFile.toOSString() + "\"";
        args = String.valueOf(args) + " --log-file-verbose \"" + logFile.toOSString() + "\"";
        args = String.valueOf(args) + " \"" + executable.getFilename() + "\"";
        if (executable.getArgs() != null) {
            args = String.valueOf(args) + " " + executable.getArgs();
        }
        if (args != null) {
            workingCopy.setAttribute("org.eclipse.ui.externaltools.ATTR_TOOL_ARGUMENTS", args);
        }
        workingCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, this.getLaunchEnv(executable));
        workingCopy.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
        return workingCopy;
    }

    public int getNvprofResult(ILaunch launch) throws ViperException {
        IProcess[] process;
        int retval = NvprofResult.NVPROF_SUCCESS.getCode();
        IProcess[] iProcessArray = process = launch.getProcesses();
        int n = process.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess iProcess = iProcessArray[n2];
            try {
                retval = iProcess.getExitValue();
                if (NvprofResult.NVPROF_SUCCESS.getCode() != retval) {
                    break;
                }
            }
            catch (Exception e) {
                if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
                    System.out.println("failed to get nvprof return value");
                }
                ViperRunMode.setLastNvprofResult(null);
                throw new ViperException("nvprof unknown error", e);
            }
            ++n2;
        }
        return retval;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isExistingDirectory(String path) {
        return new File(path).isDirectory();
    }

    @Override
    public boolean isExistingFile(String path) {
        return new File(path).isFile();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isRunnable(String filename) {
        if (filename != null) {
            File file = new File(filename);
            return file.canExecute();
        }
        return false;
    }

    @Override
    public boolean isTimestampChanged(String path, long lastModifiedTime) {
        File file = new File(path);
        return file.exists() && file.lastModified() != lastModifiedTime;
    }

    @Override
    public File runNvprof(Executable executable, String profilerArguments, String outputFile, IProgressMonitor monitor) throws CoreException, ViperException {
        IPath profileFolder = TemporaryDirs.launches.newSubfolder();
        IPath profilePath = profileFolder.append(outputFile);
        ILaunchConfiguration workingCopy = this.getNvprofLaunchConfiguration(executable, profilerArguments, profilePath);
        ILaunch launch = workingCopy.launch("run", monitor);
        this.waitForProcessCompletion(launch, monitor, 0);
        if (monitor.isCanceled()) {
            return null;
        }
        if (launch.getProcesses().length == 0) {
            throw new ViperException("Unable to create process");
        }
        this.checkNvprofErrorCode(this.getNvprofResult(launch));
        this.createNvprofLogLink(profileFolder);
        return profilePath.toFile();
    }

    private void addConsoleDocumentListener(final ProcessConsole console, final String path) {
        console.getDocument().addPrenotifiedDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                IDocument doc = event.getDocument();
                FindReplaceDocumentAdapter fir = new FindReplaceDocumentAdapter(doc);
                IRegion reg = null;
                try {
                    reg = fir.find(0, "^nvprof log:.*$", true, true, false, true);
                }
                catch (BadLocationException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
                if (reg == null) {
                    return;
                }
                int lineOffset = reg.getOffset();
                int lineLength = reg.getLength();
                IHyperlink fileLink = console.getHyperlink(lineOffset);
                if (fileLink != null) {
                    return;
                }
                fileLink = new ConsoleLogFileHyperlink(path);
                try {
                    console.addHyperlink(fileLink, lineOffset, lineLength);
                }
                catch (BadLocationException e) {
                    ViperExceptionHandler.logError(e.getMessage());
                }
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    private void createNvprofLogLink(IPath profileFolder) {
        IConsole console2;
        IPath path = profileFolder.append(NVPROF_LOG_FILE_NAME);
        final LinkedList consoles = new LinkedList();
        Display.getDefault().syncExec(new Runnable(){

            private void addConsoleView(IViewPart view) {
                if (view == null || !(view instanceof ConsoleView)) {
                    return;
                }
                IConsole console = ((ConsoleView)view).getConsole();
                if (console != null && console instanceof ProcessConsole) {
                    consoles.add((ProcessConsole)console);
                }
            }

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
                this.addConsoleView(activePage.findView("com.nvidia.viper.consoleview"));
                this.addConsoleView(activePage.findView("org.eclipse.ui.console.ConsoleView"));
            }
        });
        if (consoles.isEmpty()) {
            ViperExceptionHandler.logError("Failed to get console");
            return;
        }
        for (IConsole console2 : consoles) {
            if (!(console2 instanceof ProcessConsole)) continue;
            this.addConsoleDocumentListener((ProcessConsole)console2, path.toOSString());
        }
        console2 = consoles.isEmpty() ? null : (ProcessConsole)consoles.getFirst();
        File file = path.toFile();
        if (console2 != null && file != null && file.exists()) {
            try {
                String currentLine;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                IOConsoleOutputStream stream = console2.newOutputStream();
                while ((currentLine = reader.readLine()) != null) {
                    if (currentLine.indexOf("Warning:") != -1 || currentLine.indexOf("Error:") != -1) {
                        stream.write(String.valueOf(currentLine) + "\n");
                    }
                    if (ViperRunMode.getRunMode() != ViperRunMode.RunMode.TEST) continue;
                    System.out.println(currentLine);
                }
                stream.close();
            }
            catch (IOException e) {
                ViperExceptionHandler.logError(e.getMessage());
            }
        }
    }

    protected void waitForProcessCompletion(final ILaunch launch, IProgressMonitor monitor, int timeOut) {
        IProcess[] processes;
        Timer timer = null;
        if (timeOut > 0) {
            timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    IProcess[] processes = launch.getProcesses();
                    try {
                        IProcess[] iProcessArray = processes;
                        int n = processes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IProcess process = iProcessArray[n2];
                            process.terminate();
                            ++n2;
                        }
                    }
                    catch (DebugException e) {
                        ViperExceptionHandler.logError("Unable to terminate process", e);
                    }
                }
            }, timeOut * 1000);
        }
        IProcess[] iProcessArray = processes = launch.getProcesses();
        int n = processes.length;
        int n2 = 0;
        while (n2 < n) {
            IProcess process = iProcessArray[n2];
            while (!process.isTerminated()) {
                try {
                    if (monitor.isCanceled()) {
                        process.terminate();
                        break;
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    ViperExceptionHandler.logError("Unable to sleep thread", e);
                }
                catch (DebugException e) {
                    ViperExceptionHandler.logError("Unable to terminate process", e);
                }
            }
            ++n2;
        }
        if (timer != null) {
            timer.cancel();
        }
    }

    private class ConsoleLogFileHyperlink
    implements IHyperlink {
        String fFilePath;

        ConsoleLogFileHyperlink(String filePath) {
            this.fFilePath = filePath;
        }

        public void linkActivated() {
            File file = new File(this.fFilePath);
            if (file != null && file.exists()) {
                try {
                    IFileStore fileStore = EFS.getStore((URI)file.toURI());
                    FileStoreEditorInput input = new FileStoreEditorInput(fileStore);
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    activePage.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor", true);
                }
                catch (CoreException e1) {
                    ViperExceptionHandler.logError(e1.getMessage());
                }
            }
        }

        public void linkEntered() {
        }

        public void linkExited() {
        }
    }
}

