/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.SourceSassModel;
import com.nvidia.viper.model.TimelineIntervalKernel;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class SourceSassEditorInput
implements IEditorInput {
    private SourceSassModel sourceSassModel;
    private TimelineIntervalKernel kernelInterval;

    public SourceSassEditorInput(SourceSassModel sourceSassModel) {
        this.sourceSassModel = sourceSassModel;
        AnalysisResultInstructionExecution result = sourceSassModel.getAnalysisResultInstructionExecution();
        if (result != null) {
            this.kernelInterval = result.getKernel();
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        String name;
        if (this.kernelInterval != null && (name = this.kernelInterval.getDisplayName()) != null) {
            int index = name.indexOf(40);
            if (index >= 0) {
                return name.substring(0, index);
            }
            return name;
        }
        return null;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        String name;
        if (this.kernelInterval != null && (name = this.kernelInterval.getDisplayName()) != null) {
            String startTime = new TimeFormatter().format(this.kernelInterval.getStart());
            return "The instruction execution analysis for kernel " + name + ", started at " + startTime;
        }
        return null;
    }

    public Session getSession() {
        if (this.sourceSassModel != null) {
            return this.sourceSassModel.getSession();
        }
        return null;
    }

    public AnalysisResultInstructionExecution getAnalysisResultInstructionExecution() {
        if (this.sourceSassModel != null) {
            return this.sourceSassModel.getAnalysisResultInstructionExecution();
        }
        return null;
    }

    public SourceSassModel getSourceSassModel() {
        return this.sourceSassModel;
    }

    public TimelineIntervalKernel getKernelInterval() {
        return this.kernelInterval;
    }

    public void updateModel(SourceSassModel refModel) {
        this.sourceSassModel.update(refModel);
    }
}

