/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.editor;

import com.nvidia.viper.ViperColors;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ui.ViperViewerBase;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.AbstractRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BarChartColumn
extends AbstractRulerColumn {
    private static final int DEFAULT_WIDTH = 60;
    private static final int BAR_HMARGIN = 5;
    private static final int BAR_HEIGHT = 10;
    public static final int HEADER_WIDTH = 50;
    private ViperViewerBase viewer;
    private DefaultToolTip toolTip;

    public BarChartColumn() {
        this(60);
    }

    public BarChartColumn(int width) {
        this.setWidth(width);
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        Control control = super.createControl(parentRuler, parentControl);
        this.toolTip = new DefaultToolTip(control);
        if (parentRuler != null) {
            this.viewer = (ViperViewerBase)parentRuler.getTextViewer();
        }
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int lineNumber = BarChartColumn.this.toDocumentLineNumber(e.y);
                if (BarChartColumn.this.viewer != null && BarChartColumn.this.viewer.getInstructionExecuted(lineNumber) > 0L) {
                    int inactive = BarChartColumn.this.getInactiveThreadRatio(lineNumber, 100L);
                    int predOff = BarChartColumn.this.getPredOffThreadRatio(lineNumber, 100L);
                    if (predOff >= 0 && inactive >= 0) {
                        long totalThreads = BarChartColumn.this.viewer.getInstructionExecuted(lineNumber) * 32L;
                        String tooltipStr = String.format(ViperMessages.SourceSassBarChart_Tooltip, inactive, BarChartColumn.this.getInactiveThreadRatio(lineNumber, totalThreads), totalThreads, predOff, BarChartColumn.this.getPredOffThreadRatio(lineNumber, totalThreads), totalThreads);
                        BarChartColumn.this.toolTip.activate();
                        BarChartColumn.this.toolTip.setText(tooltipStr);
                        BarChartColumn.this.toolTip.setShift(new Point(10, 0));
                    } else {
                        BarChartColumn.this.toolTip.deactivate();
                    }
                } else {
                    BarChartColumn.this.toolTip.deactivate();
                }
            }
        });
        if (parentRuler != null) {
            this.viewer = (ViperViewerBase)parentRuler.getTextViewer();
            this.viewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    BarChartColumn.this.redraw();
                }
            });
        }
        return control;
    }

    private int getInactiveThreadRatio(int line, long factor) {
        long instructionExecuted = this.viewer.getInstructionExecuted(line);
        if (instructionExecuted > 0L) {
            long totalThreads = instructionExecuted * 32L;
            long inactiveThreads = totalThreads - this.viewer.getThreadInstructionExecuted(line);
            int inactive = (int)((double)inactiveThreads / (double)totalThreads * (double)factor);
            return inactive;
        }
        return 0;
    }

    private int getPredOffThreadRatio(int line, long factor) {
        long instructionExecuted = this.viewer.getInstructionExecuted(line);
        if (instructionExecuted > 0L) {
            long totalThreads = instructionExecuted * 32L;
            long inactiveThreads = totalThreads - this.viewer.getThreadInstructionExecuted(line);
            long predFalseThreads = totalThreads - inactiveThreads - this.viewer.getNoPredicateOff(line);
            int predFalse = (int)((double)predFalseThreads / (double)totalThreads * (double)factor);
            return predFalse;
        }
        return 0;
    }

    protected void paintLine(GC gc, int modelLine, int widgetLine, int linePixel, int lineHeight) {
        super.paintLine(gc, modelLine, widgetLine, linePixel, lineHeight);
        if (this.viewer != null && this.viewer.getInstructionExecuted(widgetLine) > 0L) {
            int predFalseWidth;
            int barBorderY = linePixel + (lineHeight - 10 + 1) / 2;
            int barWidth = this.getWidth() - 10;
            int inactiveWidth = this.getInactiveThreadRatio(widgetLine, barWidth);
            if (inactiveWidth > 0) {
                gc.setBackground(ViperColors.COLOR_INACTIVE_THREADS);
                gc.fillRectangle(5, barBorderY, inactiveWidth, 10);
            }
            if ((predFalseWidth = this.getPredOffThreadRatio(widgetLine, barWidth)) > 0) {
                gc.setBackground(ViperColors.COLOR_PRED_OFF_THREADS);
                gc.fillRectangle(5 + inactiveWidth, barBorderY, predFalseWidth, 10);
            }
            gc.setForeground(ViperColors.COLOR_GRAPH_BORDER);
            gc.drawRectangle(4, barBorderY - 1, barWidth + 1, 11);
        }
    }
}

