/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.common.toolkit.ICudaToolkit;
import com.nvidia.viper.activity.CuptiActivityInstructionExecution;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisBase;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultInstructionExecution;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.jni.NativeUtils;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import java.util.List;
import org.eclipse.core.runtime.CoreException;

public class KernelInstanceInstructionExecutionAnalysis
extends AnalysisBase {
    @Override
    public boolean run(Session session, List<AnalysisResult> results, boolean generateAllResults) {
        boolean ret = false;
        try {
            NativeUtils.getTool(ICudaToolkit.Tool.Nvdisasm);
        }
        catch (CoreException coreException) {
            results.add(new AnalysisResult(AnalysisDescriptor.SL_INSTRUCTION_EXECUTION_NO_DISASM));
            return false;
        }
        Analysis analysis = session.getAnalysis();
        if (analysis != null) {
            TimelineIntervalKernel interval = AnalysisStage.getHostLaunchedKernel(analysis.getActiveScopeInterval());
            if (interval == null || generateAllResults) {
                results.add(new AnalysisResult(AnalysisDescriptor.SL_INSTRUCTION_EXECUTION_NO_KERNEL));
            }
            if (interval instanceof TimelineIntervalKernel) {
                TimelineIntervalKernel kernel = interval;
                int totalResults = 0;
                int droppedResults = 0;
                AnalysisResultInstructionExecution dpa = new AnalysisResultInstructionExecution(session, kernel, AnalysisDescriptor.SL_INSTRUCTION_EXECUTION);
                for (ICuptiActivitySourceLevelResult result : kernel.getSourceLevelResults()) {
                    if (!(result instanceof CuptiActivityInstructionExecution)) continue;
                    ++totalResults;
                    ret = true;
                    if (dpa.addResult(result)) continue;
                    ++droppedResults;
                }
                if (dpa.getSourceLevelResultCount() > 0 || generateAllResults) {
                    results.add(dpa);
                }
                if (droppedResults > 0 || generateAllResults) {
                    AnalysisDescriptor desc = droppedResults == totalResults ? AnalysisDescriptor.SL_INSTRUCTION_EXECUTION_NO_SOURCE : AnalysisDescriptor.SL_INSTRUCTION_EXECUTION_FEW_SOURCE;
                    results.add(new AnalysisResult(desc));
                }
                if (totalResults <= 0 || generateAllResults) {
                    results.add(new AnalysisResult(AnalysisDescriptor.SL_INSTRUCTION_EXECUTION_NO_DATA));
                }
            }
        }
        return ret;
    }
}

