/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.TimelineIntervalKernel;

public enum AnalysisScope {
    NONE,
    APPLICATION,
    KERNEL_INSTANCE;

    public static final Integer APPLICATION_ANALYSIS_ID;
    private static final AnalysisStage[] orderedApplicationStages;
    private static final AnalysisStage[] orderedKernelInstanceStages;

    static {
        APPLICATION_ANALYSIS_ID = new Integer(0);
        orderedApplicationStages = new AnalysisStage[]{AnalysisStage.TIMELINE, AnalysisStage.KERNELS, AnalysisStage.KERNELS_PERFORMANCE};
        orderedKernelInstanceStages = new AnalysisStage[]{AnalysisStage.KERNEL_INSTANCE_BOUNDS, AnalysisStage.KERNEL_INSTANCE_LATENCY, AnalysisStage.KERNEL_INSTANCE_SM, AnalysisStage.KERNEL_INSTANCE_MEMORY, AnalysisStage.KERNEL_INSTANCE_UNCOALESCED_GLOBAL, AnalysisStage.KERNEL_INSTANCE_SHARED_ACCESS, AnalysisStage.KERNEL_INSTANCE_DIVERGENT_BRANCH, AnalysisStage.KERNEL_INSTANCE_INSTRUCTION_EXECUTION};
    }

    public AnalysisStage[] getOrderedStages() {
        switch (this) {
            case APPLICATION: {
                return orderedApplicationStages;
            }
            case KERNEL_INSTANCE: {
                return orderedKernelInstanceStages;
            }
        }
        return new AnalysisStage[0];
    }

    public Integer getAnalysisId(ITimelineInterval interval) {
        switch (this) {
            case APPLICATION: {
                return APPLICATION_ANALYSIS_ID;
            }
            case KERNEL_INSTANCE: {
                if (!(interval instanceof TimelineIntervalKernel)) break;
                return interval.getCorrelationId();
            }
        }
        return null;
    }

    public boolean isEnabled(ITimelineInterval interval) {
        switch (this) {
            case APPLICATION: {
                return true;
            }
            case KERNEL_INSTANCE: {
                return interval instanceof TimelineIntervalKernel && ((TimelineIntervalKernel)interval).isHostLaunched();
            }
        }
        return false;
    }

    public String getLabel(ITimelineInterval interval) {
        switch (this) {
            case KERNEL_INSTANCE: {
                return interval.getDisplayName();
            }
            case APPLICATION: {
                return "Application";
            }
        }
        return "<unexpected>";
    }
}

