/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.KernelPriorityResultGraphicFactory;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalysisResultKernelPriority
extends AnalysisResult {
    private final List<PriorityRecord> records = new LinkedList<PriorityRecord>();
    private final Map<ITimelineInterval, PriorityRecord> intervalMap = new HashMap<ITimelineInterval, PriorityRecord>();
    private PriorityRecord[] orderedRecords = null;

    public AnalysisResultKernelPriority(AnalysisDescriptor desc) {
        super(desc);
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelPriorityResultGraphicFactory();
    }

    public PriorityRecord[] getPriorityRecords() {
        if (this.orderedRecords == null) {
            this.orderedRecords = this.records.toArray(new PriorityRecord[0]);
            Arrays.sort(this.orderedRecords);
        }
        return this.orderedRecords;
    }

    public PriorityRecord getPriorityRecord(ITimelineInterval interval) {
        if (interval == null) {
            return null;
        }
        return this.intervalMap.get(interval);
    }

    public void addResult(PriorityRecord record) {
        this.records.add(record);
        for (TimelineIntervalPair pair : record.getIntervals()) {
            if (pair.getInterval() == null) continue;
            this.intervalMap.put(pair.getInterval(), record);
        }
        this.orderedRecords = null;
    }

    public void normalizePriorities() {
        long max = 0L;
        for (PriorityRecord rec : this.records) {
            max = Math.max(max, rec.getPriority());
        }
        for (PriorityRecord rec : this.records) {
            rec.normalize(max);
        }
    }

    public static class PriorityRecord
    implements Comparable<PriorityRecord> {
        private final Timeline timeline;
        private final Set<ITimelineInterval> intervals;
        private long priority;

        public PriorityRecord(Timeline timeline) {
            this.timeline = timeline;
            this.intervals = new HashSet<ITimelineInterval>();
            this.priority = 1L;
        }

        public String getName() {
            if (this.timeline != null) {
                return "[ " + this.intervals.size() + " kernel instances ] " + this.timeline.getDisplayName(false);
            }
            return "<unknown>";
        }

        public String getTooltip() {
            return null;
        }

        public long getPriority() {
            return this.priority;
        }

        public List<TimelineIntervalPair> getIntervals() {
            ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(this.intervals.size());
            for (ITimelineInterval interval : this.intervals) {
                pairs.add(new TimelineIntervalPair(this.timeline, interval));
            }
            return pairs;
        }

        public void addInterval(ITimelineInterval interval, long intervalPriority) {
            this.intervals.add(interval);
            this.priority += intervalPriority;
        }

        public void normalize(long max) {
            this.priority = Math.max(1L, (long)((double)this.priority / (double)max * 100.0));
        }

        @Override
        public int compareTo(PriorityRecord o) {
            if (this.getPriority() != o.getPriority()) {
                long d = this.priority - o.priority;
                return d == 0L ? 0 : (d < 0L ? 1 : -1);
            }
            return this.getName().compareTo(o.getName());
        }
    }
}

