/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.KernelInstructionGraphicFactory;
import com.nvidia.viper.analysis.ResultOutput;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AnalysisResultKernelInstructionClass
extends AnalysisResult {
    private final TimelineIntervalKernel kernel;
    private final Map<InstructionClass, Long> instructionClassExecCount;
    private final long totalExecCount;

    public AnalysisResultKernelInstructionClass(TimelineIntervalKernel kernel, long execCount) {
        super(AnalysisDescriptor.KERNEL_COMPUTE_INSTRUCTION_CLASS);
        this.kernel = kernel;
        this.totalExecCount = execCount;
        this.instructionClassExecCount = new HashMap<InstructionClass, Long>();
    }

    public TimelineIntervalKernel getKernel() {
        return this.kernel;
    }

    public long getTotalExecCount() {
        return this.totalExecCount;
    }

    public List<InstructionClass> getInstructionClasses() {
        LinkedList<InstructionClass> ics = new LinkedList<InstructionClass>();
        InstructionClass[] instructionClassArray = InstructionClass.values();
        int n = instructionClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            InstructionClass ic = instructionClassArray[n2];
            if (this.instructionClassExecCount.containsKey((Object)ic)) {
                ics.add(ic);
            }
            ++n2;
        }
        return ics;
    }

    public Long getInstructionClassExecCount(InstructionClass ic) {
        return this.instructionClassExecCount.get((Object)ic);
    }

    public void setInstructionClassExecCount(InstructionClass ic, long execCount) {
        this.instructionClassExecCount.put(ic, execCount);
    }

    @Override
    public String getDescription(ResultOutput otpt) {
        String desc = super.getDescription(otpt);
        desc = desc.replace("%INACTIVE%", "\"" + ViperMessages.KernelSM_InstClass_Inactive_Label + "\"");
        return desc;
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.kernel.getPrimaryTimeline(), this.kernel);
        pairs.add(pair);
        return pairs;
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new KernelInstructionGraphicFactory();
    }

    public static enum InstructionClass {
        FP32("FP32", "inst_fp_32"),
        FP64("FP64", "inst_fp_64"),
        INT("Integer", "inst_integer"),
        CONTROL("Control-Flow", "inst_control"),
        LDST("Load/Store", "inst_compute_ld_st"),
        BITCONVERT("Bit-Convert", "inst_bit_convert"),
        COMM("Comm.", "inst_inter_thread_communication"),
        MISC("Misc.", "inst_misc");

        private final String name;
        private final String metricName;

        private InstructionClass(String name, String metricName) {
            this.name = name;
            this.metricName = metricName;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String toString() {
            return this.name;
        }

        public String getLegendName() {
            return "(" + this.name + ")";
        }
    }
}

