/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.ViperHelp;
import com.nvidia.viper.activity.CuptiActivityBranch;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResultSourceLevel;
import com.nvidia.viper.analysis.SourceLevelResultGraphicFactory;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.ui.analysis.IAnalysisResultGraphicFactory;
import java.text.NumberFormat;
import org.eclipse.jface.action.Action;

public class AnalysisResultDivergentBranch
extends AnalysisResultSourceLevel {
    private static NumberFormat percentFormatter = NumberFormat.getPercentInstance();

    static {
        percentFormatter.setMaximumFractionDigits(1);
        percentFormatter.setGroupingUsed(false);
    }

    public AnalysisResultDivergentBranch(Session session, TimelineIntervalKernel kernel, AnalysisDescriptor desc) {
        super(session, kernel, desc);
    }

    public TimelineIntervalKernel getKernel() {
        return (TimelineIntervalKernel)this.getInterval();
    }

    @Override
    public IAnalysisResultGraphicFactory getAnalysisResultFactory() {
        return new SourceLevelResultGraphicFactory();
    }

    @Override
    public String getResultDescription(ICuptiActivitySourceLevelResult result) {
        if (result instanceof CuptiActivityBranch) {
            CuptiActivityBranch branch = (CuptiActivityBranch)result;
            double divergence = (double)branch.diverged / (double)branch.executed;
            return "Divergence = " + percentFormatter.format(divergence) + " [ " + branch.diverged + " divergent executions out of " + branch.executed + " total executions ]";
        }
        return super.getResultDescription(result);
    }

    @Override
    public boolean addResult(ICuptiActivitySourceLevelResult slr) {
        if (super.addResult(slr)) {
            this.addMarkers(slr);
            return true;
        }
        return false;
    }

    @Override
    public Action getMoreAction() {
        return new MoreAction();
    }

    private class MoreAction
    extends Action {
        private MoreAction() {
        }

        public void run() {
            ViperHelp.displayHelp(ViperHelp.BRANCHING_AND_DIVERGENCE);
        }
    }
}

