/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.actions.ResetAnalysisAction;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.actions.RunnerAction;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.run.Runner;
import com.nvidia.viper.ui.CollectNewTimelineMessageDialog;
import org.eclipse.gef.Disposable;

public class RunTimelineAction
extends RunnerAction
implements Disposable {
    private Session session;

    public RunTimelineAction(Session session) {
        super(ViperMessages.RunTimeline_Label, ViperImages.DESC_RUN_TIMELINE);
        this.setToolTipText(ViperMessages.RunTimeline_Tooltip);
        this.setId("com.nvidia.viper.runtimeline");
        this.session = session;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.session = null;
    }

    public void run() {
        if (!this.session.getTimelines().isEmpty()) {
            boolean isRunnable = Runner.checkRunnable(this.session, true);
            if (isRunnable && CollectNewTimelineMessageDialog.show() == 0) {
                new ResetAnalysisAction(this.session, true).run();
            } else {
                return;
            }
        }
        new RunAnalysisAction(this.session, true, RunAnalysisAction.ShowMode.GUIDED).run();
    }
}

