/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.actions;

import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.ViperRunMode;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Executable;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.NewSessionWizard;
import com.nvidia.viper.ui.SessionEditorInput;
import java.util.Properties;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;

public class NewSessionAction
extends Action
implements IIntroAction {
    private IWorkbenchWindow window;
    private static int sessionNum = 1;

    public NewSessionAction() {
    }

    public NewSessionAction(IWorkbenchWindow window) {
        super(ViperMessages.NewSession_Label, ViperImages.DESC_NEW_SESSION);
        this.window = window;
        this.setToolTipText(ViperMessages.NewSession_Tooltip);
        this.setId("com.nvidia.viper.sessionnew");
        this.setActionDefinitionId("com.nvidia.viper.command.newsession");
    }

    public void run() {
        Executable executable = new Executable();
        NewSessionAction.createNewSession(executable, this.window, true);
    }

    public void run(IIntroSite site, Properties params) {
        this.window = site.getWorkbenchWindow();
        Viper.closeWelcomePage(this.window);
        this.run();
    }

    public static void createNewSession(Executable executable, IWorkbenchWindow window, boolean newSessionOption) {
        IWorkbenchPage activePage = window.getActivePage();
        Session session = new Session();
        session.setExecutable(executable);
        session.setExpert(new Expert());
        session.setAnalysis(new Analysis());
        session.setExpertSystem(new ExpertSystem(session));
        NewSessionWizard newSessionWizard = new NewSessionWizard(session);
        if (ViperRunMode.getRunMode() == ViperRunMode.RunMode.TEST) {
            return;
        }
        WizardDialog dialog = new WizardDialog(window.getShell(), (IWizard)newSessionWizard);
        dialog.create();
        if (newSessionOption) {
            newSessionWizard.getExecutablePropertyPage().setErrorMessage(null);
        }
        if (dialog.open() == 0) {
            if (!newSessionWizard.isDisableAnalysis()) {
                new RunAnalysisAction(session, true, RunAnalysisAction.ShowMode.GUIDED).run();
            } else {
                try {
                    window.getActivePage().showView("com.nvidia.viper.analysisview");
                }
                catch (PartInitException partInitException) {
                    ViperExceptionHandler.logError("unable to show analysis view");
                }
            }
            try {
                activePage.openEditor((IEditorInput)new SessionEditorInput(session), "com.nvidia.viper.sessioneditor");
            }
            catch (PartInitException e) {
                ViperExceptionHandler.handle(ViperMessages.New_Fail_Title, ViperMessages.New_Fail_Message, new ViperException(e));
            }
            session.setName("NewSession" + sessionNum++);
        }
    }
}

