/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper;

import com.nvidia.viper.activity.CuptiActivityComputeApiKind;
import com.nvidia.viper.activity.CuptiActivityContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiProcessPDMManager {
    private List<String> pdmNameList;
    private List<Long> maxCorrIdList = new ArrayList<Long>();
    private Map<String, Map<OriginalContext, NewContext>> pdmContextMap;
    private Map<String, Map<OriginalStream, NewStream>> pdmStreamMap;
    private Map<Integer, Integer> nextContextIdMap;
    private Map<Integer, Integer> nextStreamIdMap;

    public MultiProcessPDMManager() {
        this.pdmNameList = new ArrayList<String>();
        this.pdmContextMap = new HashMap<String, Map<OriginalContext, NewContext>>();
        this.nextContextIdMap = new HashMap<Integer, Integer>();
        this.pdmStreamMap = new HashMap<String, Map<OriginalStream, NewStream>>();
        this.nextStreamIdMap = new HashMap<Integer, Integer>();
    }

    private boolean isDuplicateContextId(int ctxId, int deviceId) {
        for (Map<OriginalContext, NewContext> ctxMap : this.pdmContextMap.values()) {
            for (OriginalContext orgContext : ctxMap.keySet()) {
                if (!orgContext.equals(new OriginalContext(ctxId, deviceId, null, -1))) continue;
                return true;
            }
        }
        return false;
    }

    private int getUniqueContextId(int deviceId) {
        List<Integer> ctsIds = this.getNewContextIds(deviceId);
        if (!this.nextContextIdMap.containsKey(deviceId)) {
            this.nextContextIdMap.put(deviceId, 1);
        }
        int uniqueId = this.nextContextIdMap.get(deviceId);
        while (uniqueId < Integer.MAX_VALUE) {
            if (!ctsIds.contains(uniqueId)) break;
            ++uniqueId;
        }
        int next = this.nextContextIdMap.get(deviceId) + 1;
        this.nextContextIdMap.put(deviceId, next);
        return uniqueId;
    }

    private List<Integer> getNewContextIds(int deviceId) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map<OriginalContext, NewContext> deviceCtxMap : this.pdmContextMap.values()) {
            for (Map.Entry<OriginalContext, NewContext> entry : deviceCtxMap.entrySet()) {
                OriginalContext orgCtx = entry.getKey();
                if (orgCtx.deviceId != deviceId) continue;
                list.add(entry.getValue().contextId);
            }
        }
        return list;
    }

    public void addContext(CuptiActivityContext context, String pdm) {
        int newId = context.contextId;
        String customName = null;
        if (CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS.equals((Object)context.getComputeKind())) {
            newId = 1;
            customName = "MPS";
        } else if (this.isDuplicateContextId(context.contextId, context.deviceId)) {
            newId = this.getUniqueContextId(context.deviceId);
        }
        Map<Object, Object> deviceCtxMap = this.pdmContextMap.containsKey(pdm) ? this.pdmContextMap.get(pdm) : new HashMap();
        OriginalContext orgCtx = new OriginalContext(context.contextId, context.deviceId, context.getComputeKind(), context.defaultStreamId);
        NewContext newCtx = new NewContext(newId, customName);
        deviceCtxMap.put(orgCtx, newCtx);
        this.pdmContextMap.put(pdm, deviceCtxMap);
    }

    public void setContextCustomName(String ctxCustomName, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (Map.Entry<OriginalContext, NewContext> entry : deviceCtxMap.entrySet()) {
                OriginalContext orgCtx = entry.getKey();
                NewContext newCtx = entry.getValue();
                if (newCtx.customName != null) continue;
                newCtx.customName = String.valueOf(Integer.toString(orgCtx.contextId)) + "-" + ctxCustomName;
            }
        }
    }

    public void setStreamCustomName(String streamCustomName, String pdm) {
        Map<OriginalStream, NewStream> streamMap = this.pdmStreamMap.get(pdm);
        if (streamMap != null) {
            for (Map.Entry<OriginalStream, NewStream> entry : streamMap.entrySet()) {
                OriginalStream orgStream = entry.getKey();
                NewStream newStream = entry.getValue();
                if (newStream.customName != null) continue;
                String name = this.isDefaultStream(orgStream, pdm) ? "Default" : Integer.toString(orgStream.streamId);
                newStream.customName = String.valueOf(name) + "-" + streamCustomName;
            }
        }
    }

    private boolean isDefaultStream(OriginalStream orgStream, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (OriginalContext orgCtx : deviceCtxMap.keySet()) {
                if (orgCtx.contextId != orgStream.contextId || orgCtx.deviceId != orgStream.deviceId) continue;
                if (orgCtx.defaultStreamId == -1 && (orgStream.streamId == 1 || orgStream.streamId == 2)) {
                    return true;
                }
                if (orgCtx.defaultStreamId != orgStream.streamId) continue;
                return true;
            }
        }
        return false;
    }

    public int getNewContextId(int contextId, int deviceId, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (Map.Entry<OriginalContext, NewContext> entry : deviceCtxMap.entrySet()) {
                OriginalContext orgCtx = entry.getKey();
                if (!orgCtx.equals(new OriginalContext(contextId, deviceId, null, -1))) continue;
                return entry.getValue().contextId;
            }
        }
        return contextId;
    }

    public String getContextCustomName(int contextId, int deviceId, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (Map.Entry<OriginalContext, NewContext> entry : deviceCtxMap.entrySet()) {
                OriginalContext orgCtx = entry.getKey();
                if (!orgCtx.equals(new OriginalContext(contextId, deviceId, null, -1))) continue;
                return entry.getValue().customName;
            }
        }
        return null;
    }

    public String getStreamCustomName(int streamId, int contextId, int deviceId, String pdm) {
        Map<OriginalStream, NewStream> streamMap = this.pdmStreamMap.get(pdm);
        if (streamMap != null) {
            for (Map.Entry<OriginalStream, NewStream> entry : streamMap.entrySet()) {
                OriginalStream orgStream = entry.getKey();
                if (!orgStream.equals(new OriginalStream(deviceId, contextId, streamId))) continue;
                return entry.getValue().customName;
            }
        }
        return null;
    }

    public void setMaxCorrelationId(long maxCorrId, String pdm) {
        if (!this.isCorrelationIdOverflow()) {
            if (this.pdmNameList.size() > 0) {
                maxCorrId += this.maxCorrIdList.get(this.pdmNameList.size() - 1).longValue();
            }
            this.maxCorrIdList.add(maxCorrId);
            this.pdmNameList.add(pdm);
        }
    }

    private boolean isCorrelationIdOverflow() {
        return !this.maxCorrIdList.isEmpty() && this.maxCorrIdList.get(this.maxCorrIdList.size() - 1) > Integer.MAX_VALUE;
    }

    public int getNewCorrelationId(int correlationId, String pdm) {
        int index = this.pdmNameList.indexOf(pdm);
        if (index == 0) {
            return correlationId;
        }
        if (index > 0) {
            long newCorrId = (long)correlationId + this.maxCorrIdList.get(index - 1);
            if (newCorrId > Integer.MAX_VALUE) {
                return 0;
            }
            return (int)newCorrId;
        }
        return 0;
    }

    public void addStream(int streamId, int contextId, int deviceId, String pdm) {
        String customName = null;
        if (!this.isDuplicateStreamEntry(streamId, contextId, deviceId, pdm)) {
            int newId = this.getUniqueStreamId(deviceId);
            Map<Object, Object> streamMap = this.pdmStreamMap.containsKey(pdm) ? this.pdmStreamMap.get(pdm) : new HashMap();
            OriginalStream orgStream = new OriginalStream(deviceId, contextId, streamId);
            if (!this.isMPSContext(contextId, deviceId, pdm)) {
                customName = this.isDefaultStream(orgStream, pdm) ? "Default" : Integer.toString(streamId);
            }
            streamMap.put(orgStream, new NewStream(newId, customName));
            this.pdmStreamMap.put(pdm, streamMap);
        }
    }

    private boolean isDuplicateStreamEntry(int streamId, int contextId, int deviceId, String pdm) {
        if (this.pdmStreamMap.containsKey(pdm)) {
            Map<OriginalStream, NewStream> streamMap = this.pdmStreamMap.get(pdm);
            for (OriginalStream stream : streamMap.keySet()) {
                if (!stream.equals(new OriginalStream(deviceId, contextId, streamId))) continue;
                return true;
            }
        }
        return false;
    }

    private int getUniqueStreamId(int deviceId) {
        List<Integer> streamIds = this.getNewStreamIds();
        if (!this.nextStreamIdMap.containsKey(deviceId)) {
            this.nextStreamIdMap.put(deviceId, 1);
        }
        int uniqueId = this.nextStreamIdMap.get(deviceId);
        while (uniqueId < Integer.MAX_VALUE) {
            if (!streamIds.contains(uniqueId)) break;
            ++uniqueId;
        }
        int next = this.nextStreamIdMap.get(deviceId) + 1;
        this.nextStreamIdMap.put(deviceId, next);
        return uniqueId;
    }

    private List<Integer> getNewStreamIds() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map<OriginalStream, NewStream> streamMap : this.pdmStreamMap.values()) {
            for (NewStream newStream : streamMap.values()) {
                list.add(newStream.streamId);
            }
        }
        return list;
    }

    public int getNewStreamId(int streamId, int contextId, int deviceId, String pdm) {
        Map<OriginalStream, NewStream> streamMap;
        if (this.isMPSContext(contextId, deviceId, pdm) && (streamMap = this.pdmStreamMap.get(pdm)) != null) {
            for (Map.Entry<OriginalStream, NewStream> entry : streamMap.entrySet()) {
                OriginalStream stream = entry.getKey();
                if (!stream.equals(new OriginalStream(deviceId, contextId, streamId))) continue;
                return entry.getValue().streamId;
            }
        }
        return streamId;
    }

    private boolean isMPSContext(int contextId, int deviceId, String pdm) {
        Map<OriginalContext, NewContext> deviceCtxMap = this.pdmContextMap.get(pdm);
        if (deviceCtxMap != null) {
            for (OriginalContext orgCtx : deviceCtxMap.keySet()) {
                if (!orgCtx.equals(new OriginalContext(contextId, deviceId, null, -1))) continue;
                return CuptiActivityComputeApiKind.CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS.equals((Object)orgCtx.computeKind);
            }
        }
        return false;
    }

    private class NewContext {
        private int contextId;
        private String customName;

        public NewContext(int contextId, String customName) {
            this.contextId = contextId;
            this.customName = customName;
        }
    }

    private class NewStream {
        private int streamId;
        private String customName;

        public NewStream(int streamId, String customName) {
            this.streamId = streamId;
            this.customName = customName;
        }
    }

    private class OriginalContext {
        private int contextId;
        private int deviceId;
        private CuptiActivityComputeApiKind computeKind;
        private int defaultStreamId;

        public OriginalContext(int contextId, int deviceId, CuptiActivityComputeApiKind computeKind, int defaultStreamId) {
            this.contextId = contextId;
            this.deviceId = deviceId;
            this.computeKind = computeKind;
            this.defaultStreamId = defaultStreamId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OriginalContext) {
                OriginalContext ctx = (OriginalContext)obj;
                if (this.contextId == ctx.contextId && this.deviceId == ctx.deviceId) {
                    return true;
                }
            }
            return false;
        }
    }

    private class OriginalStream {
        private int deviceId;
        private int contextId;
        private int streamId;

        public OriginalStream(int deviceId, int contextId, int streamId) {
            this.deviceId = deviceId;
            this.contextId = contextId;
            this.streamId = streamId;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OriginalStream) {
                OriginalStream stream = (OriginalStream)obj;
                if (this.deviceId == stream.deviceId && this.contextId == stream.contextId && this.streamId == stream.streamId) {
                    return true;
                }
            }
            return false;
        }
    }
}

