/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Position implements Enumerator
{
    ABOVE_LITERAL(0, "Above", "Above"),
    BELOW_LITERAL(1, "Below", "Below"),
    LEFT_LITERAL(2, "Left", "Left"),
    RIGHT_LITERAL(3, "Right", "Right"),
    INSIDE_LITERAL(4, "Inside", "Inside"),
    OUTSIDE_LITERAL(5, "Outside", "Outside");

    public static final int ABOVE = 0;
    public static final int BELOW = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int INSIDE = 4;
    public static final int OUTSIDE = 5;
    private static final Position[] VALUES_ARRAY;
    public static final List<Position> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Position[]{ABOVE_LITERAL, BELOW_LITERAL, LEFT_LITERAL, RIGHT_LITERAL, INSIDE_LITERAL, OUTSIDE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Position get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Position result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Position getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Position result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Position get(int value) {
        switch (value) {
            case 0: {
                return ABOVE_LITERAL;
            }
            case 1: {
                return BELOW_LITERAL;
            }
            case 2: {
                return LEFT_LITERAL;
            }
            case 3: {
                return RIGHT_LITERAL;
            }
            case 4: {
                return INSIDE_LITERAL;
            }
            case 5: {
                return OUTSIDE_LITERAL;
            }
        }
        return null;
    }

    private Position(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

