/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IDimLevel;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.aggregation.AggregationManager;
import org.eclipse.birt.data.engine.api.aggregation.IAggrFunction;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.IQueryService;
import org.eclipse.birt.data.engine.olap.api.ICubeQueryResults;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.query.view.CubeQueryDefinitionUtil;
import org.eclipse.birt.data.engine.olap.script.JSCubeBindingObject;
import org.eclipse.birt.data.engine.olap.util.CubeAggrDefnOnMeasure;
import org.eclipse.birt.data.engine.olap.util.CubeNestAggrDefn;
import org.eclipse.birt.data.engine.olap.util.CubeRunningNestAggrDefn;
import org.eclipse.birt.data.engine.olap.util.OlapExpressionCompiler;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlapExpressionUtil {
    private static Logger logger = Logger.getLogger(OlapExpressionUtil.class.getName());

    public static String getAttrReference(String dimName, String levelName, String attrName) {
        return String.valueOf(dimName) + '/' + levelName + '/' + attrName;
    }

    public static Set<IDimLevel> getAggregateOnLevel(IBinding targetBinding, List<IBinding> bindings, Set<IDimLevel> mostDetailed) throws DataException {
        HashSet<String> visited = new HashSet<String>();
        HashSet<IDimLevel> valid = new HashSet<IDimLevel>();
        try {
            OlapExpressionUtil.getBindings(visited, valid, targetBinding, bindings, mostDetailed);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        return valid;
    }

    public static Set<IDimLevel> getAggregateOnLevel(String bindingName, List<IBinding> bindings, Set<IDimLevel> mostDetailed) throws DataException {
        return OlapExpressionUtil.getAggregateOnLevel(OlapExpressionUtil.getBinding(bindingName, bindings), bindings, mostDetailed);
    }

    public static Set<IDimLevel> getAggregateOnLevel(IBaseExpression expr, List<IBinding> bindings, Set<IDimLevel> mostDetailed) throws DataException {
        HashSet<String> visited = new HashSet<String>();
        HashSet<IDimLevel> valid = new HashSet<IDimLevel>();
        try {
            OlapExpressionUtil.getBindings(visited, valid, expr, bindings, mostDetailed);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        return valid;
    }

    private static void getBindings(Set<String> visited, Set<IDimLevel> aggOn, IBaseExpression expr, List<IBinding> bindings, Set<IDimLevel> mostDetailed) throws DataException, CoreException {
        if (expr == null) {
            return;
        }
        List currentVisitBindings = ExpressionCompilerUtil.extractColumnExpression(expr, "data");
        currentVisitBindings.removeAll(visited);
        if (expr instanceof IScriptExpression) {
            aggOn.addAll(ExpressionUtil.getReferencedDimLevel((String)((IScriptExpression)expr).getText()));
            for (String bindingName : currentVisitBindings) {
                OlapExpressionUtil.getBindings(visited, aggOn, OlapExpressionUtil.getBinding(bindingName, bindings), bindings, mostDetailed);
            }
        } else if (expr instanceof IConditionalExpression) {
            IConditionalExpression cond = (IConditionalExpression)expr;
            OlapExpressionUtil.getBindings(visited, aggOn, cond.getExpression(), bindings, mostDetailed);
            OlapExpressionUtil.getBindings(visited, aggOn, cond.getOperand1(), bindings, mostDetailed);
            OlapExpressionUtil.getBindings(visited, aggOn, cond.getOperand2(), bindings, mostDetailed);
        }
    }

    private static void getBindings(Set<String> visited, Set<IDimLevel> aggOn, IBinding binding, List<IBinding> bindings, Set<IDimLevel> mostDetailed) throws DataException, CoreException {
        List result;
        if (binding == null || visited.contains(binding.getBindingName())) {
            return;
        }
        if (!binding.getAggregatOns().isEmpty()) {
            for (String expr : binding.getAggregatOns()) {
                aggOn.addAll(ExpressionUtil.getReferencedDimLevel((String)expr));
            }
            return;
        }
        List currentVisitBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data");
        currentVisitBindings.removeAll(visited);
        String text = ((IScriptExpression)binding.getExpression()).getText();
        aggOn.addAll(ExpressionUtil.getReferencedDimLevel((String)text));
        if (binding.getAggregatOns().isEmpty() && binding.getAggrFunction() == null && (result = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "measure")) != null && result.size() > 0) {
            aggOn.addAll(mostDetailed);
        }
        visited.add(binding.getBindingName());
        for (String bindingName : currentVisitBindings) {
            OlapExpressionUtil.getBindings(visited, aggOn, OlapExpressionUtil.getBinding(bindingName, bindings), bindings, mostDetailed);
        }
    }

    private static IBinding getBinding(String bindingName, List<IBinding> bindings) throws DataException {
        int i = 0;
        while (i < bindings.size()) {
            if (bindings.get(i).getBindingName().equals(bindingName)) {
                return bindings.get(i);
            }
            ++i;
        }
        return null;
    }

    public static String createMeasureCalculateMemeberName(String originalMeasureName) {
        return "_&$" + originalMeasureName + "$&_";
    }

    public static boolean isReferenceToDimLevel(String expr) {
        if (expr == null) {
            return false;
        }
        return expr.trim().matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E");
    }

    private static String[] getTargetAttribute(String expr, List bindings) throws DataException {
        if (expr == null) {
            return null;
        }
        if (!(expr = expr.trim()).matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E") && !expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            String bindingName = OlapExpressionUtil.getBindingName(expr);
            if (bindingName != null) {
                int i = 0;
                while (i < bindings.size()) {
                    IBinding binding = (IBinding)bindings.get(i);
                    if (bindingName.equals(binding.getBindingName()) && binding.getExpression() instanceof IScriptExpression) {
                        return OlapExpressionUtil.getTargetAttribute(((IScriptExpression)binding.getExpression()).getText(), bindings);
                    }
                    ++i;
                }
            }
            throw new DataException("data.engine.InvalidExpression", expr);
        }
        expr = expr.replaceFirst("\\Qdimension\\E", "");
        String[] result = new String[3];
        String[] candidateResult = expr.split("\\Q\"][\"\\E");
        if (candidateResult.length == 2) {
            result[0] = candidateResult[0].replaceAll("\\Q[\"\\E", "");
            result[1] = candidateResult[1].replaceAll("\\Q\"]\\E", "");
        } else {
            result[0] = candidateResult[0].replaceAll("\\Q[\"\\E", "");
            result[1] = candidateResult[1];
            result[2] = candidateResult[2].replaceAll("\\Q\"]\\E", "");
        }
        return result;
    }

    public static DimLevel getTargetDimLevel(String expr) throws DataException {
        Set s;
        if (expr != null && !OlapExpressionUtil.isComplexDimensionExpr(expr) && (s = OlapExpressionCompiler.getReferencedDimLevel(new ScriptExpression(expr.trim()), Collections.EMPTY_LIST)) != null && s.size() == 1) {
            return (DimLevel)s.iterator().next();
        }
        throw new DataException("data.olap.levelNameNotFound", expr);
    }

    public static String getMeasure(String expr) throws DataException {
        if (expr == null) {
            return null;
        }
        String result = OlapExpressionUtil.findMeasure(expr);
        if (result == null) {
            throw new DataException("data.olap.invalidMeasureRef", expr);
        }
        return result;
    }

    public static String getDimensionName(String expr) throws DataException {
        if (expr == null || expr.trim().length() == 0) {
            return null;
        }
        try {
            List result = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)new ScriptExpression(expr), "dimension");
            if (result != null && result.size() == 1) {
                return (String)result.get(0);
            }
            return null;
        }
        catch (DataException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)((Object)e));
            return null;
        }
    }

    private static String findMeasure(String expr) {
        if (expr == null) {
            return null;
        }
        if (!expr.trim().matches("\\Qmeasure[\"\\E.*\\Q\"]\\E")) {
            return null;
        }
        try {
            List result = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)new ScriptExpression(expr), "measure");
            if (result != null && result.size() == 1) {
                return (String)result.get(0);
            }
            return null;
        }
        catch (DataException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)((Object)e));
            return null;
        }
    }

    public static String getMeasure(IBaseExpression expr) {
        if (expr instanceof IScriptExpression) {
            return OlapExpressionUtil.findMeasure(((IScriptExpression)expr).getText());
        }
        return null;
    }

    public static boolean isDirectRerenrence(IBaseExpression expression, List<IBinding> bindings) throws DataException {
        if (!(expression instanceof IScriptExpression)) {
            return false;
        }
        String expr = ((IScriptExpression)expression).getText();
        if (expr == null) {
            return false;
        }
        if ((expr = expr.trim()).matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E") || expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            return true;
        }
        if (OlapExpressionUtil.findMeasure(expr) != null) {
            return true;
        }
        if (expr.matches("\\Qdata[\"\\E.*\\Q\"]\\E")) {
            String bindingName = OlapExpressionUtil.getBindingName(expr);
            for (IBinding binding : bindings) {
                if (!binding.getBindingName().equals(bindingName)) continue;
                return OlapExpressionUtil.isDirectRerenrence(binding.getExpression(), bindings);
            }
        }
        return false;
    }

    public static IBinding getDirectMeasureBinding(IBinding binding, List<IBinding> bindings) throws DataException {
        if (binding == null) {
            return null;
        }
        if (!(binding.getExpression() instanceof IScriptExpression)) {
            return null;
        }
        String expr = ((IScriptExpression)binding.getExpression()).getText();
        if (expr == null) {
            return null;
        }
        if (expr.trim().matches("\\Qmeasure[\"\\E.*\\Q\"]\\E")) {
            return binding;
        }
        if (expr.trim().matches(".*\\Qdata[\"\\E.*\\Q\"]\\E.*")) {
            String bindingName = OlapExpressionUtil.getBindingName(expr);
            for (IBinding b : bindings) {
                if (!b.getBindingName().equals(bindingName)) continue;
                return OlapExpressionUtil.getDirectMeasureBinding(b, bindings);
            }
        }
        return null;
    }

    public static IBinding getRefMeasureBinding(IBinding binding, List<IBinding> bindings) throws DataException {
        if (binding == null) {
            return null;
        }
        if (!(binding.getExpression() instanceof IScriptExpression)) {
            return null;
        }
        String expr = ((IScriptExpression)binding.getExpression()).getText();
        if (expr == null) {
            return null;
        }
        if (expr.trim().matches(".*\\Qmeasure[\"\\E.*\\Q\"]\\E.*")) {
            return binding;
        }
        if (expr.trim().matches(".*\\Qdata[\"\\E.*\\Q\"]\\E.*")) {
            String bindingName = OlapExpressionUtil.getBindingName(expr);
            for (IBinding b : bindings) {
                if (!b.getBindingName().equals(bindingName)) continue;
                return OlapExpressionUtil.getDirectMeasureBinding(b, bindings);
            }
        }
        return null;
    }

    public static String getBindingName(String expr) {
        if (expr == null) {
            return null;
        }
        if (!expr.trim().matches(".*\\Qdata[\"\\E.*\\Q\"]\\E.*")) {
            return null;
        }
        try {
            List result = ExpressionCompilerUtil.extractColumnExpression((IBaseExpression)new ScriptExpression(expr), "data");
            if (result != null && result.size() == 1) {
                return (String)result.get(0);
            }
            return null;
        }
        catch (DataException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), (Throwable)((Object)e));
            return null;
        }
    }

    public static String getAttributeColumnName(String level, String attribute) {
        return String.valueOf(level) + "/" + attribute;
    }

    public static String getQualifiedLevelName(String dimensionName, String levelName) {
        return String.valueOf(dimensionName) + "/" + levelName;
    }

    public static String getDisplayColumnName(String level) {
        return String.valueOf(level) + "/" + "DisplayName";
    }

    public static CubeAggrDefnOnMeasure[] getAggrDefns(List bindings) throws DataException {
        if (bindings == null || bindings.size() == 0) {
            return new CubeAggrDefnOnMeasure[0];
        }
        ArrayList<CubeAggrDefnOnMeasure> cubeAggrDefns = new ArrayList<CubeAggrDefnOnMeasure>();
        for (IBinding binding : bindings) {
            try {
                if (binding.getAggrFunction() == null && binding.getAggregatOns().size() == 0) continue;
                IAggrFunction af = AggregationManager.getInstance().getAggregation(binding.getAggrFunction());
                if (af != null && af.getType() == 1) {
                    throw new DataException("data.olap.InvalidAggrTypeOnMeasure", af.getName());
                }
                cubeAggrDefns.add(new CubeAggrDefnOnMeasure(binding.getBindingName(), OlapExpressionUtil.getMeasure(binding.getExpression() == null ? null : ((IScriptExpression)binding.getExpression()).getText()), OlapExpressionUtil.convertToDimLevel(binding.getAggregatOns()), binding.getAggrFunction(), binding.getTimeFunction(), OlapExpressionUtil.convertToDimLevelAttribute(binding.getArguments(), bindings), binding.getFilter()));
            }
            catch (DataException ex) {
                throw new DataException("data.engine.aggregation.InvalidBindingExpression", (Throwable)((Object)ex), binding.getBindingName());
            }
        }
        return cubeAggrDefns.toArray(new CubeAggrDefnOnMeasure[0]);
    }

    public static CubeNestAggrDefn[] getAggrDefnsByNestBinding(List<IBinding> bindings, IBinding[] basedBindings) throws DataException {
        if (bindings == null || bindings.size() == 0) {
            return new CubeNestAggrDefn[0];
        }
        ArrayList<IBinding> based = new ArrayList<IBinding>(Arrays.asList(basedBindings));
        ArrayList<CubeNestAggrDefn> cubeAggrDefns = new ArrayList<CubeNestAggrDefn>();
        for (IBinding binding : bindings) {
            try {
                if (binding.getAggrFunction() != null) {
                    if (!CubeQueryDefinitionUtil.isRunnnigAggr(binding.getAggrFunction())) {
                        cubeAggrDefns.add(new CubeNestAggrDefn(binding.getBindingName(), binding.getExpression(), OlapExpressionUtil.convertToDimLevel(binding.getAggregatOns()), binding.getAggrFunction(), OlapExpressionUtil.convertToDimLevelAttribute(binding.getArguments(), based), binding.getFilter()));
                    } else {
                        cubeAggrDefns.add(new CubeRunningNestAggrDefn(binding.getBindingName(), binding.getExpression(), OlapExpressionUtil.convertToDimLevel(binding.getAggregatOns()), binding.getAggrFunction(), null, binding.getFilter(), OlapExpressionUtil.getFullLevelsForRunningAggregation(binding, based), binding.getArguments()));
                    }
                }
            }
            catch (DataException ex) {
                throw new DataException("data.engine.aggregation.InvalidBindingExpression", (Throwable)((Object)ex), binding.getBindingName());
            }
            based.add(binding);
        }
        return cubeAggrDefns.toArray(new CubeNestAggrDefn[0]);
    }

    private static List getFullLevelsForRunningAggregation(IBinding binding, List<IBinding> based) throws DataException {
        List referencedBindings = ExpressionCompilerUtil.extractColumnExpression(binding.getExpression(), "data");
        if (referencedBindings == null || referencedBindings.isEmpty()) {
            throw new DataException("data.engine.aggregation.InvalidBindingExpression", binding.getBindingName());
        }
        String reference = (String)referencedBindings.get(0);
        for (IBinding b : based) {
            if (!b.getBindingName().equals(reference) || !OlapExpressionUtil.isAggregationBinding(b)) continue;
            return OlapExpressionUtil.convertToDimLevel(b.getAggregatOns());
        }
        throw new DataException("data.engine.aggregation.InvalidBindingExpression", binding.getBindingName());
    }

    public static boolean isAggregationBinding(IBinding binding) throws DataException {
        if (binding == null) {
            return false;
        }
        return binding.getAggrFunction() != null;
    }

    public static Set<String> getDerivedMeasureNames(List<IBinding> bindings) throws DataException {
        HashSet<String> directRef = new HashSet<String>();
        HashSet<String> all = new HashSet<String>();
        for (IBinding binding : bindings) {
            if (OlapExpressionUtil.isReferenceToLevelOrMeasure(binding.getExpression(), bindings)) {
                all.add(binding.getBindingName());
            }
            if (!OlapExpressionUtil.isDirectRerenrence(binding.getExpression(), bindings)) continue;
            directRef.add(binding.getBindingName());
        }
        all.removeAll(directRef);
        return all;
    }

    private static boolean isReferenceToLevelOrMeasure(IBaseExpression expression, List<IBinding> bindings) throws DataException {
        String measure = OlapExpressionCompiler.getReferencedScriptObject(expression, "measure");
        if (measure != null) {
            return true;
        }
        String dimension = OlapExpressionCompiler.getReferencedScriptObject(expression, "dimension");
        if (dimension != null) {
            return true;
        }
        List bindingNames = ExpressionCompilerUtil.extractColumnExpression(expression, "data");
        int i = 0;
        while (i < bindingNames.size()) {
            IBinding binding = OlapExpressionUtil.getBinding((String)bindingNames.get(i), bindings);
            if (binding == null) {
                return true;
            }
            if (OlapExpressionUtil.isReferenceToLevelOrMeasure(binding.getExpression(), bindings)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getReferencedDimensionName(IBaseExpression expr, List bindings) throws DataException {
        String result = OlapExpressionCompiler.getReferencedScriptObject(expr, "dimension");
        if (result == null) {
            String bindingName = OlapExpressionCompiler.getReferencedScriptObject(expr, "data");
            if (bindingName == null) {
                bindingName = OlapExpressionCompiler.getReferencedScriptObject(expr, "row");
            }
            if (bindingName == null) {
                return null;
            }
            int i = 0;
            while (i < bindings.size()) {
                IBinding binding = (IBinding)bindings.get(i);
                if (binding.getBindingName().equals(bindingName)) {
                    return OlapExpressionUtil.getReferencedDimensionName(binding.getExpression(), bindings);
                }
                ++i;
            }
        }
        return result;
    }

    private static List convertToDimLevel(List dimLevelExpressions) throws DataException {
        ArrayList<DimLevel> result = new ArrayList<DimLevel>();
        int i = 0;
        while (i < dimLevelExpressions.size()) {
            result.add(OlapExpressionUtil.getTargetDimLevel(dimLevelExpressions.get(i).toString()));
            ++i;
        }
        return result;
    }

    private static List convertToDimLevelAttribute(List dimLevelExpressions, List bindings) throws DataException {
        ArrayList<String[]> result = new ArrayList<String[]>();
        int i = 0;
        while (i < dimLevelExpressions.size()) {
            try {
                String[] attr = OlapExpressionUtil.getTargetAttribute(((IScriptExpression)dimLevelExpressions.get(i)).getText(), bindings);
                result.add(attr);
            }
            catch (DataException dataException) {}
            ++i;
        }
        return result;
    }

    public static boolean isComplexDimensionExpr(String expr) {
        boolean referToAttribute;
        String exprTrimed;
        block5: {
            if (expr == null) {
                return false;
            }
            exprTrimed = expr.trim().replaceAll("\\n", "").replaceAll("\\r", "").replaceAll("\\t", "").replaceAll(" ", "");
            try {
                referToAttribute = OlapExpressionUtil.isReferenceToAttribute(new ScriptExpression(expr), new ArrayList());
                if (!exprTrimed.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E\\S+?") && !exprTrimed.matches("\\S+?\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) break block5;
                return true;
            }
            catch (DataException dataException) {}
        }
        if (referToAttribute) {
            return false;
        }
        return exprTrimed.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E\\S+?") || exprTrimed.matches("\\S+?\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E") || exprTrimed.matches("\\S+?\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E\\S+?");
    }

    public static boolean isReferenceToAttribute(IBaseExpression expr, List bindings) throws DataException {
        Set set = OlapExpressionCompiler.getReferencedDimLevel(expr, bindings);
        if (set.size() != 1) {
            return false;
        }
        for (Object obj : set) {
            DimLevel dimLevel;
            if (!(obj instanceof DimLevel) || (dimLevel = (DimLevel)obj).getAttrName() == null) continue;
            return true;
        }
        return false;
    }

    public static Scriptable createQueryResultsScriptable(IBaseQueryResults outResults) throws DataException {
        if (outResults instanceof ICubeQueryResults) {
            return new JSCubeBindingObject(((ICubeQueryResults)outResults).getCubeCursor());
        }
        if (outResults instanceof IQueryService) {
            try {
                return ((IQueryService)((Object)outResults)).getExecutorHelper().getScriptable();
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        }
        return null;
    }
}

