/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.script;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class OLAPExpressionHandler
extends CompiledExpression {
    private ICompiledScript script;

    OLAPExpressionHandler(ICompiledScript script) {
        assert (script != null);
        this.script = script;
    }

    public Object evaluate(ScriptContext context, Scriptable scope) throws DataException {
        Object temp = null;
        try {
            temp = context.evaluate(this.script);
            temp = JavascriptEvalUtil.convertJavascriptValue((Object)temp);
            if (temp instanceof ScriptableObject) {
                return ((ScriptableObject)temp).getDefaultValue(null);
            }
        }
        catch (EvaluatorException e) {
            throw new DataException(e.details(), e);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
        return temp;
    }

    public int getType() {
        return 0;
    }
}

