/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.util.EmptyExprResultSet;
import org.eclipse.birt.data.engine.impl.document.util.IExprResultSet;
import org.mozilla.javascript.Scriptable;

public class ResultIterator
implements IResultIterator {
    private DataEngineContext context;
    private String queryResultID;
    private String subQueryName;
    private int subQueryIndex;
    private IQueryResults queryResults;
    private int currParentIndex;
    protected IExprResultSet exprResultSet;
    private String tempDir;
    private IBaseQueryDefinition qd;
    protected boolean isFirstNext = true;
    protected boolean hasFirstNext = true;
    protected boolean isSummary = false;

    public ResultIterator(String tempDir, DataEngineContext context, IQueryResults queryResults, String queryResultID, IBaseQueryDefinition qd) throws DataException {
        this(tempDir, context, queryResults, queryResultID, null, -1, qd);
    }

    ResultIterator(String tempDir, DataEngineContext context, IQueryResults queryResults, String queryResultID, String subQueryName, int currParentIndex, IBaseQueryDefinition qd) throws DataException {
        assert (queryResultID != null && context != null && queryResults != null && tempDir != null);
        this.tempDir = tempDir;
        this.context = context;
        this.queryResults = queryResults;
        this.queryResultID = queryResultID;
        this.subQueryName = subQueryName;
        this.currParentIndex = currParentIndex;
        this.qd = qd;
        if (qd instanceof QueryDefinition) {
            this.isSummary = ((QueryDefinition)this.qd).isSummaryQuery();
        }
        this.prepare();
        this.hasFirstNext = this.doNext();
    }

    private void prepare() throws DataException {
        String rootID = QueryResultIDUtil.get1PartID(this.queryResultID);
        String selfID = QueryResultIDUtil.get2PartID(this.queryResultID);
        if (selfID == null) {
            selfID = this.queryResultID;
        }
        RDLoad valueLoader = RDUtil.newLoad(this.tempDir, this.context, new QueryResultInfo(rootID, null, selfID, this.subQueryName, this.currParentIndex));
        int rowIdStartingIndex = 0;
        if (this.subQueryName != null) {
            this.subQueryIndex = valueLoader.getSubQueryIndex(this.currParentIndex);
            rowIdStartingIndex = this.currParentIndex;
        }
        this.exprResultSet = valueLoader.loadExprResultSet(rowIdStartingIndex, this.qd);
    }

    public IQueryResults getQueryResults() {
        return this.queryResults;
    }

    public Scriptable getScope() {
        return null;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        if (this.queryResults.getPreparedQuery() != null && this.queryResults.getPreparedQuery().getReportQueryDefn() != null && this.queryResults.getPreparedQuery().getReportQueryDefn().isSummaryQuery()) {
            return null;
        }
        if (this.exprResultSet instanceof EmptyExprResultSet) {
            return new ResultMetaData(new ResultClass(new ArrayList()));
        }
        return this.queryResults.getResultMetaData();
    }

    public boolean next() throws DataException {
        if (!this.isFirstNext) {
            return this.doNext();
        }
        this.isFirstNext = false;
        return this.hasFirstNext;
    }

    protected boolean doNext() throws DataException {
        return this.exprResultSet.next();
    }

    public Object getValue(String name) throws BirtException {
        Object result = this.exprResultSet.getValue(name);
        if (result != null && result instanceof BirtException) {
            throw (BirtException)((Object)result);
        }
        return result;
    }

    public Boolean getBoolean(String name) throws BirtException {
        return DataTypeUtil.toBoolean((Object)this.getValue(name));
    }

    public Integer getInteger(String name) throws BirtException {
        return DataTypeUtil.toInteger((Object)this.getValue(name));
    }

    public Double getDouble(String name) throws BirtException {
        return DataTypeUtil.toDouble((Object)this.getValue(name));
    }

    public String getString(String name) throws BirtException {
        return DataTypeUtil.toString((Object)this.getValue(name));
    }

    public BigDecimal getBigDecimal(String name) throws BirtException {
        return DataTypeUtil.toBigDecimal((Object)this.getValue(name));
    }

    public Date getDate(String name) throws BirtException {
        return DataTypeUtil.toDate((Object)this.getValue(name));
    }

    public Blob getBlob(String name) throws BirtException {
        return DataTypeUtil.toBlob((Object)this.getValue(name));
    }

    public byte[] getBytes(String name) throws BirtException {
        return DataTypeUtil.toBytes((Object)this.getValue(name));
    }

    public int getRowId() throws BirtException {
        if (this.exprResultSet.isEmpty()) {
            return -1;
        }
        return this.exprResultSet.getCurrentId();
    }

    public int getRowIndex() throws BirtException {
        return this.exprResultSet.getCurrentIndex();
    }

    public void moveTo(int rowIndex) throws BirtException {
        if (rowIndex >= 0) {
            this.isFirstNext = false;
        }
        this.exprResultSet.moveTo(rowIndex);
    }

    public int getStartingGroupLevel() throws BirtException {
        return this.exprResultSet.getStartingGroupLevel();
    }

    public int getEndingGroupLevel() throws BirtException {
        return this.exprResultSet.getEndingGroupLevel();
    }

    public void skipToEnd(int groupLevel) throws BirtException {
        this.exprResultSet.skipToEnd(groupLevel);
    }

    public IResultIterator getSecondaryIterator(ScriptContext context, String subQueryName) throws DataException {
        try {
            Scriptable scope = null;
            if (context != null) {
                scope = ((IDataScriptEngine)context.getScriptEngine("javascript")).getJSScope(context);
            }
            return this.getSecondaryIterator(subQueryName, scope);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    public IResultIterator getSecondaryIterator(String subQueryName, Scriptable scope) throws DataException {
        String queryResultsID = null;
        String baseQueryResultsID = null;
        int rootIdIdex = this.queryResultID.indexOf("/");
        baseQueryResultsID = rootIdIdex > -1 ? this.queryResultID.substring(0, rootIdIdex) : this.queryResultID;
        queryResultsID = this.subQueryName == null ? this.queryResultID : String.valueOf(this.queryResultID) + "/" + this.subQueryName + "/" + this.subQueryIndex;
        QueryResults queryResults = null;
        try {
            queryResults = new QueryResults(this.tempDir, this.context, baseQueryResultsID, queryResultsID, this.getResultMetaData(), subQueryName, this.exprResultSet.getCurrentIndex(), this.queryResults, null);
        }
        catch (Exception e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Subquery");
        }
        try {
            ResultIterator ri = (ResultIterator)queryResults.getResultIterator();
            ri.setSubQueryName(subQueryName);
            return ri;
        }
        catch (BirtException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Subquery");
        }
    }

    void setSubQueryName(String subQueryName) {
        this.subQueryName = subQueryName;
    }

    public void close() throws BirtException {
        this.exprResultSet.close();
    }

    public boolean findGroup(Object[] groupKeyValues) throws BirtException {
        throw new DataException("data.engine.document.notSupportInPresentation");
    }

    public boolean isEmpty() throws BirtException {
        return this.exprResultSet.isEmpty();
    }

    IExprResultSet getExprResultSet() {
        return this.exprResultSet;
    }

    public boolean isBeforeFirst() throws BirtException {
        return !this.isEmpty() && this.getRowIndex() < 0;
    }

    public boolean isFirst() throws BirtException {
        return !this.isEmpty() && this.getRowIndex() == 0;
    }

    public List[] getGroupInfos() throws DataException {
        return this.exprResultSet.getGroupInfos();
    }
}

