/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.data.IColumnBinding;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.ColumnInfo;
import org.eclipse.birt.data.engine.odi.IQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueryExecutorUtil {
    private QueryExecutorUtil() {
    }

    static IQuery.GroupSpec groupDefnToSpec(ScriptContext cx, IGroupDefinition src, String expr, String columnName, int index, int dataType, boolean doSortBeforeGrouping) throws DataException {
        ColumnInfo groupKeyInfo = new ColumnInfo(index, columnName);
        int groupIndex = groupKeyInfo.getColumnIndex();
        String groupKey = groupKeyInfo.getColumnName();
        boolean isComplexExpression = true;
        IQuery.GroupSpec dest = new IQuery.GroupSpec(groupIndex, groupKey);
        dest.setName(src.getName());
        dest.setInterval(src.getInterval());
        dest.setIntervalRange(src.getIntervalRange());
        dest.setIntervalStart(src.getIntervalStart());
        dest.setSortDirection(doSortBeforeGrouping ? src.getSortDirection() : -1);
        dest.setDataType(dataType);
        dest.setFilters(src.getFilters());
        if (src.getSorts().size() != 0) {
            dest.setSorts(src.getSorts());
        }
        dest.setIsComplexExpression(isComplexExpression);
        return dest;
    }

    static int getTempComputedColumnType(int i) {
        int interval = i;
        interval = interval == 5 || interval == 6 || interval == 7 || interval == 8 || interval == 2 || interval == 3 || interval == 1 || interval == 4 || interval == 99 ? 3 : (interval == 100 ? 5 : 0);
        return interval;
    }

    public static ColumnInfo getColInfoFromJSExpr(ScriptContext cx, String expr) {
        int colIndex = -1;
        String colName = null;
        CompiledExpression ce = ExpressionCompilerUtil.compile(expr, cx);
        if (ce instanceof ColumnReferenceExpression) {
            ColumnReferenceExpression cre = (ColumnReferenceExpression)ce;
            colIndex = cre.getColumnindex();
            colName = cre.getColumnName();
        }
        return new ColumnInfo(colIndex, colName);
    }

    static boolean isAggrFilter(IFilterDefinition filter, Map<String, IBinding> bindings) throws DataException {
        assert (filter != null);
        return QueryExecutorUtil.isAggrExpr(filter.getExpression(), bindings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAggrExpr(IBaseExpression expr, Map<String, IBinding> bindings) throws DataException {
        try {
            Set<String> nameSet = QueryExecutorUtil.getBindingNamesFromExpr(expr);
            Iterator<String> it = nameSet.iterator();
            while (true) {
                if (!it.hasNext()) {
                    return false;
                }
                String key = it.next();
                IBinding binding = bindings.get(key);
                if (binding == null) continue;
                HashMap<String, IBinding> newBindingMap = new HashMap<String, IBinding>(bindings);
                newBindingMap.remove(key);
                if (binding.getAggrFunction() != null || QueryExecutorUtil.isAggrExpr(binding.getExpression(), newBindingMap)) break;
            }
            return true;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidFilterExpression(IBaseExpression expr, Map<String, IBinding> bindings, ScriptContext context) throws DataException {
        try {
            if (!ExpressionCompilerUtil.isValidExpressionInQueryFilter(expr, context)) {
                return false;
            }
            Set<String> nameSet = QueryExecutorUtil.getBindingNamesFromExpr(expr);
            Iterator<String> it = nameSet.iterator();
            while (true) {
                if (!it.hasNext()) {
                    return true;
                }
                String key = it.next();
                IBinding binding = bindings.get(key);
                if (binding == null) continue;
                if (binding.getAggrFunction() == null && !ExpressionCompilerUtil.isValidExpressionInQueryFilter(binding.getExpression(), context)) {
                    return false;
                }
                HashMap<String, IBinding> newBindingMap = new HashMap<String, IBinding>(bindings);
                newBindingMap.remove(key);
                if (!QueryExecutorUtil.isValidFilterExpression(binding.getExpression(), bindings, context)) break;
            }
            return false;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private static Set<String> getBindingNamesFromExpr(IBaseExpression expr) throws DataException {
        if (expr instanceof IConditionalExpression) {
            return QueryExecutorUtil.getBindingNamesFromConditionalExpr((IConditionalExpression)expr);
        }
        if (expr instanceof IScriptExpression) {
            return QueryExecutorUtil.getBindingNamesFromScriptExpr((IScriptExpression)expr);
        }
        return new HashSet<String>();
    }

    private static Set<String> getBindingNamesFromConditionalExpr(IConditionalExpression expr) throws DataException {
        Set<String> nameFromExpr = QueryExecutorUtil.getBindingNamesFromScriptExpr(expr.getExpression());
        Set<String> nameFromOp1 = QueryExecutorUtil.getBindingNamesFromExpr(expr.getOperand1());
        Set<String> nameFromOp2 = QueryExecutorUtil.getBindingNamesFromExpr(expr.getOperand2());
        HashSet<String> result = new HashSet<String>();
        result.addAll(nameFromExpr);
        result.addAll(nameFromOp1);
        result.addAll(nameFromOp2);
        return result;
    }

    private static Set<String> getBindingNamesFromScriptExpr(IScriptExpression expr) throws DataException {
        if ("constant".equals(expr.getScriptId())) {
            return Collections.EMPTY_SET;
        }
        try {
            List referedList = ExpressionUtil.extractColumnExpressions((String)expr.getText());
            HashSet<String> newList = new HashSet<String>();
            int j = 0;
            while (j < referedList.size()) {
                IColumnBinding binding = (IColumnBinding)referedList.get(j);
                String name = binding.getResultSetColumnName();
                newList.add(name);
                ++j;
            }
            return newList;
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

