/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IPushedDownExpression;
import org.eclipse.birt.data.engine.impl.StringTable;
import org.eclipse.birt.data.engine.impl.index.DataSetInMemoryStringIndex;
import org.eclipse.birt.data.engine.impl.index.IIndexSerializer;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetUtil {
    public static int writeResultObject(DataOutputStream dos, IResultObject resultObject, int count, Set nameSet, Map<String, StringTable> stringTableMap, Map<String, IIndexSerializer> index, int rowIndex, int version) throws DataException, IOException {
        if (resultObject.getResultClass() == null) {
            return 0;
        }
        ByteArrayOutputStream tempBaos = new ByteArrayOutputStream();
        BufferedOutputStream tempBos = new BufferedOutputStream(tempBaos);
        DataOutputStream tempDos = new DataOutputStream(tempBos);
        int i = 1;
        while (i <= count) {
            if (nameSet != null && (nameSet.contains(resultObject.getResultClass().getFieldName(i)) || nameSet.contains(resultObject.getResultClass().getFieldAlias(i)))) {
                IIndexSerializer currIndex = index.get(resultObject.getResultClass().getFieldName(i));
                Object candidate = resultObject.getFieldValue(i);
                if (currIndex != null) {
                    currIndex.put(candidate, rowIndex);
                }
                StringTable table = null;
                if (stringTableMap != null) {
                    table = stringTableMap.get(resultObject.getResultClass().getFieldName(i));
                }
                if (table != null) {
                    int stringIndex = table.getIndex((String)resultObject.getFieldValue(i));
                    IOUtil.writeInt((OutputStream)tempDos, (int)stringIndex);
                } else if (version > 200) {
                    ResultObjectUtil.writeObject(tempDos, resultObject.getFieldValue(i), resultObject.getResultClass().getFieldValueClass(i), version);
                } else {
                    IOUtil.writeObject((DataOutputStream)tempDos, (Object)resultObject.getFieldValue(i));
                }
            }
            ++i;
        }
        tempDos.flush();
        tempBos.flush();
        tempBaos.flush();
        byte[] bytes = tempBaos.toByteArray();
        int rowBytes = bytes.length;
        IOUtil.writeRawBytes((DataOutputStream)dos, (byte[])bytes);
        tempBaos = null;
        tempBos = null;
        tempDos = null;
        return rowBytes;
    }

    public static IResultObject readResultObject(DataInputStream dis, IResultClass rsMeta, int count, Map<String, StringTable> stringTableMap, Map<String, DataSetInMemoryStringIndex> index, int version) throws DataException {
        int i = 0;
        try {
            Object[] obs = new Object[rsMeta.getFieldCount()];
            i = 0;
            while (i < count) {
                if (rsMeta.isIndexColumn(i + 1) && index.containsKey(rsMeta.getFieldName(i + 1))) {
                    obs[i] = IOUtil.readObject((DataInputStream)dis, (ClassLoader)DataEngineSession.getCurrentClassLoader());
                    obs[i] = index.get(rsMeta.getFieldName(i + 1)).getKeyValue(obs[i]);
                } else if (rsMeta.getFieldMetaData(i + 1).getDataType() == String.class && rsMeta.isCompressedColumn(i + 1)) {
                    StringTable stringTable = null;
                    if (stringTableMap != null) {
                        stringTable = stringTableMap.get(rsMeta.getFieldName(i + 1));
                    }
                    obs[i] = stringTable != null ? stringTable.getStringValue(IOUtil.readInt((InputStream)dis)) : (version > 200 ? ResultObjectUtil.readObject(dis, rsMeta.getFieldValueClass(i + 1), DataEngineSession.getCurrentClassLoader(), version) : IOUtil.readObject((DataInputStream)dis, (ClassLoader)DataEngineSession.getCurrentClassLoader()));
                } else {
                    obs[i] = version > 200 ? ResultObjectUtil.readObject(dis, rsMeta.getFieldValueClass(i + 1), DataEngineSession.getCurrentClassLoader(), version) : IOUtil.readObject((DataInputStream)dis, (ClassLoader)DataEngineSession.getCurrentClassLoader());
                }
                ++i;
            }
            return new ResultObject(rsMeta, obs);
        }
        catch (IOException e) {
            Throwable t = e.getCause();
            if (t instanceof ClassNotFoundException) {
                throw new DataException("data.engine.FailedLoadClass", (Throwable)e, new String[]{t.getMessage(), rsMeta.getFieldNativeTypeName(i + 1), rsMeta.getFieldName(i + 1)});
            }
            throw new DataException("data.engine.FailedLoadColumnValue", (Throwable)e, new String[]{rsMeta.getFieldNativeTypeName(i + 1), rsMeta.getFieldName(i + 1)});
        }
    }

    public static Set getRsColumnRequestMap(List<IBinding> cacheRequestMap) throws DataException {
        HashSet resultSetNameSet = new HashSet();
        if (cacheRequestMap != null) {
            Iterator<IBinding> iter = cacheRequestMap.iterator();
            List dataSetColumnList = null;
            while (iter.hasNext()) {
                IBinding binding = iter.next();
                dataSetColumnList = null;
                if (binding != null) {
                    if (binding.getExpression() != null) {
                        dataSetColumnList = ExpressionCompilerUtil.extractDataSetColumnExpression(binding.getExpression());
                        if (binding.getExpression() instanceof IPushedDownExpression) {
                            dataSetColumnList.addAll(ExpressionCompilerUtil.extractDataSetColumnExpression(((IPushedDownExpression)((Object)binding.getExpression())).getOriginalExpression()));
                        }
                    } else {
                        dataSetColumnList = ExpressionCompilerUtil.extractDataSetColumnExpression(ResultSetUtil.getArgumentExpression(binding));
                    }
                }
                if (dataSetColumnList == null) continue;
                resultSetNameSet.addAll(dataSetColumnList);
            }
        }
        return resultSetNameSet;
    }

    private static IBaseExpression getArgumentExpression(IBinding binding) throws DataException {
        List arguments = binding.getArguments();
        if (arguments != null && arguments.size() > 0) {
            return (IBaseExpression)arguments.get(0);
        }
        return null;
    }
}

