/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.propertypages;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.ui.Mnemonics;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemTableViewProvider;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;

public class SystemCachePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Button _clearButton;
    private Button _limitCacheCheckbox;
    private Text _maxCacheSize;
    private Label maxCacheSizeLabel;
    static /* synthetic */ Class class$0;

    public SystemCachePreferencePage() {
        this.setPreferenceStore(RSEUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.rse.ui.fchp0000");
    }

    protected Control createContents(Composite gparent) {
        Composite parent = SystemWidgetHelpers.createComposite((Composite)gparent, (int)2);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(32));
        this._limitCacheCheckbox = SystemWidgetHelpers.createCheckBox((Composite)parent, (String)FileResources.RESID_PREF_CACHE_LIMIT_CACHE_SIZE_LABEL, (Listener)this);
        this._limitCacheCheckbox.setToolTipText(FileResources.RESID_PREF_CACHE_LIMIT_CACHE_SIZE_TOOLTIP);
        this._limitCacheCheckbox.setLayoutData((Object)new GridData(1, 1, true, false));
        ((GridData)this._limitCacheCheckbox.getLayoutData()).horizontalSpan = 2;
        this.maxCacheSizeLabel = new Label(parent, 0);
        this.maxCacheSizeLabel.setText(FileResources.RESID_PREF_CACHE_MAX_CACHE_SIZE_LABEL);
        this.maxCacheSizeLabel.setToolTipText(FileResources.RESID_PREF_CACHE_MAX_CACHE_SIZE_TOOLTIP);
        this.maxCacheSizeLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this._maxCacheSize = new Text(parent, 2048);
        GridData gd = new GridData(1, 0x1000000, false, false);
        gd.widthHint = 75;
        this._maxCacheSize.setLayoutData((Object)gd);
        this._maxCacheSize.setTextLimit(5);
        this._maxCacheSize.setToolTipText(FileResources.RESID_PREF_CACHE_MAX_CACHE_SIZE_TOOLTIP);
        this._maxCacheSize.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                int loop = 0;
                while (loop < e.text.length()) {
                    if (!Character.isDigit(e.text.charAt(loop))) {
                        e.doit = false;
                    }
                    ++loop;
                }
            }
        });
        this._clearButton = SystemWidgetHelpers.createPushButton((Composite)parent, (String)FileResources.RESID_PREF_CACHE_CLEAR, (Listener)this);
        this._clearButton.setLayoutData((Object)new GridData(1, 1, false, false));
        ((GridData)this._clearButton.getLayoutData()).horizontalSpan = 2;
        this._clearButton.setToolTipText(FileResources.RESID_PREF_CACHE_CLEAR_TOOLTIP);
        Text warning = new Text(parent, 8);
        warning.setBackground(parent.getBackground());
        warning.setText(FileResources.RESID_PREF_CACHE_CLEAR_WARNING_DESCRIPTION);
        warning.setLayoutData((Object)new GridData(1, 1, false, false));
        ((GridData)warning.getLayoutData()).horizontalSpan = 2;
        new Mnemonics().setOnPreferencePage(true).setMnemonics(parent);
        this.initControls();
        return parent;
    }

    private void initControls() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean enableMaxSize = store.getBoolean("org.eclipse.rse.subsystems.files.core.preferences.limit.cache");
        this._maxCacheSize.setEnabled(enableMaxSize);
        String maxCacheSizeStr = store.getString("org.eclipse.rse.subsystems.files.core.preferences.max.cache.size");
        if (maxCacheSizeStr == null || maxCacheSizeStr.equals("")) {
            maxCacheSizeStr = "512";
        }
        this._maxCacheSize.setText(maxCacheSizeStr);
        this._limitCacheCheckbox.setSelection(enableMaxSize);
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        boolean enableMaxSize = store.getDefaultBoolean("org.eclipse.rse.subsystems.files.core.preferences.limit.cache");
        this._limitCacheCheckbox.setSelection(enableMaxSize);
        this.maxCacheSizeLabel.setEnabled(enableMaxSize);
        this._maxCacheSize.setEnabled(enableMaxSize);
        this._maxCacheSize.setText(store.getDefaultString("org.eclipse.rse.subsystems.files.core.preferences.max.cache.size"));
    }

    public static void initDefaults(IPreferenceStore store) {
    }

    public boolean performOk() {
        IPreferenceStore store = RSEUIPlugin.getDefault().getPreferenceStore();
        String size = this._maxCacheSize.getText();
        if (size == null || size.trim().equals("")) {
            size = "512";
        }
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.max.cache.size", size);
        store.setValue("org.eclipse.rse.subsystems.files.core.preferences.limit.cache", this._limitCacheCheckbox.getSelection());
        return super.performOk();
    }

    protected IRunnableContext getRunnableContext(Shell shell) {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistryUI().getRunnableContext();
        if (irc != null) {
            return irc;
        }
        IWorkbenchWindow win = SystemBasePlugin.getActiveWorkbenchWindow();
        if (win != null) {
            Shell winShell = SystemBasePlugin.getActiveWorkbenchShell();
            if (winShell != null && winShell.isVisible() && !winShell.isDisposed()) {
                shell = winShell;
                return win;
            }
            win = null;
        }
        return new ProgressMonitorDialog(shell);
    }

    public void handleEvent(Event e) {
        if (e.widget == this._clearButton) {
            if (this.checkDirtyEditors()) {
                IRunnableContext runnableContext = this.getRunnableContext(SystemBasePlugin.getActiveWorkbenchShell());
                try {
                    runnableContext.run(false, true, (IRunnableWithProgress)new ClearTempFilesRunnable());
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (e.widget == this._limitCacheCheckbox) {
            this._maxCacheSize.setEnabled(this._limitCacheCheckbox.getSelection());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean getDirtyReplicas(IContainer parent, List dirtyReplicas) {
        try {
            IResource[] children = parent.members();
            int i = 0;
            while (true) {
                block12: {
                    IResource child;
                    block11: {
                        SystemIFileProperties properties;
                        block13: {
                            if (i >= children.length) {
                                return true;
                            }
                            child = children[i];
                            if (!(child instanceof IFile)) break block11;
                            properties = new SystemIFileProperties(child);
                            if (!properties.getDirty()) break block12;
                            if (properties.getRemoteFileObject() == null) break block13;
                            ISystemEditableRemoteObject editable = (ISystemEditableRemoteObject)properties.getRemoteFileObject();
                            dirtyReplicas.add(editable);
                            break block12;
                        }
                        if (properties.getDownloadFileTimeStamp() == child.getLocation().toFile().lastModified()) break block12;
                        String ssString = properties.getRemoteFileSubSystem();
                        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                        ISubSystem subsystem = registry.getSubSystem(ssString);
                        if (subsystem != null) {
                            String path = properties.getRemoteFilePath();
                            try {
                                IAdaptable remoteFile = (IAdaptable)subsystem.getObjectWithAbsoluteName(path);
                                if (remoteFile == null) return false;
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                ISystemRemoteElementAdapter adapter = (ISystemRemoteElementAdapter)remoteFile.getAdapter((Class)clazz);
                                ISystemEditableRemoteObject editable = adapter.getEditableRemoteObject((Object)remoteFile);
                                editable.openEditor();
                                properties.setRemoteFileObject((Object)editable);
                                dirtyReplicas.add(editable);
                            }
                            catch (Exception exception) {
                                return false;
                            }
                        }
                        break block12;
                    }
                    if (child instanceof IContainer && !this.getDirtyReplicas((IContainer)child, dirtyReplicas)) {
                        return false;
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean getDirtyReplicas(List results) {
        SystemRemoteEditManager mgr = SystemRemoteEditManager.getInstance();
        IProject tempFilesProject = mgr.getRemoteEditProject();
        if (!this.getDirtyReplicas((IContainer)tempFilesProject, results)) {
            return false;
        }
        return this.getDirtyEditors(results);
    }

    protected boolean getDirtyEditors(List results) {
        SystemRemoteEditManager editMgr = SystemRemoteEditManager.getInstance();
        if (!editMgr.doesRemoteEditProjectExist()) {
            return false;
        }
        IProject tempFilesProject = editMgr.getRemoteEditProject();
        IWorkbenchWindow activeWindow = SystemBasePlugin.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWindow.getActivePage();
        IEditorReference[] activeReferences = activePage.getEditorReferences();
        int k = 0;
        while (k < activeReferences.length) {
            block11: {
                SystemIFileProperties properties;
                IFile file;
                IEditorInput editorInput;
                IEditorPart part = activeReferences[k].getEditor(false);
                if (part != null && (editorInput = part.getEditorInput()) instanceof IFileEditorInput && (file = ((IFileEditorInput)editorInput).getFile()).getProject() == tempFilesProject && part.isDirty() && !(properties = new SystemIFileProperties((IResource)file)).getDirty()) {
                    if (properties.getRemoteFileObject() != null) {
                        ISystemEditableRemoteObject editable = (ISystemEditableRemoteObject)properties.getRemoteFileObject();
                        results.add(editable);
                    } else {
                        String ssString = properties.getRemoteFileSubSystem();
                        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
                        ISubSystem subsystem = registry.getSubSystem(ssString);
                        if (subsystem != null) {
                            String path = properties.getRemoteFilePath();
                            try {
                                IAdaptable remoteFile = (IAdaptable)subsystem.getObjectWithAbsoluteName(path);
                                if (remoteFile == null) break block11;
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                ISystemRemoteElementAdapter adapter = (ISystemRemoteElementAdapter)remoteFile.getAdapter((Class)clazz);
                                ISystemEditableRemoteObject editable = adapter.getEditableRemoteObject((Object)remoteFile);
                                editable.openEditor();
                                properties.setRemoteFileObject((Object)editable);
                                results.add(editable);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
            }
            ++k;
        }
        return true;
    }

    protected ISystemEditableRemoteObject getEditableFor(IAdaptable selected) {
        ISystemRemoteElementAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (ISystemRemoteElementAdapter)selected.getAdapter((Class)clazz)).canEdit((Object)selected)) {
            ISystemEditableRemoteObject editable = adapter.getEditableRemoteObject((Object)selected);
            try {
                editable.setLocalResourceProperties();
            }
            catch (Exception exception) {}
            return editable;
        }
        return null;
    }

    protected boolean checkDirtyEditors() {
        SystemRemoteEditManager mgr = SystemRemoteEditManager.getInstance();
        if (!mgr.doesRemoteEditProjectExist()) {
            return true;
        }
        ArrayList dirtyEditors = new ArrayList();
        if (!this.getDirtyReplicas(dirtyEditors)) {
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF6102", 4, FileResources.MSG_CACHE_UNABLE_TO_SYNCH);
            SystemMessageDialog dlg = new SystemMessageDialog(this.getShell(), (SystemMessage)msg);
            dlg.open();
            return false;
        }
        if (dirtyEditors.size() > 0) {
            AdaptableList input = new AdaptableList();
            int i = 0;
            while (i < dirtyEditors.size()) {
                ISystemEditableRemoteObject rmtObj = (ISystemEditableRemoteObject)dirtyEditors.get(i);
                input.add(rmtObj.getRemoteObject());
                ++i;
            }
            WorkbenchContentProvider cprovider = new WorkbenchContentProvider();
            SystemTableViewProvider lprovider = new SystemTableViewProvider();
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEF6101", 4, FileResources.MSG_CACHE_UPLOAD_BEFORE_DELETE);
            ListSelectionDialog dlg = new ListSelectionDialog(this.getShell(), (Object)input, (IStructuredContentProvider)cprovider, (ILabelProvider)lprovider, msg.getLevelOneText());
            dlg.setInitialSelections(input.getChildren());
            dlg.setTitle(FileResources.EditorManager_saveResourcesTitle);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            Object[] filesToSave = dlg.getResult();
            int s = 0;
            while (s < filesToSave.length) {
                IAdaptable rmtObj = (IAdaptable)filesToSave[s];
                ISystemEditableRemoteObject editable = this.getEditableFor(rmtObj);
                if (!editable.doImmediateSaveAndUpload()) {
                    return false;
                }
                ++s;
            }
        }
        return true;
    }

    private class ClearTempFilesRunnable
    implements IRunnableWithProgress {
        private ClearTempFilesRunnable() {
        }

        private boolean isDeletable(IResource member) {
            String name;
            return !(member instanceof IFile) || !(name = member.getName()).startsWith(".");
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IProgressMonitor monitor) {
            SystemRemoteEditManager mgr = SystemRemoteEditManager.getInstance();
            if (!mgr.doesRemoteEditProjectExist()) {
                return;
            }
            IProject tempFiles = mgr.getRemoteEditProject();
            if (tempFiles == null) return;
            try {
                try {
                    IResource[] members = tempFiles.members();
                    if (members != null) {
                        int i = 0;
                        while (i < members.length) {
                            IResource member = members[i];
                            if (this.isDeletable(member)) {
                                member.delete(true, monitor);
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                mgr.getRemoteEditProject();
                throw throwable;
            }
            {
                Object var7_9 = null;
                mgr.getRemoteEditProject();
            }
        }
    }
}

