/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.model;

import com.ibm.icu.text.MessageFormat;
import com.ibm.icu.text.NumberFormat;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIAddressLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILineLocation;
import org.eclipse.cdt.debug.core.cdi.ICDILocator;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEventListener;
import org.eclipse.cdt.debug.core.cdi.model.ICDIArgumentDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIDisposable;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExecuteMoveInstructionPointer;
import org.eclipse.cdt.debug.core.cdi.model.ICDIExpression;
import org.eclipse.cdt.debug.core.cdi.model.ICDILocalVariableDescriptor;
import org.eclipse.cdt.debug.core.cdi.model.ICDIStackFrame;
import org.eclipse.cdt.debug.core.cdi.model.ICDIThread;
import org.eclipse.cdt.debug.core.cdi.model.ICDIVariableDescriptor;
import org.eclipse.cdt.debug.core.model.ICGlobalVariable;
import org.eclipse.cdt.debug.core.model.ICStackFrame;
import org.eclipse.cdt.debug.core.model.IMoveToAddress;
import org.eclipse.cdt.debug.core.model.IMoveToLine;
import org.eclipse.cdt.debug.core.model.IRestart;
import org.eclipse.cdt.debug.core.model.IResumeAtAddress;
import org.eclipse.cdt.debug.core.model.IResumeAtLine;
import org.eclipse.cdt.debug.core.model.IResumeWithoutSignal;
import org.eclipse.cdt.debug.core.model.IRunToAddress;
import org.eclipse.cdt.debug.core.model.IRunToLine;
import org.eclipse.cdt.debug.core.sourcelookup.ICSourceLocator;
import org.eclipse.cdt.debug.internal.core.CGlobalVariableManager;
import org.eclipse.cdt.debug.internal.core.model.AbstractCVariable;
import org.eclipse.cdt.debug.internal.core.model.CDebugElement;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.cdt.debug.internal.core.model.CExpression;
import org.eclipse.cdt.debug.internal.core.model.CThread;
import org.eclipse.cdt.debug.internal.core.model.CVariable;
import org.eclipse.cdt.debug.internal.core.model.CVariableFactory;
import org.eclipse.cdt.debug.internal.core.model.CoreModelMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

public class CStackFrame
extends CDebugElement
implements ICStackFrame,
IRestart,
IResumeWithoutSignal,
IMoveToAddress,
IMoveToLine,
ICDIEventListener {
    private ICDIStackFrame fCDIStackFrame;
    private ICDIStackFrame fLastCDIStackFrame;
    private CThread fThread;
    private List fVariables;
    private boolean fRefreshVariables = true;
    private List fExpressions;
    private boolean fIsDisposed = false;

    public CStackFrame(CThread thread, ICDIStackFrame cdiFrame) {
        super((CDebugTarget)thread.getDebugTarget());
        this.setCDIStackFrame(cdiFrame);
        this.setThread(thread);
        this.getCDISession().getEventManager().addEventListener(this);
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.isDisposed()) {
            return new IVariable[0];
        }
        ICGlobalVariable[] globals = this.getGlobals();
        List vars = this.getVariables0();
        ArrayList<ICGlobalVariable> all = new ArrayList<ICGlobalVariable>(globals.length + vars.size());
        all.addAll(Arrays.asList(globals));
        all.addAll(vars);
        return all.toArray(new IVariable[all.size()]);
    }

    protected synchronized List getVariables0() throws DebugException {
        if (this.isDisposed()) {
            return Collections.EMPTY_LIST;
        }
        CThread thread = (CThread)this.getThread();
        if (thread.isSuspended()) {
            if (this.fVariables == null) {
                List vars = this.getAllCDIVariableObjects();
                this.fVariables = new ArrayList(vars.size());
                Iterator it = vars.iterator();
                while (it.hasNext()) {
                    this.fVariables.add(CVariableFactory.createLocalVariable(this, (ICDIVariableDescriptor)it.next()));
                }
            } else if (this.refreshVariables()) {
                this.updateVariables();
            }
            this.setRefreshVariables(false);
        }
        return this.fVariables != null ? this.fVariables : Collections.EMPTY_LIST;
    }

    protected void updateVariables() throws DebugException {
        List locals = this.getAllCDIVariableObjects();
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            CVariable var = (CVariable)it.next();
            ICDIVariableDescriptor varObject = this.findVariable(locals, var);
            if (varObject != null && !var.isDisposed()) {
                locals.remove(varObject);
                continue;
            }
            var.dispose();
            it.remove();
        }
        Iterator newOnes = locals.iterator();
        while (newOnes.hasNext()) {
            this.fVariables.add(CVariableFactory.createLocalVariable(this, (ICDIVariableDescriptor)newOnes.next()));
        }
    }

    protected void setThread(CThread thread) {
        this.fThread = thread;
    }

    public boolean hasVariables() throws DebugException {
        return this.isDisposed() ? false : this.getVariables0().size() > 0 || this.getGlobals().length > 0;
    }

    public int getLineNumber() throws DebugException {
        if (this.isSuspended()) {
            ISourceLocator locator = ((CDebugTarget)this.getDebugTarget()).getSourceLocator();
            if (locator != null && locator instanceof IAdaptable && ((IAdaptable)locator).getAdapter(ICSourceLocator.class) != null) {
                return ((ICSourceLocator)((IAdaptable)locator).getAdapter(ICSourceLocator.class)).getLineNumber(this);
            }
            ICDIStackFrame cdiFrame = this.getCDIStackFrame();
            if (cdiFrame != null && cdiFrame.getLocator() != null) {
                return cdiFrame.getLocator().getLineNumber();
            }
        }
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        ICDIStackFrame cdiFrame = this.getCDIStackFrame();
        if (cdiFrame == null) {
            return "";
        }
        ICDILocator locator = cdiFrame.getLocator();
        String func = "";
        String file = "";
        String line = "";
        if (locator.getFunction() != null && locator.getFunction().trim().length() > 0) {
            func = String.valueOf(func) + locator.getFunction() + "() ";
        }
        if (locator.getFile() != null && locator.getFile().trim().length() > 0) {
            file = locator.getFile();
            if (locator.getLineNumber() != 0) {
                line = NumberFormat.getInstance().format((Object)new Integer(locator.getLineNumber()));
            }
        } else {
            return func;
        }
        return MessageFormat.format((String)CoreModelMessages.getString("CStackFrame.0"), (Object[])new String[]{func, file, line});
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return this.isDisposed() ? new IRegisterGroup[]{} : ((CDebugTarget)this.getDebugTarget()).getRegisterGroups(this);
    }

    public boolean hasRegisterGroups() throws DebugException {
        return this.isDisposed() ? false : ((CDebugTarget)this.getDebugTarget()).getRegisterGroups(this).length > 0;
    }

    @Override
    public void handleDebugEvents(ICDIEvent[] events) {
    }

    public boolean canStepInto() {
        try {
            return this.exists() && this.getThread().canStepInto();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepOver() {
        try {
            return this.exists() && this.getThread().canStepOver();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
            return false;
        }
    }

    public boolean canStepReturn() {
        block4: {
            if (this.exists()) break block4;
            return false;
        }
        try {
            List frames = ((CThread)this.getThread()).computeStackFrames();
            if (frames != null && !frames.isEmpty()) {
                boolean bottomFrame = this.equals(frames.get(frames.size() - 1));
                return !bottomFrame && this.getThread().canStepReturn();
            }
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return false;
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        if (this.canStepInto()) {
            this.getThread().stepInto();
        }
    }

    public void stepOver() throws DebugException {
        if (this.canStepOver()) {
            this.getThread().stepOver();
        }
    }

    public void stepReturn() throws DebugException {
        if (this.canStepReturn()) {
            this.getThread().stepReturn();
        }
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        boolean exists = false;
        try {
            exists = this.exists();
        }
        catch (DebugException e) {
            this.logError((Exception)((Object)e));
        }
        return exists && this.getThread().canTerminate() || this.getDebugTarget().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        if (this.getThread().canTerminate()) {
            this.getThread().terminate();
        } else {
            this.getDebugTarget().terminate();
        }
    }

    protected ICDIStackFrame getCDIStackFrame() {
        return this.fCDIStackFrame;
    }

    protected void setCDIStackFrame(ICDIStackFrame frame) {
        this.fLastCDIStackFrame = frame != null ? frame : this.fCDIStackFrame;
        this.fCDIStackFrame = frame;
        this.setRefreshVariables(true);
    }

    protected ICDIStackFrame getLastCDIStackFrame() {
        return this.fLastCDIStackFrame;
    }

    protected static boolean equalFrame(ICDIStackFrame frameOne, ICDIStackFrame frameTwo) {
        if (frameOne == null || frameTwo == null) {
            return false;
        }
        ICDILocator loc1 = frameOne.getLocator();
        ICDILocator loc2 = frameTwo.getLocator();
        if (loc1 == null || loc2 == null) {
            return false;
        }
        if (loc1.getFile() != null && loc1.getFile().length() > 0 && loc2.getFile() != null && loc2.getFile().length() > 0 && loc1.getFile().equals(loc2.getFile()) && loc1.getFunction() != null && loc1.getFunction().length() > 0 && loc2.getFunction() != null && loc2.getFunction().length() > 0 && loc1.getFunction().equals(loc2.getFunction())) {
            return true;
        }
        if (!(loc1.getFile() != null && loc1.getFile().length() >= 1 || loc2.getFile() != null && loc2.getFile().length() >= 1 || loc1.getFunction() == null || loc1.getFunction().length() <= 0 || loc2.getFunction() == null || loc2.getFunction().length() <= 0 || !loc1.getFunction().equals(loc2.getFunction()))) {
            return true;
        }
        return !(loc1.getFile() != null && loc1.getFile().length() >= 1 || loc2.getFile() != null && loc2.getFile().length() >= 1 || loc1.getFunction() != null && loc1.getFunction().length() >= 1 || loc2.getFunction() != null && loc2.getFunction().length() >= 1 || loc1.getAddress() != loc2.getAddress());
    }

    protected boolean exists() throws DebugException {
        return ((CThread)this.getThread()).computeStackFrames().indexOf(this) != -1;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IRunToLine.class) {
            return this;
        }
        if (adapter == IRunToAddress.class) {
            return this;
        }
        if (adapter == IResumeAtLine.class) {
            return this;
        }
        if (adapter == IResumeAtAddress.class) {
            return this;
        }
        if (adapter == IMoveToLine.class) {
            return this;
        }
        if (adapter == IMoveToAddress.class) {
            return this;
        }
        if (adapter == CStackFrame.class) {
            return this;
        }
        if (adapter == ICStackFrame.class) {
            return this;
        }
        if (adapter == IStackFrame.class) {
            return this;
        }
        if (adapter == ICDIStackFrame.class) {
            return this.getCDIStackFrame();
        }
        if (adapter == IMemoryBlockRetrieval.class) {
            return this.getDebugTarget().getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    protected void dispose() {
        this.setDisposed(true);
        this.getCDISession().getEventManager().removeEventListener(this);
        this.disposeAllVariables();
        this.disposeExpressions();
        ICDIStackFrame cdiFrame = this.getCDIStackFrame();
        this.setCDIStackFrame(null);
        if (cdiFrame instanceof ICDIDisposable) {
            ((ICDIDisposable)((Object)cdiFrame)).dispose();
        }
    }

    protected List getCDILocalVariableObjects() throws DebugException {
        ArrayList<ICDILocalVariableDescriptor> list = new ArrayList<ICDILocalVariableDescriptor>();
        try {
            ICDIStackFrame cdiFrame = this.getCDIStackFrame();
            if (cdiFrame != null) {
                list.addAll(Arrays.asList(cdiFrame.getLocalVariableDescriptors()));
            }
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return list;
    }

    protected List getCDIArgumentObjects() throws DebugException {
        ArrayList<ICDIArgumentDescriptor> list = new ArrayList<ICDIArgumentDescriptor>();
        try {
            ICDIStackFrame cdiFrame = this.getCDIStackFrame();
            if (cdiFrame != null) {
                list.addAll(Arrays.asList(cdiFrame.getArgumentDescriptors()));
            }
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return list;
    }

    protected List getAllCDIVariableObjects() throws DebugException {
        ArrayList list = new ArrayList();
        list.addAll(this.getCDIArgumentObjects());
        list.addAll(this.getCDILocalVariableObjects());
        return list;
    }

    protected boolean isTopStackFrame() throws DebugException {
        IStackFrame tos = this.getThread().getTopStackFrame();
        return tos != null && tos.equals(this);
    }

    protected void disposeAllVariables() {
        if (this.fVariables == null) {
            return;
        }
        Iterator it = this.fVariables.iterator();
        while (it.hasNext()) {
            ((CVariable)it.next()).dispose();
        }
        this.fVariables.clear();
        this.fVariables = null;
    }

    protected void disposeExpressions() {
        if (this.fExpressions != null) {
            Iterator it = this.fExpressions.iterator();
            while (it.hasNext()) {
                ((CExpression)it.next()).dispose();
            }
            this.fExpressions.clear();
        }
        this.fExpressions = null;
    }

    @Override
    public IAddress getAddress() {
        IAddressFactory factory = ((CDebugTarget)this.getDebugTarget()).getAddressFactory();
        ICDIStackFrame cdiFrame = this.getCDIStackFrame();
        return cdiFrame != null ? factory.createAddress(cdiFrame.getLocator().getAddress()) : null;
    }

    @Override
    public String getFile() {
        ICDIStackFrame cdiFrame = this.getCDIStackFrame();
        return cdiFrame != null ? cdiFrame.getLocator().getFile() : "";
    }

    @Override
    public String getFunction() {
        ICDIStackFrame cdiFrame = this.getCDIStackFrame();
        return cdiFrame != null ? cdiFrame.getLocator().getFunction() : "";
    }

    @Override
    public int getLevel() {
        ICDIStackFrame cdiFrame = this.getCDIStackFrame();
        return cdiFrame != null ? cdiFrame.getLevel() : -1;
    }

    @Override
    public int getFrameLineNumber() {
        ICDIStackFrame cdiFrame = this.getCDIStackFrame();
        return cdiFrame != null ? cdiFrame.getLocator().getLineNumber() : -1;
    }

    protected synchronized void preserve() {
        this.preserveVariables();
        this.preserveExpressions();
    }

    private void preserveVariables() {
        if (this.fVariables == null) {
            return;
        }
        for (AbstractCVariable av : this.fVariables) {
            av.preserve();
        }
    }

    private void preserveExpressions() {
        if (this.fExpressions == null) {
            return;
        }
        for (CExpression exp : this.fExpressions) {
            exp.preserve();
        }
    }

    protected ICDIVariableDescriptor findVariable(List list, CVariable var) {
        for (ICDIVariableDescriptor newVarObject : list) {
            if (!var.sameVariable(newVarObject)) continue;
            return newVarObject;
        }
        return null;
    }

    @Override
    public boolean canRestart() {
        return this.getDebugTarget() instanceof IRestart && ((IRestart)this.getDebugTarget()).canRestart();
    }

    @Override
    public void restart() throws DebugException {
        if (this.canRestart()) {
            ((IRestart)this.getDebugTarget()).restart();
        }
    }

    public void setRefreshVariables(boolean refresh) {
        this.fRefreshVariables = refresh;
    }

    private boolean refreshVariables() {
        return this.fRefreshVariables;
    }

    @Override
    public boolean canResumeWithoutSignal() {
        return this.getDebugTarget() instanceof IResumeWithoutSignal && ((IResumeWithoutSignal)this.getDebugTarget()).canResumeWithoutSignal();
    }

    @Override
    public void resumeWithoutSignal() throws DebugException {
        if (this.canResumeWithoutSignal()) {
            ((IResumeWithoutSignal)this.getDebugTarget()).resumeWithoutSignal();
        }
    }

    @Override
    public IValue evaluateExpression(String expressionText) throws DebugException {
        CExpression expression;
        if (!this.isDisposed() && (expression = this.getExpression(expressionText)) != null) {
            return expression.getValue(this);
        }
        return null;
    }

    private ICGlobalVariable[] getGlobals() {
        CGlobalVariableManager gvm = ((CDebugTarget)this.getDebugTarget()).getGlobalVariableManager();
        if (gvm != null) {
            return gvm.getGlobals();
        }
        return new ICGlobalVariable[0];
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (DebugException e) {
            return e.getLocalizedMessage();
        }
    }

    @Override
    public String evaluateExpressionToString(String expression) throws DebugException {
        try {
            ICDIStackFrame cdiFrame = this.getCDIStackFrame();
            if (cdiFrame != null) {
                return this.getCDITarget().evaluateExpressionToString(cdiFrame, expression);
            }
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return null;
    }

    @Override
    public boolean canEvaluate() {
        CDebugTarget target = (CDebugTarget)this.getDebugTarget();
        return target.supportsExpressionEvaluation() && this.isSuspended();
    }

    protected void doStepReturn() throws DebugException {
        try {
            ICDIStackFrame cdiFrame = this.getCDIStackFrame();
            if (cdiFrame != null) {
                cdiFrame.stepReturn();
            }
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), null);
        }
    }

    private synchronized CExpression getExpression(String expressionText) throws DebugException {
        if (this.isDisposed()) {
            return null;
        }
        if (this.fExpressions == null) {
            this.fExpressions = new ArrayList(5);
        }
        CExpression expression2 = null;
        for (CExpression expression2 : this.fExpressions) {
            if (expression2.getExpressionText().compareTo(expressionText) != 0) continue;
            return expression2;
        }
        try {
            ICDIExpression cdiExpression = ((CDebugTarget)this.getDebugTarget()).getCDITarget().createExpression(expressionText);
            expression2 = new CExpression(this, cdiExpression, null);
            this.fExpressions.add(expression2);
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), null);
        }
        return expression2;
    }

    protected boolean isDisposed() {
        return this.fIsDisposed;
    }

    private synchronized void setDisposed(boolean isDisposed) {
        this.fIsDisposed = isDisposed;
    }

    @Override
    public boolean canRunToLine(IFile file, int lineNumber) {
        return ((CThread)this.getThread()).canRunToLine(file, lineNumber);
    }

    @Override
    public void runToLine(IFile file, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(file, lineNumber)) {
            return;
        }
        ((CThread)this.getThread()).runToLine(file, lineNumber, skipBreakpoints);
    }

    @Override
    public boolean canRunToLine(String fileName, int lineNumber) {
        return ((CThread)this.getThread()).canRunToLine(fileName, lineNumber);
    }

    @Override
    public void runToLine(String fileName, int lineNumber, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToLine(fileName, lineNumber)) {
            return;
        }
        ((CThread)this.getThread()).runToLine(fileName, lineNumber, skipBreakpoints);
    }

    @Override
    public boolean canRunToAddress(IAddress address) {
        return this.getThread().canResume();
    }

    @Override
    public void runToAddress(IAddress address, boolean skipBreakpoints) throws DebugException {
        if (!this.canRunToAddress(address)) {
            return;
        }
        if (skipBreakpoints) {
            ((CDebugTarget)this.getDebugTarget()).skipBreakpoints(true);
        }
        ICDIAddressLocation location = this.getCDITarget().createAddressLocation(new BigInteger(address.toString()));
        try {
            this.getCDIThread().stepUntil(location);
        }
        catch (CDIException e) {
            if (skipBreakpoints) {
                ((CDebugTarget)this.getDebugTarget()).skipBreakpoints(false);
            }
            CStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    @Override
    public boolean canResumeAtLine(IFile file, int lineNumber) {
        return this.getThread().canResume();
    }

    @Override
    public void resumeAtLine(IFile file, int lineNumber) throws DebugException {
        if (!this.canResumeAtLine(file, lineNumber)) {
            return;
        }
        this.resumeAtLine(file.getLocation().lastSegment(), lineNumber);
    }

    @Override
    public boolean canResumeAtLine(String fileName, int lineNumber) {
        return this.getThread().canResume();
    }

    @Override
    public void resumeAtLine(String fileName, int lineNumber) throws DebugException {
        if (!this.canResumeAtLine(fileName, lineNumber)) {
            return;
        }
        ICDILineLocation location = this.getCDITarget().createLineLocation(fileName, lineNumber);
        try {
            ICDIThread resumer = this.getCDIThread();
            resumer.resume(location);
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    @Override
    public boolean canResumeAtAddress(IAddress address) {
        return this.getThread().canResume();
    }

    @Override
    public void resumeAtAddress(IAddress address) throws DebugException {
        if (!this.canResumeAtAddress(address)) {
            return;
        }
        ICDIAddressLocation location = this.getCDITarget().createAddressLocation(new BigInteger(address.toString()));
        try {
            this.getCDIThread().resume(location);
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    @Override
    public boolean canMoveToAddress(IAddress address) {
        return this.getThread().isSuspended() && this.getCDIThread() instanceof ICDIExecuteMoveInstructionPointer;
    }

    @Override
    public void moveToAddress(IAddress address) throws DebugException {
        if (!this.canMoveToAddress(address)) {
            return;
        }
        ICDIAddressLocation location = this.getCDITarget().createAddressLocation(new BigInteger(address.toString()));
        ICDIExecuteMoveInstructionPointer mover = (ICDIExecuteMoveInstructionPointer)((Object)this.getCDIThread());
        try {
            mover.moveInstructionPointer(location);
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    @Override
    public boolean canMoveToLine(String fileName, int lineNumber) {
        return this.getThread().isSuspended() && this.getCDIThread() instanceof ICDIExecuteMoveInstructionPointer;
    }

    @Override
    public void moveToLine(String fileName, int lineNumber) throws DebugException {
        if (!this.canMoveToLine(fileName, lineNumber)) {
            return;
        }
        ICDILineLocation location = this.getCDITarget().createLineLocation(fileName, lineNumber);
        ICDIExecuteMoveInstructionPointer mover = (ICDIExecuteMoveInstructionPointer)((Object)this.getCDIThread());
        try {
            mover.moveInstructionPointer(location);
        }
        catch (CDIException e) {
            CStackFrame.targetRequestFailed(e.getMessage(), e);
        }
    }

    private ICDIThread getCDIThread() {
        return ((CThread)this.getThread()).getCDIThread();
    }
}

