/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.ui;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ptp.internal.remote.ui.OverlayImageDescriptor;
import org.eclipse.ptp.internal.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.internal.remote.ui.RemoteUIImages;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class DeferredFileStore
implements IDeferredWorkbenchAdapter {
    private final IFileStore fFileStore;
    private IFileInfo fFileInfo;
    private IFileInfo fTargetInfo;
    private ImageDescriptor fImage;
    private final boolean fExcludeHidden;

    public DeferredFileStore(IFileStore store, boolean exclude) {
        this(store, null, exclude);
    }

    public DeferredFileStore(IFileStore store, IFileInfo info, boolean exclude) {
        this.fFileStore = store;
        this.fFileInfo = info;
        this.fExcludeHidden = exclude;
    }

    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        ArrayList<DeferredFileStore> children = new ArrayList<DeferredFileStore>();
        try {
            IFileInfo[] childInfos;
            IFileInfo[] iFileInfoArray = childInfos = this.fFileStore.childInfos(0, monitor);
            int n = childInfos.length;
            int n2 = 0;
            while (n2 < n) {
                IFileInfo info = iFileInfoArray[n2];
                if (!this.fExcludeHidden || !info.getName().startsWith(".")) {
                    children.add(new DeferredFileStore(this.fFileStore.getChild(info.getName()), info, this.fExcludeHidden));
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        if (children != null) {
            collector.add(children.toArray(), monitor);
        }
    }

    private void fetchInfo() {
        String target;
        if (this.fFileInfo == null) {
            this.fFileInfo = this.fFileStore.fetchInfo();
        }
        if (this.fTargetInfo == null && this.fFileInfo.getAttribute(32) && (target = this.fFileInfo.getStringAttribute(64)) != null) {
            try {
                URI targetUri = new URI(null, null, target, null);
                URI uri = this.fFileStore.toURI().resolve(targetUri.getRawPath());
                IFileStore store = this.fFileStore.getFileSystem().getStore(uri);
                this.fTargetInfo = store.fetchInfo();
            }
            catch (URISyntaxException e) {
                PTPRemoteUIPlugin.log(e);
            }
        }
    }

    protected IWorkbenchAdapter getAdapter(Object element) {
        return (IWorkbenchAdapter)this.getAdapter(element, IWorkbenchAdapter.class);
    }

    public Object[] getChildren(Object o) {
        try {
            IFileStore[] stores = this.fFileStore.childStores(0, null);
            ArrayList<DeferredFileStore> def = new ArrayList<DeferredFileStore>();
            int i = 0;
            while (i < stores.length) {
                if (!this.fExcludeHidden || !stores[i].getName().startsWith(".")) {
                    def.add(new DeferredFileStore(stores[i], this.fExcludeHidden));
                }
                ++i;
            }
            return def.toArray();
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    public IFileStore getFileStore() {
        return this.fFileStore;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        this.fetchInfo();
        if (this.fImage == null) {
            boolean isDir = this.fFileInfo.isDirectory() || this.fTargetInfo != null && this.fTargetInfo.isDirectory();
            FileSystemElement element = new FileSystemElement(this.fFileStore.getName(), null, isDir);
            IWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                Object imageDesc = adapter.getImageDescriptor(object);
                if (this.fTargetInfo != null) {
                    imageDesc = new OverlayImageDescriptor((ImageDescriptor)imageDesc, RemoteUIImages.DESC_OVR_SYMLINK, 3);
                }
                this.fImage = imageDesc;
            }
        }
        return this.fImage;
    }

    protected Object getAdapter(Object sourceObject, Class adapterType) {
        Object result;
        IAdaptable adaptable;
        Object result2;
        Assert.isNotNull((Object)adapterType);
        if (sourceObject == null) {
            return null;
        }
        if (adapterType.isInstance(sourceObject)) {
            return sourceObject;
        }
        if (sourceObject instanceof IAdaptable && (result2 = (adaptable = (IAdaptable)sourceObject).getAdapter(adapterType)) != null) {
            Assert.isTrue((boolean)adapterType.isInstance(result2));
            return result2;
        }
        if (!(sourceObject instanceof PlatformObject) && (result = Platform.getAdapterManager().getAdapter(sourceObject, adapterType)) != null) {
            return result;
        }
        return null;
    }

    public String getLabel(Object o) {
        return this.fFileStore.getName();
    }

    public Object getParent(Object o) {
        return this.fFileStore.getParent();
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        this.fetchInfo();
        return this.fFileInfo.isDirectory() || this.fTargetInfo != null && this.fTargetInfo.isDirectory();
    }
}

