/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui.analysis;

import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperImages;
import com.nvidia.viper.actions.ResetAnalysisAction;
import com.nvidia.viper.actions.RunAnalysisAction;
import com.nvidia.viper.analysis.AnalysisScope;
import com.nvidia.viper.analysis.AnalysisStage;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.run.IViperRunnerListener;
import com.nvidia.viper.run.Runner;
import com.nvidia.viper.ui.UIUtils;
import com.nvidia.viper.ui.analysis.AnalysisStageControl;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class AnalysisControlComposite
extends Composite {
    private Session activeSession;
    private ToolItem analysisReset;
    private ToolItem analysisCollectAll;
    private Label kernelScopeLabel;
    private AnalysisStage[] analysisStages;
    private List<AnalysisStageControl> analysisStageControls;
    private KernelSelectionMesssageKind kernelSelectionMessageKind;
    private IViperRunnerListener runnerListener = new IViperRunnerListener(){

        @Override
        public void sessionUnlocked() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AnalysisControlComposite.this.refresh();
                }
            });
        }

        @Override
        public void sessionLocked() {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AnalysisControlComposite.this.refresh();
                }
            });
        }
    };

    public AnalysisControlComposite(Composite parent, Composite buttonsParent, int style) {
        super(parent, style);
        this.analysisStageControls = new LinkedList<AnalysisStageControl>();
        this.kernelSelectionMessageKind = KernelSelectionMesssageKind.NONE;
        ToolBar buttonComposite = new ToolBar(buttonsParent, 131072);
        buttonComposite.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        GridLayout bgl = new GridLayout(2, true);
        bgl.marginWidth = 0;
        bgl.marginHeight = 0;
        buttonComposite.setLayout((Layout)bgl);
        this.analysisReset = new ToolItem(buttonComposite, 0);
        this.analysisReset.setText("Reset All");
        this.analysisReset.setImage(ViperImages.get("icons/en/reset_analysis.png"));
        this.analysisReset.setEnabled(false);
        this.analysisReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new ResetAnalysisAction(AnalysisControlComposite.this.activeSession, false).run();
            }
        });
        this.analysisCollectAll = new ToolItem(buttonComposite, 0);
        this.analysisCollectAll.setText("Analyze All");
        this.analysisCollectAll.setImage(ViperImages.get("icons/en/run_analysis.png"));
        this.analysisCollectAll.setEnabled(false);
        this.analysisCollectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new RunAnalysisAction(AnalysisControlComposite.this.activeSession, false, RunAnalysisAction.ShowMode.CURRENT).run();
            }
        });
        this.createStageControls();
        Runner.addListener(this.runnerListener);
    }

    public void dispose() {
        super.dispose();
        Runner.removeListener(this.runnerListener);
    }

    protected boolean controlsNeedUpdate(Analysis analysis) {
        ITimelineInterval interval;
        KernelSelectionMesssageKind ksmk;
        AnalysisStage[] newAnalysisStages;
        AnalysisStage[] analysisStageArray = newAnalysisStages = analysis == null ? new AnalysisStage[]{} : analysis.getOrderedStages();
        if (newAnalysisStages.length != this.analysisStages.length) {
            return true;
        }
        int i = 0;
        while (i < newAnalysisStages.length) {
            if (!newAnalysisStages[i].equals((Object)this.analysisStages[i])) {
                return true;
            }
            ++i;
        }
        return analysis != null && !this.kernelSelectionMessageKind.equals((Object)(ksmk = KernelSelectionMesssageKind.getKindForInterval(interval = analysis.getActiveScopeInterval())));
    }

    protected void createStageControls() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ch = controlArray[n2];
            if (ch instanceof AnalysisStageControl || ch instanceof Label) {
                ch.dispose();
            }
            ++n2;
        }
        Analysis analysis = this.activeSession == null ? null : this.activeSession.getAnalysis();
        this.analysisStageControls.clear();
        this.kernelSelectionMessageKind = KernelSelectionMesssageKind.NONE;
        LinkedHashSet<AnalysisStage> stages = new LinkedHashSet<AnalysisStage>();
        if (analysis != null) {
            ITimelineInterval interval = analysis.getActiveScopeInterval();
            this.kernelSelectionMessageKind = KernelSelectionMesssageKind.getKindForInterval(interval);
            if (!KernelSelectionMesssageKind.NONE.equals((Object)this.kernelSelectionMessageKind)) {
                Label label = new Label((Composite)this, 2112);
                label.setBackground(ColorConstants.white);
                label.setText(this.kernelSelectionMessageKind.getMessage());
                GridData labelLayoutData = new GridData(4, 4, true, false);
                labelLayoutData.widthHint = 150;
                label.setLayoutData((Object)labelLayoutData);
            }
            this.kernelScopeLabel = null;
            AnalysisScope[] analysisScopeArray = analysis.getActiveScopes();
            int n3 = analysisScopeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                AnalysisScope scope = analysisScopeArray[n4];
                if (scope.isEnabled(interval)) {
                    Label label = new Label((Composite)this, 0);
                    UIUtils.boldFont((Control)label);
                    label.setText(scope.getLabel(interval));
                    GridData labelLayoutData = new GridData(256);
                    labelLayoutData.widthHint = 10;
                    label.setLayoutData((Object)labelLayoutData);
                    if (AnalysisScope.KERNEL_INSTANCE.equals((Object)scope)) {
                        this.kernelScopeLabel = label;
                    }
                    AnalysisStage[] scopeStages = scope.getOrderedStages();
                    stages.addAll(Arrays.asList(scopeStages));
                    int i = 0;
                    while (i < scopeStages.length) {
                        AnalysisStage stage = scopeStages[i];
                        AnalysisStageControl asc = new AnalysisStageControl(this, stage, this.activeSession);
                        asc.setLayoutData(new GridData(4, 128, true, false));
                        asc.setEnabled(false);
                        this.analysisStageControls.add(asc);
                        ++i;
                    }
                }
                ++n4;
            }
        }
        this.analysisStages = stages.toArray(new AnalysisStage[stages.size()]);
        this.layout(true);
        this.getParent().layout(true);
    }

    public void refresh() {
        ITimelineInterval interval;
        Analysis analysis;
        Analysis analysis2 = analysis = this.activeSession == null ? null : this.activeSession.getAnalysis();
        if (this.controlsNeedUpdate(analysis)) {
            this.createStageControls();
        }
        if (analysis != null && this.kernelScopeLabel != null && AnalysisScope.KERNEL_INSTANCE.isEnabled(interval = analysis.getActiveScopeInterval())) {
            this.kernelScopeLabel.setText(AnalysisScope.KERNEL_INSTANCE.getLabel(interval));
        }
        boolean resetEnabled = false;
        boolean collectAllEnabled = false;
        if (analysis != null) {
            try {
                for (AnalysisStage stage : analysis.getVisitedStages()) {
                    if (!analysis.getAnalysisResults(stage).isEmpty()) continue;
                    stage.analyze(this.activeSession);
                }
            }
            catch (ViperException e) {
                ViperExceptionHandler.handle("Analysis Failed", "Analysis failed", e);
            }
            AnalysisScope[] analysisScopeArray = analysis.getActiveScopes();
            int n = analysisScopeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AnalysisScope scope = analysisScopeArray[n2];
                switch (scope) {
                    case APPLICATION: {
                        resetEnabled |= !this.activeSession.getTimelines().isEmpty() || analysis != null && !analysis.getVisitedStages().isEmpty();
                        collectAllEnabled |= analysis != null && Runner.getLockedSessions().isEmpty();
                        break;
                    }
                    case KERNEL_INSTANCE: {
                        resetEnabled |= analysis != null && !analysis.getVisitedStages().isEmpty();
                        collectAllEnabled |= analysis != null && Runner.getLockedSessions().isEmpty();
                    }
                }
                ++n2;
            }
        }
        this.analysisReset.setEnabled(resetEnabled);
        this.analysisCollectAll.setEnabled(collectAllEnabled);
        for (AnalysisStageControl asc : this.analysisStageControls) {
            asc.refresh();
        }
    }

    public void setSession(Session activeSession) {
        this.activeSession = activeSession;
        this.createStageControls();
        this.refresh();
    }

    public boolean setFocus() {
        if (this.analysisCollectAll != null) {
            return this.analysisCollectAll.getParent().setFocus();
        }
        return super.setFocus();
    }

    public Control getButtonsControl() {
        return this.analysisReset.getParent();
    }

    private static enum KernelSelectionMesssageKind {
        NONE,
        SELECT_KERNEL,
        SELECT_HOST_KERNEL;


        private String getMessage() {
            switch (this) {
                case SELECT_HOST_KERNEL: {
                    return "Kernel analysis stages are not available for device-launched kernels. To enable kernel analysis stages select a host-launched kernel instance in the timeline.";
                }
                case SELECT_KERNEL: {
                    return "To enable kernel analysis stages select a host-launched kernel instance in the timeline.";
                }
            }
            return null;
        }

        public static KernelSelectionMesssageKind getKindForInterval(ITimelineInterval interval) {
            if (AnalysisScope.KERNEL_INSTANCE.isEnabled(interval)) {
                return NONE;
            }
            if (interval instanceof TimelineIntervalKernel && !((TimelineIntervalKernel)interval).isHostLaunched()) {
                return SELECT_HOST_KERNEL;
            }
            return SELECT_KERNEL;
        }
    }
}

