/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.TimeFormatter;
import com.nvidia.viper.ViperColors;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.rulers.RulerFigure;
import org.eclipse.swt.graphics.Font;

public class TimelineRulerFigure
extends RulerFigure {
    public static final int BORDER_WIDTH = 3;
    public static final int ROI_HEIGHT = 4;
    public static final int ROI_ROUNDING = 8;
    private static final int TEXT_X_MARGIN = 1;
    private static final int TEXT_Y_MARGIN = 1;
    private static final int TEXT_ROUNDING = 4;
    private double xScale = 1.0;
    private List<RulerRoi> rulerRois;
    private RulerRoi dragRoi;
    private long majorInterval = 100000L;

    public TimelineRulerFigure() {
        super(true, 2);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = this.prefSize;
        if (size == null) {
            size = this.getSize();
        }
        size.height = this.textMargin * 2 + this.mediumMarkWidth + 3 + FigureUtilities.getFontMetrics((Font)this.getFont()).getAscent();
        return size;
    }

    public void clearRegionsOfInterest() {
        this.rulerRois = null;
        this.dragRoi = null;
    }

    public void addRegionOfInterest(int uid, boolean selected, int start, int end, String text) {
        if (this.rulerRois == null) {
            this.rulerRois = new LinkedList<RulerRoi>();
        }
        this.rulerRois.add(new RulerRoi(uid, selected, start, end, text));
    }

    public void removeRegionOfInterest(int uid) {
        if (this.rulerRois != null) {
            ListIterator<RulerRoi> iter = this.rulerRois.listIterator();
            while (iter.hasNext()) {
                RulerRoi roi = iter.next();
                if (roi.uid != uid) continue;
                iter.remove();
                break;
            }
        }
    }

    public void addDragRegionOfInterest(int start, int end, String text) {
        this.dragRoi = new RulerRoi(-1, true, start, end, text);
    }

    public void setXScale(double scale) {
        this.xScale = scale;
    }

    public void setMajorInterval(long majorInterval) {
        this.majorInterval = majorInterval;
    }

    protected void paintRegionOfInterest(Graphics g, Rectangle rulerBounds, RulerRoi roi) {
        Rectangle roiBounds = Rectangle.SINGLETON;
        int start = Math.min(roi.start, roi.end);
        int end = Math.max(roi.start, roi.end);
        if (start <= rulerBounds.right() && end >= rulerBounds.x) {
            start = Math.max(start, rulerBounds.x - 8);
            end = Math.min(end, rulerBounds.x + rulerBounds.width + 8);
            roiBounds.x = start;
            roiBounds.y = rulerBounds.y + rulerBounds.height - 4;
            roiBounds.height = 12;
            roiBounds.width = end - start;
            g.pushState();
            g.setAlpha(roi.selected ? 255 : 100);
            g.setBackgroundColor(roi.selected ? ViperColors.REGIONOFINTEREST_SELECTED_BGCOLOR : ViperColors.REGIONOFINTEREST_BGCOLOR);
            g.setForegroundColor(roi.selected ? ViperColors.REGIONOFINTEREST_SELECTED_FGCOLOR : ViperColors.REGIONOFINTEREST_FGCOLOR);
            g.setLineWidth(2);
            g.fillRoundRectangle(roiBounds, 8, 8);
            if (roi.selected && roi.text != null) {
                int leading = FigureUtilities.getFontMetrics((Font)this.getFont()).getLeading();
                Dimension textSize = FigureUtilities.getStringExtents((String)roi.text, (Font)this.getFont());
                if (textSize.width % 2 == 0) {
                    ++textSize.width;
                }
                textSize.expand(2, leading + 2);
                Point center = new Point(roiBounds.x + roiBounds.width / 2, roiBounds.y - textSize.height / 2);
                Point textLoc = new Point(center.x - textSize.width / 2, center.y - textSize.height / 2);
                Rectangle textBounds = new Rectangle(textLoc.x, textLoc.y, textSize.width, textSize.height);
                g.fillRoundRectangle(textBounds, 4, 4);
                g.setForegroundColor(ColorConstants.white);
                g.drawText(roi.text, textBounds.x + 1, textBounds.y + 1);
            }
            g.popState();
        }
    }

    public void paintFigure(Graphics g) {
        long mod;
        Rectangle clip = g.getClip(new Rectangle());
        Rectangle clippedBounds = this.getClientArea().intersect(clip);
        int leading = FigureUtilities.getFontMetrics((Font)this.getFont()).getLeading();
        clippedBounds.height -= 3;
        g.fillRectangle(clippedBounds);
        long startNS = (long)Math.ceil((double)clippedBounds.x / this.xScale) - this.majorInterval;
        long endNS = startNS + (long)Math.ceil((double)clippedBounds.width / this.xScale) + 2L * this.majorInterval;
        TimeFormatter formatter = new TimeFormatter(this.majorInterval * 1000L);
        do {
            if ((mod = startNS % this.majorInterval) != 0L) continue;
            String text = formatter.format(startNS, false);
            Dimension textSize = FigureUtilities.getStringExtents((String)text, (Font)this.getFont());
            if (textSize.width % 2 == 0) {
                ++textSize.width;
            }
            double x = (double)startNS * this.xScale;
            Point textLoc = new Point((int)(x - (double)(textSize.width / 2)), clippedBounds.y + this.textMargin - leading);
            g.drawText(text, textLoc);
            Point markTop = new Point((int)x, clippedBounds.y + clippedBounds.height);
            Point markBottom = new Point((int)x, markTop.y - this.mediumMarkWidth);
            g.drawLine(markTop, markBottom);
        } while ((startNS += this.majorInterval - mod) < endNS);
        if (this.rulerRois != null) {
            ListIterator<RulerRoi> iter = this.rulerRois.listIterator(this.rulerRois.size());
            while (iter.hasPrevious()) {
                this.paintRegionOfInterest(g, clippedBounds, iter.previous());
            }
        }
        if (this.dragRoi != null) {
            this.paintRegionOfInterest(g, clippedBounds, this.dragRoi);
        }
        clippedBounds.height += 3;
        g.setForegroundColor(ColorConstants.buttonDarker);
        g.drawLine(clippedBounds.getBottomLeft().translate(-1, -1), clippedBounds.getBottomRight().translate(-1, -1));
    }

    private static class RulerRoi {
        public int uid;
        public boolean selected;
        public int start;
        public int end;
        public String text;

        public RulerRoi(int uid, boolean selected, int start, int end, String text) {
            this.uid = uid;
            this.selected = selected;
            this.start = start;
            this.end = end;
            this.text = text;
        }
    }
}

