/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.Activator;
import com.nvidia.viper.editor.ISourceMappingRule;
import com.nvidia.viper.editor.RulesConfiguration;
import com.nvidia.viper.fs.LocalFileSystem;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public final class PathMappingWizardPage
extends WizardPage {
    private static final IPath NO_PATH = new Path("");
    private Font font;
    private Button removeMapping;
    private final MappingNode root;
    private TreeViewer viewer;
    private final RulesConfiguration rule;

    private MappingNode flatten(MappingNode node) {
        Collection<MappingNode> children = node.getChildren();
        ArrayList<MappingNode> flat = new ArrayList<MappingNode>(children.size());
        for (MappingNode child : children) {
            flat.add(this.flatten(child));
        }
        if (node.parent != null && flat.size() == 1) {
            MappingNode onlyChild = (MappingNode)flat.get(0);
            MappingNode result = new MappingNode(node.parent, node.path.append(onlyChild.path), onlyChild.isBranch() ? null : onlyChild.getUri());
            result.setChildren(onlyChild.getChildren());
            return result;
        }
        node.setChildren(flat);
        return node;
    }

    public boolean resolved(MappingNode mappingNode) {
        return this.getMapping(mappingNode) != null;
    }

    private MappingNode makeTreeShallow(MappingNode node, Set<MappingNode> nodes) {
        for (MappingNode child : nodes) {
            IPath path = child.path;
            MappingNode parent = node.getChild(path.removeLastSegments(1));
            parent.addChild(new MappingNode(parent, (IPath)new Path(path.lastSegment()), child.isBranch() ? null : child.getUri()));
        }
        return this.flatten(node);
    }

    protected MappingNode prepareViewModel(Collection<URI> uris) {
        MappingNode node = new MappingNode();
        TreeSet<MappingNode> nodes = new TreeSet<MappingNode>();
        for (URI uri : uris) {
            nodes.add(new MappingNode(node, uri));
        }
        MappingNode root = this.makeTreeShallow(node, nodes);
        return root;
    }

    public PathMappingWizardPage(Collection<URI> uris, RulesConfiguration rule) {
        super("Path Mapping Wizard Main Page", "Configure source file locations", null);
        this.rule = rule;
        this.setDescription("Map source file paths from your profiler session to local file locations.");
        this.root = this.prepareViewModel(uris);
    }

    public void createControl(Composite parent) {
        Composite pane = new Composite(parent, 0);
        pane.setLayout((Layout)new GridLayout(2, true));
        Composite composite = new Composite(pane, 0);
        composite.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        GridData gd_composite = new GridData(1808);
        gd_composite.widthHint = 950;
        gd_composite.heightHint = 500;
        gd_composite.horizontalSpan = 2;
        composite.setLayoutData((Object)gd_composite);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        composite.setLayout((Layout)columnLayout);
        this.viewer = new TreeViewer(composite, 67588);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PathMappingWizardPage.this.updateUnMapEnablement(event.getSelection());
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                PathMappingWizardPage.this.map();
            }
        });
        Tree tree = this.viewer.getTree();
        tree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PathMappingWizardPage.this.font != null) {
                    PathMappingWizardPage.this.font.dispose();
                }
            }
        });
        tree.setLinesVisible(true);
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    PathMappingWizardPage.this.unmap();
                }
            }
        });
        tree.setHeaderVisible(true);
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.viewer, 0);
        TreeColumn trclmnOriginal = treeViewerColumn.getColumn();
        columnLayout.setColumnData((Widget)trclmnOriginal, (ColumnLayoutData)new ColumnWeightData(1, 20, false));
        trclmnOriginal.setResizable(false);
        trclmnOriginal.setText("Source File");
        treeViewerColumn.setLabelProvider((CellLabelProvider)new BaseColumnProvider(){

            public Image getImage(Object element) {
                ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
                if (((MappingNode)element).isBranch()) {
                    return images.getImage("IMG_OBJ_FOLDER");
                }
                return images.getImage("IMG_OBJ_FILE");
            }

            public String getText(Object element) {
                return ((MappingNode)element).path.toOSString();
            }
        });
        TreeViewerColumn treeViewerColumn_1 = new TreeViewerColumn(this.viewer, 0);
        TreeColumn trclmnNewColumn = treeViewerColumn_1.getColumn();
        columnLayout.setColumnData((Widget)trclmnNewColumn, (ColumnLayoutData)new ColumnWeightData(1, 20, false));
        trclmnNewColumn.setResizable(false);
        trclmnNewColumn.setText("Local File");
        treeViewerColumn_1.setLabelProvider((CellLabelProvider)new BaseColumnProvider(){

            public String getText(Object element) {
                ISourceMappingRule.SourceMapping file = PathMappingWizardPage.this.getMapping((MappingNode)element);
                if (file == null) {
                    return "";
                }
                if (file.uri == null) {
                    return "<Unmapped>";
                }
                return file == null ? "" : file.uri.getPath();
            }
        });
        this.setControl((Control)pane);
        Button btnNewButton = new Button(pane, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathMappingWizardPage.this.map();
            }
        });
        btnNewButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnNewButton.setText("Add Mapping...");
        this.viewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public Object[] getChildren(Object parentElement) {
                return ((MappingNode)parentElement).getChildren().toArray();
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object getParent(Object element) {
                return ((MappingNode)element).parent;
            }

            public boolean hasChildren(Object element) {
                return !((MappingNode)element).getChildren().isEmpty();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.viewer.setInput((Object)this.root);
        this.viewer.expandAll();
        this.removeMapping = new Button(pane, 0);
        this.removeMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathMappingWizardPage.this.unmap();
            }
        });
        this.removeMapping.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.removeMapping.setText("Remove Mapping");
        this.updateUnMapEnablement(this.viewer.getSelection());
        this.refresh(false);
    }

    protected URI getMappedURI(MappingNode element) {
        ISourceMappingRule.SourceMapping mapping = this.getMapping(element);
        return mapping != null ? mapping.uri : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Font makeBold(Font originalFont) {
        if (this.font == null) {
            PathMappingWizardPage pathMappingWizardPage = this;
            synchronized (pathMappingWizardPage) {
                if (this.font == null) {
                    FontData[] fontData;
                    FontData[] fontDataArray = fontData = originalFont.getFontData();
                    int n = fontData.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FontData element = fontDataArray[n2];
                        element.setStyle(element.getStyle() | 1);
                        ++n2;
                    }
                    this.font = new Font((Device)this.getShell().getDisplay(), fontData);
                }
            }
        }
        return this.font;
    }

    protected void map() {
        Object element;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && (element = selection.getFirstElement()) instanceof MappingNode) {
            MappingNode node = (MappingNode)element;
            URI path = this.getMappedURI(node);
            if (node.isBranch()) {
                DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 0);
                dialog.setText("Find Directory");
                if (path != null) {
                    dialog.setFilterPath(path.getPath());
                } else {
                    dialog.setFilterPath(node.path.lastSegment());
                }
                String sel = dialog.open();
                if (sel != null) {
                    this.map(node, new File(sel).toURI());
                    this.refresh(true);
                }
            } else {
                String fileName = null;
                if (path == null) {
                    fileName = node.path.lastSegment();
                } else {
                    File f = new File(path);
                    if (f.exists()) {
                        String prefPath = null;
                        prefPath = f.isDirectory() ? f.getPath() : f.getParent();
                        Activator.getDefault().getPreferenceStore().setValue("PathMappingWizardPath", prefPath);
                    }
                    fileName = f.getName();
                }
                String sel = LocalFileSystem.browseForFileOpen(this.getShell(), "Find Source File Location", fileName, "PathMappingWizardPath");
                if (sel != null) {
                    this.map(node, new File(sel).toURI());
                    this.refresh(true);
                }
            }
        }
    }

    private void map(MappingNode node, URI uri) {
        this.rule.addMapping(node.getFullPath().toString(), uri);
    }

    private void refresh(boolean showWarning) {
        this.viewer.refresh();
        boolean complete = this.root.isComplete();
        if (showWarning && !complete) {
            this.setMessage("Not all source files were found on the local filesystem", 2);
        } else {
            this.setMessage(null);
        }
        this.updateUnMapEnablement(this.viewer.getSelection());
        this.setPageComplete(true);
    }

    protected void unmap() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            MappingNode node = (MappingNode)selection.getFirstElement();
            this.rule.removeMapping(node.getUri());
            this.refresh(true);
        }
    }

    private void updateUnMapEnablement(ISelection sel) {
        boolean enable = false;
        if (!sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            ISourceMappingRule.SourceMapping mapping = this.getMapping((MappingNode)selection.getFirstElement());
            enable = mapping != null;
        }
        this.removeMapping.setEnabled(enable);
    }

    private ISourceMappingRule.SourceMapping getMapping(MappingNode node) {
        URI uri = node.getUri();
        return this.rule.map(uri);
    }

    private abstract class BaseColumnProvider
    extends ColumnLabelProvider {
        private BaseColumnProvider() {
        }

        public Font getFont(Object element) {
            ISourceMappingRule.SourceMapping mapping = PathMappingWizardPage.this.getMapping((MappingNode)element);
            if (mapping != null && mapping.userMapping) {
                return PathMappingWizardPage.this.makeBold(PathMappingWizardPage.this.viewer.getControl().getFont());
            }
            return null;
        }

        public Color getForeground(Object element) {
            ISourceMappingRule.SourceMapping path = PathMappingWizardPage.this.getMapping((MappingNode)element);
            if (path != null && !path.userMapping) {
                return PathMappingWizardPage.this.viewer.getControl().getDisplay().getSystemColor(33);
            }
            return null;
        }
    }

    protected final class MappingNode
    implements Comparable<MappingNode> {
        private final Collection<MappingNode> children = new TreeSet<MappingNode>();
        public MappingNode parent;
        public final IPath path;
        private final URI uri;

        public MappingNode() {
            this(null, NO_PATH, null);
        }

        public MappingNode(MappingNode parent, IPath path, URI uri) {
            this.parent = parent;
            this.path = path;
            this.uri = uri;
        }

        public MappingNode(MappingNode parent, URI uri) {
            this(parent, (IPath)new Path(uri.getPath()), uri);
        }

        public void addChild(MappingNode child) {
            this.children.add(child);
        }

        @Override
        public int compareTo(MappingNode o) {
            if (o == null) {
                return 1;
            }
            if (o == this) {
                return 0;
            }
            if (this.parent == o.parent || this.parent != null && this.parent.compareTo(o.parent) == 0) {
                return this.path.toString().compareTo(o.path.toOSString());
            }
            if (this.parent == null) {
                return -1;
            }
            return this.parent.compareTo(o.parent);
        }

        public boolean equals(Object obj) {
            return obj instanceof MappingNode && this.compareTo((MappingNode)obj) == 0;
        }

        public MappingNode getChild(IPath path) {
            if (path.segmentCount() == 0) {
                return this;
            }
            MappingNode node = null;
            for (MappingNode child : this.children) {
                if (!child.path.isPrefixOf(path)) continue;
                node = child;
                break;
            }
            if (node == null) {
                node = new MappingNode(this, (IPath)new Path(path.segment(0)), null);
                this.children.add(node);
            }
            return node.getChild(path.removeFirstSegments(node.path.segmentCount()));
        }

        public Collection<MappingNode> getChildren() {
            return Collections.unmodifiableCollection(this.children);
        }

        public int hashCode() {
            return this.path.hashCode() * 13 + (this.parent != null ? this.parent.hashCode() * 31 : 0);
        }

        public boolean isComplete() {
            if (this.isBranch() || PathMappingWizardPage.this.resolved(this)) {
                for (MappingNode child : this.getChildren()) {
                    if (child.isComplete()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public void setChildren(Collection<MappingNode> flat) {
            this.children.clear();
            this.children.addAll(flat);
            for (MappingNode child : this.children) {
                child.parent = this;
            }
        }

        public String toString() {
            return String.format("%s -> %s", this.path, this.isBranch() ? null : this.getUri());
        }

        public URI getUri() {
            return this.uri != null ? this.uri : this.getFullPath().makeAbsolute().toFile().toURI();
        }

        private IPath getFullPath() {
            IPath fullPath = this.parent != null ? this.parent.getFullPath().append(this.path) : this.path;
            return fullPath;
        }

        public boolean isBranch() {
            return this.uri == null;
        }
    }
}

