/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.ui;

import com.nvidia.viper.FileUtils;
import com.nvidia.viper.Viper;
import com.nvidia.viper.ViperException;
import com.nvidia.viper.ViperExceptionHandler;
import com.nvidia.viper.ViperMessages;
import com.nvidia.viper.jni.CUptiResult;
import com.nvidia.viper.jni.CuptiException;
import com.nvidia.viper.jni.NativeCupti;
import com.nvidia.viper.model.Analysis;
import com.nvidia.viper.model.Expert;
import com.nvidia.viper.model.ExpertSystem;
import com.nvidia.viper.model.ProfileDataModel;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.ui.ImportNvprofMultiProcessPage;
import com.nvidia.viper.ui.ImportNvprofOptionsPage;
import com.nvidia.viper.ui.ImportNvprofSingleProcessPage;
import com.nvidia.viper.ui.LargeDataMessageDialog;
import com.nvidia.viper.ui.SessionEditor;
import com.nvidia.viper.ui.SessionEditorInput;
import com.nvidia.viper.ui.ViperMessageDialog;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ImportNvprofWizard
extends Wizard
implements IImportWizard {
    private ImportNvprofSingleProcessPage singleProcessPage;
    private ImportNvprofOptionsPage primaryPage;
    private ImportNvprofMultiProcessPage multiProcessPage;

    public ImportNvprofWizard() {
        this.setWindowTitle(ViperMessages.ImportNvprof_Wizard_Title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        try {
            PdmImportRunnable runnable = null;
            if (this.primaryPage.importSingleProcess()) {
                String filename = this.singleProcessPage.getTimelineFilePath();
                String[] filenames = this.singleProcessPage.getAdditionalFilePaths();
                runnable = new SingleProcessPdmRunnable(filename, filenames);
            } else {
                runnable = new MultiProcessPdmRunnable(this.multiProcessPage.getFilePaths());
            }
            this.getContainer().run(true, true, (IRunnableWithProgress)runnable);
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                ViperExceptionHandler.handle(ViperMessages.ImportNvprof_Fail_Title, ViperMessages.ImportNvprof_Fail_Message, (ViperException)e);
            }
        }
        catch (OutOfMemoryError e) {
            ViperExceptionHandler.logError("Out of memory error", e);
            LargeDataMessageDialog.show();
        }
        Viper.closeWelcomePage(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return true;
    }

    public static void importNvprofFilesIntoSession(String[] filenames, Session session) {
        if (session != null && filenames != null) {
            boolean completeProfileData = true;
            boolean completeMerge = true;
            String[] stringArray = filenames;
            int n = filenames.length;
            int n2 = 0;
            while (n2 < n) {
                block24: {
                    ProfileDataModel pdm;
                    block23: {
                        String filename = stringArray[n2];
                        File file = new File(filename);
                        pdm = null;
                        pdm = new ProfileDataModel();
                        try {
                            if (System.getenv("__LARGE_PDM") != null) {
                                pdm.readUsingCorrelationId(file, session);
                            } else {
                                pdm.read(file);
                            }
                        }
                        catch (ViperException e) {
                            completeProfileData = false;
                            Throwable cause = e.getCause();
                            if (cause instanceof CuptiException && CUptiResult.CUPTI_ERROR_NOT_COMPATIBLE.equals((Object)((CuptiException)cause).getCuptiResult())) break block23;
                            if (pdm != null) {
                                pdm.dispose();
                            }
                            break block24;
                        }
                    }
                    try {
                        if (!session.mergeTimelines(pdm, null, true, true, true, null)) {
                            completeMerge = false;
                        }
                    }
                    catch (ViperException e) {
                        if (!(e instanceof ViperException)) {
                            e = new ViperException(e);
                        }
                        ViperExceptionHandler.handle(ViperMessages.ImportMultipleNvprof_Fail_Title, ViperMessages.ImportMultipleNvprof_Fail_Message, e);
                        if (pdm != null) {
                            pdm.dispose();
                        }
                        break block24;
                    }
                    catch (OutOfMemoryError e) {
                        try {
                            ViperExceptionHandler.logError("Out of memory error", e);
                            LargeDataMessageDialog.show();
                            break block24;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (pdm != null) {
                                pdm.dispose();
                            }
                        }
                    }
                    if (pdm == null) break block24;
                    pdm.dispose();
                }
                ++n2;
            }
            if (!completeProfileData || !completeMerge) {
                String msg = "";
                if (!completeProfileData) {
                    msg = String.valueOf(msg) + "One or more sets of profile data are incomplete.\n";
                }
                if (!completeMerge) {
                    msg = String.valueOf(msg) + "Some collected events or source-level results could not be associated with the session timeline.";
                }
                if (!msg.isEmpty()) {
                    ViperMessageDialog.openWarning(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Import nvprof data files", msg);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Session importNvprofTimelineFiles(String[] filePaths) throws ViperException {
        if (filePaths != null && filePaths.length > 0) {
            block21: {
                block20: {
                    session = null;
                    pdms = new ProfileDataModel[filePaths.length];
                    try {
                        normalizeTime = 0x7FFFFFFFFFFFFFFFL;
                        session = new Session();
                        files = new File[filePaths.length];
                        i = 0;
                        while (i < filePaths.length) {
                            files[i] = file = new File(filePaths[i]);
                            pdm = new ProfileDataModel();
                            if (System.getenv("__LARGE_PDM") != null) {
                                pdm.readUsingSizeTime(file, session);
                            } else {
                                pdm.read(file);
                            }
                            time = NativeCupti.cuptiPDMGetNormalizeTime(pdm.getNativeHandle());
                            if (time < normalizeTime) {
                                normalizeTime = time;
                            }
                            pdms[i] = pdm;
                            ++i;
                        }
                        if (!FileUtils.canLoad(files)) {
                            LargeDataMessageDialog.show();
                            throw new ViperException("LoadPdmCancel");
                        }
                        var9_14 = pdms;
                        var8_12 = pdms.length;
                        var7_10 = 0;
                        while (var7_10 < var8_12) {
                            pdm = var9_14[var7_10];
                            pdm.normalizeTimestamps(normalizeTime);
                            ++var7_10;
                        }
                        session.setTimelinesMultiplePdms(pdms);
                        Display.getDefault().syncExec((Runnable)new UpdateSessionRunnable(session, new File(filePaths[0]).getName()));
                        break block20;
                    }
                    catch (Exception e) {
                        if (e instanceof ViperException) {
                            throw (ViperException)e;
                        }
                        var15_15 = pdms;
                        var14_18 = pdms.length;
                        var13_21 = 0;
                        ** while (var13_21 < var14_18)
                    }
lbl-1000:
                    // 1 sources

                    {
                        pdm = var15_15[var13_21];
                        if (pdm != null) {
                            pdm.dispose();
                        }
                        ++var13_21;
                        continue;
lbl49:
                        // 1 sources

                        break block21;
                    }
                    {
                        catch (OutOfMemoryError e) {
                            try {
                                throw e;
                            }
                            catch (Throwable var11_27) {
                                var15_16 = pdms;
                                var14_19 = pdms.length;
                                var13_22 = 0;
                                ** while (var13_22 < var14_19)
                            }
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        pdm = var15_16[var13_22];
                        if (pdm != null) {
                            pdm.dispose();
                        }
                        ++var13_22;
                        continue;
                    }
lbl63:
                    // 1 sources

                    throw var11_27;
                }
                var15_17 = pdms;
                var14_20 = pdms.length;
                var13_23 = 0;
                while (var13_23 < var14_20) {
                    pdm = var15_17[var13_23];
                    if (pdm != null) {
                        pdm.dispose();
                    }
                    ++var13_23;
                }
            }
            return session;
        }
        return null;
    }

    public static Session importNvprofTimelineFile(String filename) throws Exception {
        Session session = null;
        try {
            session = ImportNvprofWizard.importNvprofTimelineFileThrowsException(filename);
        }
        catch (Exception e) {
            if (e instanceof ViperException) {
                throw e;
            }
        }
        catch (OutOfMemoryError e) {
            throw e;
        }
        return session;
    }

    public static Session importNvprofTimelineFileThrowsException(String filename) throws ViperException, CoreException {
        if (filename != null) {
            File file = new File(filename);
            Session session = null;
            ProfileDataModel pdm = null;
            try {
                try {
                    session = new Session();
                    pdm = new ProfileDataModel();
                    if (System.getenv("__LARGE_PDM") != null) {
                        pdm.readUsingSizeTime(file, session);
                    } else {
                        pdm.read(file);
                    }
                    long NormalizeTime = NativeCupti.cuptiPDMGetNormalizeTime(pdm.getNativeHandle());
                    pdm.normalizeTimestamps(NormalizeTime);
                    session.setTimelines(pdm);
                    Display.getDefault().syncExec((Runnable)new UpdateSessionRunnable(session, file.getName()));
                }
                catch (CuptiException e) {
                    throw new ViperException(e);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
            }
            finally {
                if (pdm != null) {
                    pdm.dispose();
                }
            }
            return session;
        }
        return null;
    }

    private static void updateSessionSettings(Session session, String sessionName) throws PartInitException {
        SessionEditor editor;
        IWorkbenchPage activePage;
        IWorkbenchWindow workbenchWindow;
        session.setExpert(new Expert());
        session.setAnalysis(new Analysis());
        session.setExpertSystem(new ExpertSystem(session));
        session.setName(sessionName);
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null && (activePage = workbenchWindow.getActivePage()) != null && (editor = (SessionEditor)activePage.openEditor((IEditorInput)new SessionEditorInput(session), "com.nvidia.viper.sessioneditor")) != null) {
            editor.scaleToFit();
            editor.setDirty(true);
            session.setDirty(true);
        }
    }

    public void addPages() {
        this.primaryPage = new ImportNvprofOptionsPage("Import nvprof");
        this.addPage((IWizardPage)this.primaryPage);
        this.singleProcessPage = new ImportNvprofSingleProcessPage("Import nvprof");
        this.addPage((IWizardPage)this.singleProcessPage);
        this.multiProcessPage = new ImportNvprofMultiProcessPage("Import nvprof");
        this.addPage((IWizardPage)this.multiProcessPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage currentPage) {
        if (currentPage instanceof ImportNvprofOptionsPage) {
            if (this.primaryPage.importSingleProcess()) {
                return this.singleProcessPage;
            }
            return this.multiProcessPage;
        }
        return super.getNextPage(currentPage);
    }

    public boolean canFinish() {
        if (this.primaryPage.isCurrent()) {
            return false;
        }
        if (this.singleProcessPage.isCurrent() && this.singleProcessPage.isPageComplete()) {
            return true;
        }
        if (this.multiProcessPage.isCurrent() && this.multiProcessPage.isPageComplete()) {
            return true;
        }
        return super.canFinish();
    }

    private class MultiProcessPdmRunnable
    extends PdmImportRunnable {
        public MultiProcessPdmRunnable(String[] filenames) {
            super(filenames);
        }

        @Override
        protected void performImport() throws Exception {
            ImportNvprofWizard.importNvprofTimelineFiles(this.filenames);
        }
    }

    private abstract class PdmImportRunnable
    implements IRunnableWithProgress {
        protected String[] filenames;

        public PdmImportRunnable(String[] filenames) {
            this.filenames = filenames;
        }

        protected abstract void performImport() throws Exception;

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask("Import nvprof profile data...", -1);
            Thread thread = new Thread("LoadPdm"){

                @Override
                public void run() {
                    try {
                        PdmImportRunnable.this.performImport();
                    }
                    catch (Exception e) {
                        ViperException ex;
                        if (e instanceof ViperException && !(ex = (ViperException)e).getMessage().endsWith("LoadPdmCancel")) {
                            ViperExceptionHandler.handle(ViperMessages.ImportNvprof_Fail_Title, ViperMessages.ImportNvprof_Fail_Message, ex);
                        }
                    }
                    catch (OutOfMemoryError e) {
                        ViperExceptionHandler.logError("Out of memory error", e);
                        LargeDataMessageDialog.show();
                    }
                }
            };
            thread.start();
            while (thread != null && thread.isAlive()) {
                if (!monitor.isCanceled()) continue;
                thread.interrupt();
            }
        }
    }

    private class SingleProcessPdmRunnable
    extends PdmImportRunnable {
        private String timelineFile;

        SingleProcessPdmRunnable(String timelineFile, String[] otherFiles) {
            super(otherFiles);
            this.timelineFile = timelineFile;
        }

        @Override
        protected void performImport() throws Exception {
            Session session = ImportNvprofWizard.importNvprofTimelineFile(this.timelineFile);
            ImportNvprofWizard.importNvprofFilesIntoSession(this.filenames, session);
        }
    }

    private static class UpdateSessionRunnable
    implements Runnable {
        private Session session;
        private String name;

        public UpdateSessionRunnable(Session session, String name) {
            this.session = session;
            this.name = name;
        }

        @Override
        public void run() {
            try {
                ImportNvprofWizard.updateSessionSettings(this.session, this.name);
            }
            catch (PartInitException partInitException) {
                ViperExceptionHandler.handle(ViperMessages.ImportMultipleNvprof_Fail_Title, ViperMessages.ImportMultipleNvprof_Fail_Message, null);
            }
        }
    }
}

